/*
 * Decompiled with CFR 0.152.
 */
package com.jdcloud.sdk.client;

import com.google.api.client.http.ByteArrayContent;
import com.google.api.client.http.GenericUrl;
import com.google.api.client.http.HttpContent;
import com.google.api.client.http.HttpHeaders;
import com.google.api.client.http.HttpRequest;
import com.google.api.client.http.HttpResponse;
import com.google.api.client.http.HttpResponseException;
import com.google.gson.ExclusionStrategy;
import com.google.gson.FieldAttributes;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.jdcloud.sdk.JdcloudSdkException;
import com.jdcloud.sdk.annotation.Required;
import com.jdcloud.sdk.auth.sign.SignatureComposer;
import com.jdcloud.sdk.client.JdcloudClient;
import com.jdcloud.sdk.http.SdkHttpMethod;
import com.jdcloud.sdk.model.SignRequest;
import com.jdcloud.sdk.service.Exclude;
import com.jdcloud.sdk.service.JdcloudHttpResponse;
import com.jdcloud.sdk.service.JdcloudRequest;
import com.jdcloud.sdk.service.JdcloudResponse;
import com.jdcloud.sdk.utils.Base64Utils;
import com.jdcloud.sdk.utils.BinaryUtils;
import com.jdcloud.sdk.utils.SdkHttpUtils;
import com.jdcloud.sdk.utils.StringUtils;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.Field;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.http.Header;
import org.apache.http.NoHttpResponseException;
import org.apache.http.cookie.Cookie;
import org.apache.http.impl.client.BasicCookieStore;
import org.apache.http.impl.cookie.DefaultCookieSpec;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class JdcloudExecutor {
    private static Logger logger = LoggerFactory.getLogger(JdcloudExecutor.class);
    private static String dateFormat = "yyyy-MM-dd'T'HH:mm:ss";
    private static String charset = "UTF-8";
    private final int RETRY_MAX_TIMES = 3;
    private static Pattern pattern = Pattern.compile("\\{([a-zA-Z0-9-_]+)\\}");
    private static Set<String> base64Headers = new HashSet<String>(){
        private static final long serialVersionUID = 1L;
        {
            this.add("x-jdcloud-security-token");
            this.add("x-jdcloud-pin");
            this.add("x-jdcloud-erp");
        }
    };
    protected JdcloudClient jdcloudClient;

    public abstract String method();

    public abstract String url();

    public abstract Class<? extends JdcloudResponse> returnType();

    public JdcloudExecutor client(JdcloudClient client) {
        this.jdcloudClient = client;
        return this;
    }

    public <R1 extends JdcloudResponse, R2 extends JdcloudRequest> R1 execute(R2 request) {
        String version = request.getJdcloudVersion();
        version = this.checkImportantParams(version);
        this.checkRequest(request);
        HttpResponse httpResponse = null;
        try {
            String uri = this.replaceUrl(this.url(), request);
            StringBuilder host = new StringBuilder().append(this.jdcloudClient.getHttpRequestConfig().getProtocol().toString()).append("://").append(this.jdcloudClient.getEndpoint());
            StringBuilder signingHost = StringUtils.isNotBlank(this.jdcloudClient.getRealEndPoints()) ? new StringBuilder().append(this.jdcloudClient.getHttpRequestConfig().getProtocol().toString()).append("://").append(this.jdcloudClient.getRealEndPoints()) : host;
            StringBuilder path = new StringBuilder().append("/").append(version).append(uri);
            StringBuilder params = new StringBuilder(this.getParams(request));
            logger.debug("http request url: {}{}{}", new Object[]{host, path, params});
            ByteArrayContent bodyContent = null;
            String content = this.content(request);
            if (content != null && content.length() > 0) {
                bodyContent = ByteArrayContent.fromString((String)"application/json", (String)content);
            }
            if (this.jdcloudClient.httpRequestFactory == null) {
                this.jdcloudClient.init();
            }
            String requestPath = SdkHttpUtils.urlEncode(path.toString(), true);
            HttpRequest httpRequest = this.jdcloudClient.buildRequest(this.method(), new GenericUrl(host.toString() + requestPath + params.toString()), (HttpContent)bodyContent);
            httpRequest.getHeaders().setUserAgent(this.jdcloudClient.getUserAgent());
            httpRequest.getHeaders().setContentType("application/json");
            this.setCustomHeader(httpRequest.getHeaders());
            SignRequest signRequest = new SignRequest(signingHost.toString(), path.toString(), request.getRegionId(), this.jdcloudClient.getServiceName(), httpRequest, this.jdcloudClient.getCredentialsProvider().getCredentials());
            SignatureComposer signer = new SignatureComposer();
            signer.sign(signRequest);
            logger.debug("Authorization: {}", (Object)httpRequest.getHeaders().getAuthorization());
            this.setCookie(request.getCookies(), httpRequest.getHeaders());
            for (int times = 1; times < 3 && this.jdcloudClient.isRetryQuest(); ++times) {
                JdcloudResponse jdcloudResponse;
                try {
                    httpResponse = httpRequest.execute();
                    jdcloudResponse = this.handlerHttpResponse(httpResponse);
                }
                catch (NoHttpResponseException e) {
                    Thread.sleep(100L);
                    continue;
                }
                return (R1)jdcloudResponse;
            }
            httpResponse = httpRequest.execute();
        }
        catch (HttpResponseException e) {
            logger.error(e.getContent());
            if (e.getContent() == null) {
                throw new JdcloudSdkException(e);
            }
            JdcloudResponse response = this.jdcloudClient.readValue(e.getContent(), this.returnType());
            if (null == response) {
                throw new JdcloudSdkException("Illegal Content");
            }
            JdcloudResponse jdcloudResponse = response;
            return (R1)jdcloudResponse;
        }
        catch (Exception e) {
            throw new JdcloudSdkException(e);
        }
        finally {
            if (httpResponse != null) {
                try {
                    httpResponse.disconnect();
                }
                catch (Exception e) {
                    logger.error(e.getMessage());
                }
            }
        }
        JdcloudResponse jdcloudResponse = this.handlerHttpResponse(httpResponse);
        return (R1)jdcloudResponse;
    }

    public String replaceUrl(String httpUrl, JdcloudRequest request) {
        if (httpUrl == null || httpUrl.length() == 0) {
            return "";
        }
        if (httpUrl.indexOf(123) < 0) {
            return httpUrl;
        }
        Matcher matcher = pattern.matcher(httpUrl);
        StringBuffer url = new StringBuffer();
        while (matcher.find()) {
            String fieldName = matcher.group(1);
            String replaceValue = Matcher.quoteReplacement(this.getRequestValue(fieldName, request));
            matcher.appendReplacement(url, replaceValue);
        }
        matcher.appendTail(url);
        return url.toString();
    }

    private void checkRequest(Object request) {
        Field[] array = request.getClass().getDeclaredFields();
        try {
            for (Field field : array) {
                if (!field.isAnnotationPresent(Required.class)) continue;
                field.setAccessible(true);
                Object value = field.get(request);
                if (value != null) continue;
                logger.info("\u5b57\u6bb5{}\u4e0d\u80fd\u4e3anull", (Object)field.getName());
                throw new JdcloudSdkException("\u5b57\u6bb5" + field.getName() + "\u4e0d\u80fd\u4e3anull");
            }
        }
        catch (IllegalAccessException | IllegalArgumentException e) {
            throw new JdcloudSdkException(e);
        }
    }

    protected String checkImportantParams(String v) {
        String version = v;
        if (version == null || version.length() == 0) {
            version = this.jdcloudClient.getVersion();
        }
        if (version == null || version.length() == 0) {
            throw new JdcloudSdkException("version not set.");
        }
        if (this.jdcloudClient == null) {
            throw new JdcloudSdkException("jdcloudClient not set.");
        }
        if (this.jdcloudClient.getEndpoint() == null || this.jdcloudClient.getEndpoint().length() == 0) {
            throw new JdcloudSdkException("endpoint not set.");
        }
        if (this.jdcloudClient.getServiceName() == null) {
            throw new JdcloudSdkException("serviceName not set.");
        }
        return version;
    }

    protected JdcloudResponse handlerHttpResponse(HttpResponse httpResponse) throws IOException, IllegalAccessException, InstantiationException {
        JdcloudResponse response = this.returnType().newInstance();
        byte[] content = null;
        if (httpResponse.getContent() != null && httpResponse.getStatusCode() != 204 && httpResponse.getStatusCode() != 304) {
            content = BinaryUtils.toByteArray(httpResponse.getContent());
            response = this.jdcloudClient.readValue(content, this.returnType());
            if (null == response) {
                throw new JdcloudSdkException("Illegal Content");
            }
        } else {
            Object o = httpResponse.getHeaders().get((Object)"x-jdcloud-request-id");
            if (o instanceof ArrayList) {
                String reqId = (String)((ArrayList)o).get(0);
                response.setRequestId(reqId);
            }
        }
        response.setJdcloudHttpResponse(this.copyHttpResponse(httpResponse, content));
        return response;
    }

    private JdcloudHttpResponse copyHttpResponse(HttpResponse httpResponse, byte[] content) {
        JdcloudHttpResponse jdcloudHttpResponse = new JdcloudHttpResponse();
        jdcloudHttpResponse.setContent(content);
        jdcloudHttpResponse.setContentCharset(httpResponse.getContentCharset());
        jdcloudHttpResponse.setContentEncoding(httpResponse.getContentEncoding());
        jdcloudHttpResponse.setContentType(httpResponse.getContentType());
        jdcloudHttpResponse.setHeaders(httpResponse.getHeaders());
        jdcloudHttpResponse.setMediaType(httpResponse.getMediaType());
        jdcloudHttpResponse.setContentLoggingLimit(httpResponse.getContentLoggingLimit());
        jdcloudHttpResponse.setStatusCode(httpResponse.getStatusCode());
        jdcloudHttpResponse.setStatusMessage(httpResponse.getStatusMessage());
        return jdcloudHttpResponse;
    }

    private String getRequestValue(String fieldName, JdcloudRequest request) {
        Field field = null;
        try {
            field = request.getClass().getDeclaredField(fieldName);
        }
        catch (NoSuchFieldException e) {
            logger.info(fieldName, (Object)" not fount");
        }
        try {
            if (field == null) {
                field = request.getClass().getSuperclass().getDeclaredField(fieldName);
            }
            field.setAccessible(true);
            Object value = field.get(request);
            if (value == null) {
                throw new JdcloudSdkException("field " + fieldName + " not set.");
            }
            String strValue = String.valueOf(value);
            return strValue.replace("/", "%2F");
        }
        catch (Exception e) {
            throw new JdcloudSdkException("can not get value of request field '" + fieldName + "'.", e);
        }
    }

    private String getParams(JdcloudRequest request) throws UnsupportedEncodingException {
        if (request == null) {
            return "";
        }
        if (SdkHttpMethod.DELETE.name().equalsIgnoreCase(this.method()) || SdkHttpMethod.GET.name().equalsIgnoreCase(this.method()) || SdkHttpMethod.HEAD.name().equalsIgnoreCase(this.method())) {
            Gson gson = new GsonBuilder().setPrettyPrinting().disableHtmlEscaping().setDateFormat(dateFormat).create();
            JsonElement jsonElement = gson.toJsonTree((Object)request);
            String params = this.createParam(jsonElement, "");
            if (StringUtils.isNotBlank(params)) {
                return "?" + params.substring(1);
            }
            return "";
        }
        return "";
    }

    String createParam(JsonElement jsonElement, String superName) throws UnsupportedEncodingException {
        StringBuilder sb = new StringBuilder();
        if (jsonElement instanceof JsonObject) {
            this.objectParam(jsonElement, superName, sb);
        } else if (jsonElement instanceof JsonArray) {
            this.arrayParam(jsonElement, superName, sb);
        }
        return sb.toString();
    }

    private void arrayParam(JsonElement jsonElement, String superName, StringBuilder sb) throws UnsupportedEncodingException {
        Iterator iterator = ((JsonArray)jsonElement).iterator();
        int i = 1;
        while (iterator.hasNext()) {
            JsonElement value = (JsonElement)iterator.next();
            if (value instanceof JsonArray) {
                sb.append(this.createParam(value, superName + "." + i++));
                continue;
            }
            if (value instanceof JsonObject) {
                sb.append(this.createParam(value, superName + "." + i++));
                continue;
            }
            sb.append("&");
            sb.append(superName);
            sb.append(".");
            sb.append(i++);
            sb.append("=");
            sb.append(URLEncoder.encode(value.toString().replaceAll("^\"|\"$", ""), charset));
        }
    }

    private void objectParam(JsonElement jsonElement, String superName, StringBuilder sb) throws UnsupportedEncodingException {
        for (Map.Entry e : ((JsonObject)jsonElement).entrySet()) {
            String name = (String)e.getKey();
            if (this.url().indexOf("{" + name + "}") > -1) continue;
            JsonElement value = (JsonElement)e.getValue();
            String pname = this.createParamKey(superName, name);
            if (value instanceof JsonArray) {
                sb.append(this.createParam(value, pname));
                continue;
            }
            if (value instanceof JsonObject) {
                sb.append(this.createParam(value, pname));
                continue;
            }
            if (value == null) continue;
            sb.append("&");
            sb.append(pname);
            sb.append("=");
            sb.append(URLEncoder.encode(value.toString().replaceAll("^\"|\"$", ""), charset));
        }
    }

    private String createParamKey(String superName, String name) {
        if (StringUtils.isBlank(superName)) {
            return name;
        }
        return superName + "." + name;
    }

    private String content(JdcloudRequest request) {
        if (request == null) {
            return null;
        }
        if (SdkHttpMethod.DELETE.name().equalsIgnoreCase(this.method()) || SdkHttpMethod.GET.name().equalsIgnoreCase(this.method()) || SdkHttpMethod.HEAD.name().equalsIgnoreCase(this.method())) {
            return null;
        }
        ExclusionStrategy strategy = new ExclusionStrategy(){

            public boolean shouldSkipClass(Class<?> clazz) {
                return false;
            }

            public boolean shouldSkipField(FieldAttributes field) {
                return field.getAnnotation(Exclude.class) != null;
            }
        };
        Gson gson = new GsonBuilder().setDateFormat(dateFormat).setExclusionStrategies(new ExclusionStrategy[]{strategy}).create();
        return gson.toJson((Object)request);
    }

    private void setCookie(Set<Cookie> cookies, HttpHeaders headers) {
        if (cookies.size() > 0) {
            BasicCookieStore cookieStore = new BasicCookieStore();
            for (Cookie cookie : cookies) {
                cookieStore.addCookie(cookie);
            }
            DefaultCookieSpec spec = new DefaultCookieSpec();
            List cookieHeaders = spec.formatCookies(cookieStore.getCookies());
            for (Header header : cookieHeaders) {
                headers.set(header.getName(), (Object)header.getValue());
            }
        }
    }

    private void setCustomHeader(HttpHeaders headers) {
        Map<String, String> customHeaders = this.jdcloudClient.getCustomHeader();
        for (Map.Entry<String, String> entry : customHeaders.entrySet()) {
            String key = entry.getKey();
            if (null == key) continue;
            String value = entry.getValue();
            if (base64Headers.contains(key)) {
                try {
                    value = Base64Utils.encodeAsString(value.getBytes("UTF-8"));
                }
                catch (Exception e) {
                    throw new JdcloudSdkException(e);
                }
            }
            headers.put(key, (Object)value);
        }
    }
}

