/*
 * Decompiled with CFR 0.152.
 */
package com.jdcloud.sdk.auth;

import com.jdcloud.sdk.auth.ICredentials;
import com.jdcloud.sdk.utils.StringUtils;
import com.jdcloud.sdk.utils.Validate;
import java.util.Objects;

public class Credentials
implements ICredentials {
    private final String accessKeyId;
    private final String secretAccessKey;

    public Credentials(String accessKeyId, String secretAccessKey) {
        this(accessKeyId, secretAccessKey, true);
    }

    private Credentials(String accessKeyId, String secretAccessKey, boolean validateCredentials) {
        this.accessKeyId = StringUtils.trimToNull(accessKeyId);
        this.secretAccessKey = StringUtils.trimToNull(secretAccessKey);
        if (validateCredentials) {
            Validate.notNull(this.accessKeyId, "Access key ID cannot be blank.", new Object[0]);
            Validate.notNull(this.secretAccessKey, "Secret access key cannot be blank.", new Object[0]);
        }
    }

    @Override
    public final String accessKeyId() {
        return this.accessKeyId;
    }

    @Override
    public final String secretAccessKey() {
        return this.secretAccessKey;
    }

    public String toString() {
        return this.getClass().getSimpleName() + "(" + this.accessKeyId + ")";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Credentials that = (Credentials)o;
        return Objects.equals(this.accessKeyId, that.accessKeyId) && Objects.equals(this.secretAccessKey, that.secretAccessKey);
    }

    public int hashCode() {
        return Objects.hash(this.accessKeyId, this.secretAccessKey);
    }
}

