/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.signatures;

import com.itextpdf.signatures.CertificateUtil;
import com.itextpdf.signatures.ICrlClient;
import com.itextpdf.signatures.SignUtils;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.security.cert.Certificate;
import java.security.cert.CertificateParsingException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CrlClientOnline
implements ICrlClient {
    private static final Logger LOGGER = LoggerFactory.getLogger(CrlClientOnline.class);
    protected List<URL> urls = new ArrayList<URL>();

    public CrlClientOnline() {
    }

    public CrlClientOnline(String ... crls) {
        for (String url : crls) {
            this.addUrl(url);
        }
    }

    public CrlClientOnline(URL ... crls) {
        for (URL url : crls) {
            this.addUrl(url);
        }
    }

    public CrlClientOnline(Certificate[] chain) {
        for (int i = 0; i < chain.length; ++i) {
            X509Certificate cert = (X509Certificate)chain[i];
            LOGGER.info("Checking certificate: " + cert.getSubjectDN());
            String url = null;
            try {
                url = CertificateUtil.getCRLURL(cert);
                if (url == null) continue;
                this.addUrl(url);
                continue;
            }
            catch (CertificateParsingException e) {
                LOGGER.info("Skipped CRL url (certificate could not be parsed)");
            }
        }
    }

    @Override
    public Collection<byte[]> getEncoded(X509Certificate checkCert, String url) {
        if (checkCert == null) {
            return null;
        }
        ArrayList<URL> urllist = new ArrayList<URL>(this.urls);
        if (urllist.size() == 0) {
            LOGGER.info("Looking for CRL for certificate " + checkCert.getSubjectDN());
            try {
                if (url == null) {
                    url = CertificateUtil.getCRLURL(checkCert);
                }
                if (url == null) {
                    throw new IllegalArgumentException("Passed url can not be null.");
                }
                urllist.add(new URL(url));
                LOGGER.info("Found CRL url: " + url);
            }
            catch (Exception e) {
                LOGGER.info("Skipped CRL url: " + e.getMessage());
            }
        }
        ArrayList<byte[]> ar = new ArrayList<byte[]>();
        for (URL urlt : urllist) {
            try {
                int n;
                LOGGER.info("Checking CRL: " + urlt);
                InputStream inp = SignUtils.getHttpResponse(urlt);
                byte[] buf = new byte[1024];
                ByteArrayOutputStream bout = new ByteArrayOutputStream();
                while ((n = inp.read(buf, 0, buf.length)) > 0) {
                    bout.write(buf, 0, n);
                }
                inp.close();
                ar.add(bout.toByteArray());
                LOGGER.info("Added CRL found at: " + urlt);
            }
            catch (Exception e) {
                LOGGER.info("Skipped CRL: " + e.getMessage() + " for " + urlt);
            }
        }
        return ar;
    }

    protected void addUrl(String url) {
        try {
            this.addUrl(new URL(url));
        }
        catch (IOException e) {
            LOGGER.info("Skipped CRL url (malformed): " + url);
        }
    }

    protected void addUrl(URL url) {
        if (this.urls.contains(url)) {
            LOGGER.info("Skipped CRL url (duplicate): " + url);
            return;
        }
        this.urls.add(url);
        LOGGER.info("Added CRL url: " + url);
    }

    public int getUrlsSize() {
        return this.urls.size();
    }
}

