/*
 * Decompiled with CFR 0.152.
 */
package org.beetl.sql.core;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.beetl.sql.core.BeetlSQLException;
import org.beetl.sql.core.ClasspathLoader;
import org.beetl.sql.core.ConnectionSource;
import org.beetl.sql.core.ConnectionSourceHelper;
import org.beetl.sql.core.DBRunner;
import org.beetl.sql.core.DefaultNameConversion;
import org.beetl.sql.core.DefaultSQLIdNameConversion;
import org.beetl.sql.core.IDAutoGen;
import org.beetl.sql.core.Interceptor;
import org.beetl.sql.core.NameConversion;
import org.beetl.sql.core.OnConnection;
import org.beetl.sql.core.RowMapper;
import org.beetl.sql.core.SQLIdNameConversion;
import org.beetl.sql.core.SQLLoader;
import org.beetl.sql.core.SQLManagerBuilder;
import org.beetl.sql.core.SQLReady;
import org.beetl.sql.core.SQLResult;
import org.beetl.sql.core.SQLScript;
import org.beetl.sql.core.SQLSource;
import org.beetl.sql.core.db.ClassDesc;
import org.beetl.sql.core.db.DBStyle;
import org.beetl.sql.core.db.KeyHolder;
import org.beetl.sql.core.db.MetadataManager;
import org.beetl.sql.core.db.TableDesc;
import org.beetl.sql.core.engine.Beetl;
import org.beetl.sql.core.engine.PageQuery;
import org.beetl.sql.core.kit.BeanKit;
import org.beetl.sql.core.kit.CaseInsensitiveOrderSet;
import org.beetl.sql.core.kit.ConstantEnum;
import org.beetl.sql.core.kit.GenKit;
import org.beetl.sql.core.kit.PageKit;
import org.beetl.sql.core.kit.StringKit;
import org.beetl.sql.core.mapper.DefaultMapperBuilder;
import org.beetl.sql.core.mapper.MapperBuilder;
import org.beetl.sql.core.mapper.builder.MapperConfig;
import org.beetl.sql.core.mapping.BeanProcessor;
import org.beetl.sql.core.query.LambdaQuery;
import org.beetl.sql.core.query.Query;
import org.beetl.sql.ext.SnowflakeIDAutoGen;
import org.beetl.sql.ext.gen.GenConfig;
import org.beetl.sql.ext.gen.GenFilter;
import org.beetl.sql.ext.gen.MDCodeGen;
import org.beetl.sql.ext.gen.SourceGen;

public class SQLManager {
    private static Map<String, SQLManager> sqlManagerMap = new HashMap<String, SQLManager>();
    Interceptor[] inters = new Interceptor[0];
    Beetl beetl = null;
    MapperBuilder mapperBuilder = new DefaultMapperBuilder(this);
    boolean offsetStartZero = false;
    Map<String, BeanProcessor> processors = new HashMap<String, BeanProcessor>();
    BeanProcessor defaultBeanProcessors = null;
    Map<String, IDAutoGen> idAutonGenMap = new HashMap<String, IDAutoGen>();
    private DBStyle dbStyle;
    private SQLLoader sqlLoader;
    private ConnectionSource ds = null;
    private NameConversion nc = null;
    private MetadataManager metaDataManager;
    private String defaultSchema = null;
    private MapperConfig mapperConfig = new MapperConfig();
    private String sqlMananagerName = null;
    private ClassLoader entityLoader = null;
    private SQLIdNameConversion idNameConversion;

    public SQLManager(DBStyle dbStyle, ConnectionSource ds) {
        this(dbStyle, new ClasspathLoader("/sql"), ds);
    }

    public SQLManager(DBStyle dbStyle, SQLLoader sqlLoader, ConnectionSource ds) {
        this(dbStyle, sqlLoader, ds, new DefaultNameConversion(), new Interceptor[0], null);
    }

    public SQLManager(DBStyle dbStyle, SQLLoader sqlLoader, ConnectionSource ds, NameConversion nc) {
        this(dbStyle, sqlLoader, ds, nc, new Interceptor[0], null);
    }

    public SQLManager(DBStyle dbStyle, SQLLoader sqlLoader, ConnectionSource ds, NameConversion nc, Interceptor[] inters) {
        this(dbStyle, sqlLoader, ds, nc, inters, null);
    }

    public SQLManager(DBStyle dbStyle, SQLLoader sqlLoader, ConnectionSource ds, NameConversion nc, Interceptor[] inters, String defaultSchema) {
        this(dbStyle, sqlLoader, ds, nc, inters, defaultSchema, new Properties());
    }

    public SQLManager(DBStyle dbStyle, SQLLoader sqlLoader, ConnectionSource ds, NameConversion nc, Interceptor[] inters, String defaultSchema, Properties ps) {
        this(dbStyle, sqlLoader, ds, nc, inters, defaultSchema, ps, dbStyle.getName());
    }

    public SQLManager(DBStyle dbStyle, SQLLoader sqlLoader, ConnectionSource ds, NameConversion nc, Interceptor[] inters, String defaultSchema, Properties ps, String name) {
        this.idAutonGenMap.put("simple", new SnowflakeIDAutoGen());
        this.idNameConversion = new DefaultSQLIdNameConversion();
        this.defaultSchema = defaultSchema;
        this.beetl = new Beetl(sqlLoader, ps);
        this.dbStyle = dbStyle;
        this.sqlLoader = sqlLoader;
        this.sqlLoader.setDbStyle(dbStyle);
        this.ds = ds;
        this.nc = nc;
        this.inters = inters;
        this.dbStyle.setNameConversion(this.nc);
        this.dbStyle.setMetadataManager(this.initMetadataManager());
        this.dbStyle.init(this.beetl);
        this.offsetStartZero = Boolean.parseBoolean(this.beetl.getPs().getProperty("OFFSET_START_ZERO").trim());
        this.defaultBeanProcessors = new BeanProcessor(this);
        this.sqlMananagerName = name;
        sqlManagerMap.put(name, this);
    }

    public static SQLManagerBuilder newBuilder(ConnectionSource ds) {
        return new SQLManagerBuilder(ds);
    }

    public static SQLManagerBuilder newBuilder(String driver, String url, String userName, String password) {
        ConnectionSource source = ConnectionSourceHelper.getSimple(driver, url, userName, password);
        return SQLManager.newBuilder(source);
    }

    public static SQLManager getSQLManagerByName(String name) {
        SQLManager sqlManager = sqlManagerMap.get(name);
        if (sqlManager == null) {
            throw new NullPointerException("\u4e0d\u80fd\u6839\u636e" + name + "\u83b7\u5f97sqlManager");
        }
        return sqlManager;
    }

    public <T> Query<T> query(Class<T> clazz) {
        return new Query<T>(this, clazz);
    }

    public <T> LambdaQuery<T> lambdaQuery(Class<T> clazz) {
        if (BeanKit.queryLambdasSupport) {
            return new LambdaQuery(this, (Class)clazz);
        }
        throw new UnsupportedOperationException("\u9700\u8981Java8\u4ee5\u4e0a");
    }

    public boolean isOffsetStartZero() {
        return this.offsetStartZero;
    }

    private MetadataManager initMetadataManager() {
        if (this.metaDataManager == null) {
            this.metaDataManager = new MetadataManager(this.ds, this);
        }
        return this.metaDataManager;
    }

    public boolean isProductMode() {
        boolean productMode = !this.sqlLoader.isAutoCheck();
        return productMode;
    }

    public SQLResult getSQLResult(String id, Map<String, Object> paras) {
        SQLScript script = this.getScript(id);
        return script.run(paras);
    }

    public SQLResult getSQLResult(String id, Object paras) {
        SQLScript script = this.getScript(id);
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("_root", paras);
        return script.run(map);
    }

    public SQLResult getSQLResult(SQLSource source, Map inputParas) {
        SQLScript script = new SQLScript(source, this);
        SQLResult result = script.run(inputParas);
        return result;
    }

    public SQLResult getSQLResult(String id, Map<String, Object> paras, String parentId) {
        SQLScript script = this.getScript(id);
        return script.run(paras, parentId);
    }

    public SQLScript getScript(String id) {
        SQLSource source = this.sqlLoader.getSQL(id);
        if (source == null) {
            String path = this.idNameConversion.getPath(id);
            SQLLoader sqlLoader = this.getSqlLoader();
            String envInfo = path + ".md(sql)" + " sqlLoader:" + sqlLoader;
            if (this.sqlLoader instanceof ClasspathLoader) {
                envInfo = ((ClasspathLoader)sqlLoader).exsitResource(id) ? envInfo + ",\u6587\u4ef6\u627e\u5230\uff0c\u4f46\u6ca1\u6709\u5bf9\u5e94\u7684sqlId" : envInfo + ",\u672a\u627e\u5230\u5bf9\u5e94\u7684sql\u6587\u4ef6";
            }
            throw new BeetlSQLException(2, "\u672a\u80fd\u627e\u5230" + id + "\u5bf9\u5e94\u7684sql,\u641c\u7d22\u8def\u5f84:" + envInfo);
        }
        SQLScript script = new SQLScript(source, this);
        return script;
    }

    public SQLScript getScript(Class<?> cls, ConstantEnum constantEnum) {
        String className = StringKit.toLowerCaseFirstOne(cls.getSimpleName());
        String id = className + "." + constantEnum.getClassSQL();
        SQLSource tempSource = this.sqlLoader.getSQL(id);
        if (tempSource != null) {
            return new SQLScript(tempSource, this);
        }
        switch (constantEnum) {
            case SELECT_BY_ID: {
                tempSource = this.dbStyle.genSelectById(cls);
                break;
            }
            case SELECT_BY_TEMPLATE: {
                tempSource = this.dbStyle.genSelectByTemplate(cls);
                break;
            }
            case SELECT_COUNT_BY_TEMPLATE: {
                tempSource = this.dbStyle.genSelectCountByTemplate(cls);
                break;
            }
            case DELETE_BY_ID: {
                tempSource = this.dbStyle.genDeleteById(cls);
                break;
            }
            case SELECT_ALL: {
                tempSource = this.dbStyle.genSelectAll(cls);
                break;
            }
            case UPDATE_ALL: {
                tempSource = this.dbStyle.genUpdateAll(cls);
                break;
            }
            case UPDATE_BY_ID: {
                tempSource = this.dbStyle.genUpdateById(cls);
                break;
            }
            case UPDATE_TEMPLATE_BY_ID: {
                tempSource = this.dbStyle.genUpdateTemplate(cls);
                break;
            }
            case INSERT: {
                tempSource = this.dbStyle.genInsert(cls);
                break;
            }
            case INSERT_TEMPLATE: {
                tempSource = this.dbStyle.genInsertTemplate(cls);
                break;
            }
            case DELETE_TEMPLATE_BY_ID: {
                tempSource = this.dbStyle.genDeleteById(cls);
                break;
            }
            case LOCK_BY_ID: {
                tempSource = this.dbStyle.genSelectByIdForUpdate(cls);
                break;
            }
            default: {
                throw new UnsupportedOperationException();
            }
        }
        tempSource.setId(id);
        this.sqlLoader.addSQL(id, tempSource);
        return new SQLScript(tempSource, this);
    }

    public SQLScript getPageSqlScript(String selectId) {
        SQLSource source;
        String pageId = selectId + "_page";
        if (this.isProductMode() && (source = this.sqlLoader.getSQL(pageId)) != null) {
            return new SQLScript(source, this);
        }
        SQLSource script = this.sqlLoader.getSQL(selectId);
        String template = script.getTemplate();
        String pageTemplate = this.dbStyle.getPageSQL(template);
        SQLSource source2 = new SQLSource(pageId, pageTemplate);
        source2.version = script.version;
        this.sqlLoader.addSQL(pageId, source2);
        return new SQLScript(source2, this);
    }

    public <T> List<T> select(String sqlId, Class<T> clazz, Map<String, Object> paras) {
        return this.select(sqlId, clazz, paras, null);
    }

    public <T> List<T> select(String sqlId, Class<T> clazz, Map<String, Object> paras, RowMapper<T> mapper) {
        SQLScript script = this.getScript(sqlId);
        return script.select(clazz, paras, mapper);
    }

    public <T> List<T> select(String sqlId, Class<T> clazz, Object paras) {
        return this.select(sqlId, clazz, paras, null);
    }

    public <T> List<T> select(String sqlId, Class<T> clazz) {
        return this.select(sqlId, clazz, null, null);
    }

    public <T> List<T> select(String sqlId, Class<T> clazz, Object paras, RowMapper<T> mapper) {
        HashMap<String, Object> param = new HashMap<String, Object>();
        param.put("_root", paras);
        SQLScript script = this.getScript(sqlId);
        return script.select(clazz, param, mapper);
    }

    public <T> List<T> select(String sqlId, Class<T> clazz, Object paras, long start, long size) {
        return this.select(sqlId, clazz, paras, null, start, size);
    }

    public <T> List<T> select(String sqlId, Class<T> clazz, Object paras, RowMapper<T> mapper, long start, long size) {
        SQLScript script = this.getScript(sqlId);
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("_root", paras);
        return script.select(map, clazz, mapper, start, size);
    }

    public <T> List<T> select(String sqlId, Class<T> clazz, Map<String, Object> paras, long start, long size) {
        SQLScript script = this.getScript(sqlId);
        return script.select(paras, clazz, null, start, size);
    }

    public <T> List<T> select(String sqlId, Class<T> clazz, Map<String, Object> paras, RowMapper<T> mapper, long start, long size) {
        SQLScript script = this.getScript(sqlId);
        return script.select(paras, clazz, mapper, start, size);
    }

    public <T> PageQuery<T> pageQuery(String sqlId, Class<T> clazz, PageQuery<T> query) {
        return this.pageQuery(sqlId, clazz, query, null);
    }

    public <T> PageQuery<T> pageQuery(String sqlId, Class<T> clazz, PageQuery query, RowMapper<T> mapper) {
        Object paras = query.getParas();
        HashMap<String, Object> root = null;
        Long totalRow = query.getTotalRow();
        List<T> list = null;
        if (paras == null) {
            root = new HashMap<String, Object>();
        } else {
            root = new HashMap();
            root.put("_root", paras);
        }
        if (query.getOrderBy() != null) {
            root.put("_orderBy", query.getOrderBy());
        }
        String sqlCountId = sqlId.concat("$count");
        boolean hasCountSQL = this.sqlLoader.exist(sqlCountId);
        if (query.getTotalRow() == -1L) {
            if (hasCountSQL) {
                totalRow = this.selectSingle(sqlCountId, root, Long.class);
            } else {
                root.put(PageQuery.pageFlag, PageQuery.pageObj);
                totalRow = this.selectSingle(sqlId, root, Long.class);
            }
            if (totalRow == null) {
                totalRow = 0L;
            }
            query.setTotalRow(totalRow);
        }
        if (!hasCountSQL) {
            root.remove(PageQuery.pageFlag);
        }
        if (totalRow != 0L) {
            long start = (long)(this.offsetStartZero ? 0 : 1) + (query.getPageNumber() - 1L) * query.getPageSize();
            long size = query.getPageSize();
            list = this.select(sqlId, clazz, root, mapper, start, size);
        } else {
            list = Collections.EMPTY_LIST;
        }
        query.setList(list);
        return query;
    }

    public <T> T unique(Class<T> clazz, Object pk) {
        SQLScript script = this.getScript(clazz, ConstantEnum.SELECT_BY_ID);
        return script.unique(clazz, null, pk);
    }

    public <T> T unique(Class<T> clazz, RowMapper<T> mapper, Object pk) {
        SQLScript script = this.getScript(clazz, ConstantEnum.SELECT_BY_ID);
        return script.unique(clazz, mapper, pk);
    }

    public <T> T single(Class<T> clazz, Object pk) {
        SQLScript script = this.getScript(clazz, ConstantEnum.SELECT_BY_ID);
        return script.single(clazz, null, pk);
    }

    public <T> T lock(Class<T> clazz, Object pk) {
        SQLScript script = this.getScript(clazz, ConstantEnum.LOCK_BY_ID);
        return script.single(clazz, null, pk);
    }

    public <T> List<T> all(Class<T> clazz) {
        SQLScript script = this.getScript(clazz, ConstantEnum.SELECT_ALL);
        return script.select(clazz, null);
    }

    public <T> List<T> all(Class<T> clazz, long start, long size) {
        SQLScript script = this.getScript(clazz, ConstantEnum.SELECT_ALL);
        return script.select(null, clazz, null, start, size);
    }

    public long allCount(Class<?> clazz) {
        SQLScript script = this.getScript(clazz, ConstantEnum.SELECT_COUNT_BY_TEMPLATE);
        return script.selectSingle(null, Long.class);
    }

    public <T> List<T> all(Class<T> clazz, RowMapper<T> mapper, long start, int end) {
        SQLScript script = this.getScript(clazz, ConstantEnum.SELECT_ALL);
        return script.select(null, clazz, mapper, start, (long)end);
    }

    public <T> List<T> all(Class<T> clazz, RowMapper<T> mapper) {
        SQLScript script = this.getScript(clazz, ConstantEnum.SELECT_ALL);
        return script.select(clazz, null, mapper);
    }

    public <T> List<T> template(T t) {
        SQLScript script = this.getScript(t.getClass(), ConstantEnum.SELECT_BY_TEMPLATE);
        HashMap<String, Object> param = new HashMap<String, Object>();
        param.put("_root", t);
        return script.select(t.getClass(), param, null);
    }

    public <T> T templateOne(T t) {
        int start = this.offsetStartZero ? 0 : 1;
        List<T> list = this.template(t, start, 1L);
        if (list.isEmpty()) {
            return null;
        }
        return list.get(0);
    }

    public <T> List<T> template(T t, RowMapper mapper) {
        SQLScript script = this.getScript(t.getClass(), ConstantEnum.SELECT_BY_TEMPLATE);
        HashMap<String, Object> param = new HashMap<String, Object>();
        param.put("_root", t);
        return script.select(t.getClass(), param, mapper);
    }

    public <T> List<T> template(T t, long start, long size) {
        return this.template(t.getClass(), t, null, start, size);
    }

    public <T> List<T> template(Class<T> target, Object paras, long start, long size) {
        return this.template(target, paras, null, start, size);
    }

    public <T> List<T> template(T t, RowMapper mapper, long start, long size) {
        return this.template(t.getClass(), t, mapper, start, size);
    }

    public <T> List<T> template(Class<T> target, Object paras, RowMapper mapper, long start, long size) {
        SQLScript script = this.getScript(target, ConstantEnum.SELECT_BY_TEMPLATE);
        SQLScript pageScript = this.getPageSqlScript(script.id);
        HashMap<String, Object> param = null;
        if (paras instanceof Map) {
            param = (HashMap<String, Object>)paras;
        } else {
            param = new HashMap<String, Object>();
            param.put("_root", paras);
        }
        this.dbStyle.initPagePara(param, start, size);
        return pageScript.select(target, param, mapper);
    }

    public <T> List<T> template(Class<T> target, Object paras, String orderBy) {
        return this.template(target, paras, -1L, -1L, orderBy);
    }

    public <T> List<T> template(Class<T> target, Object paras, long start, long size, String orderBy) {
        boolean pageable;
        SQLScript script = this.getScript(target, ConstantEnum.SELECT_BY_TEMPLATE);
        String sqlTemplate = script.getSql();
        if (orderBy != null && orderBy.trim().length() != 0) {
            sqlTemplate = sqlTemplate.indexOf(" order by ") == -1 ? sqlTemplate + " order by " + orderBy : sqlTemplate + "," + orderBy;
        }
        boolean bl = pageable = start != -1L && size != -1L;
        if (pageable) {
            sqlTemplate = this.dbStyle.getPageSQL(sqlTemplate);
        }
        HashMap<String, Object> param = null;
        if (paras instanceof Map) {
            param = (HashMap<String, Object>)paras;
        } else {
            param = new HashMap<String, Object>();
            param.put("_root", paras);
        }
        if (pageable) {
            this.dbStyle.initPagePara(param, start, size);
        }
        List<T> list = this.execute(sqlTemplate, target, param);
        return list;
    }

    public <T> long templateCount(T t) {
        return this.templateCount(t.getClass(), t);
    }

    public <T> long templateCount(Class<T> target, Object paras) {
        SQLScript script = this.getScript(target, ConstantEnum.SELECT_COUNT_BY_TEMPLATE);
        if (paras instanceof Map) {
            Map map = (Map)paras;
            Long l = script.selectSingle(map, Long.class);
            return l;
        }
        Long l = script.singleSelect(paras, Long.class);
        return l;
    }

    public Long longValue(String id, Map<String, Object> paras) {
        return this.selectSingle(id, paras, Long.class);
    }

    public Long longValue(String id, Object paras) {
        return this.selectSingle(id, paras, Long.class);
    }

    public Integer intValue(String id, Object paras) {
        return this.selectSingle(id, paras, Integer.class);
    }

    public Integer intValue(String id, Map<String, Object> paras) {
        return this.selectSingle(id, paras, Integer.class);
    }

    public BigDecimal bigDecimalValue(String id, Object paras) {
        return this.selectSingle(id, paras, BigDecimal.class);
    }

    public BigDecimal bigDecimalValue(String id, Map<String, Object> paras) {
        return this.selectSingle(id, paras, BigDecimal.class);
    }

    public <T> T selectSingle(String sqlId, Object paras, Class<T> target) {
        SQLScript script = this.getScript(sqlId);
        return script.singleSelect(paras, target);
    }

    public <T> T selectSingle(String sqlId, Map<String, Object> paras, Class<T> target) {
        SQLScript script = this.getScript(sqlId);
        return script.selectSingle(paras, target);
    }

    public <T> T selectUnique(String id, Object paras, Class<T> target) {
        SQLScript script = this.getScript(id);
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("_root", paras);
        return script.selectUnique(map, target);
    }

    public <T> T selectUnique(String id, Map<String, Object> paras, Class<T> target) {
        SQLScript script = this.getScript(id);
        return script.selectUnique(paras, target);
    }

    public int deleteById(Class<?> clazz, Object pkValue) {
        SQLScript script = this.getScript(clazz, ConstantEnum.DELETE_BY_ID);
        return script.deleteById(clazz, pkValue);
    }

    public int deleteObject(Object obj) {
        SQLScript script = this.getScript(obj.getClass(), ConstantEnum.DELETE_TEMPLATE_BY_ID);
        return script.update(obj);
    }

    public int insert(Object paras) {
        return this.insert(paras.getClass(), paras, false);
    }

    public int insert(Object paras, boolean autoDbAssignKey) {
        return this.insert(paras.getClass(), paras, autoDbAssignKey);
    }

    public int insertTemplate(Object paras) {
        return this.insertTemplate(paras.getClass(), paras, false);
    }

    public int insertTemplate(Object paras, boolean autoDbAssignKey) {
        return this.insertTemplate(paras.getClass(), paras, autoDbAssignKey);
    }

    public int insert(Class clazz, Object paras, boolean autoDbAssignKey) {
        return this.generalInsert(clazz, paras, autoDbAssignKey, false);
    }

    public int insertTemplate(Class clazz, Object paras, boolean autoDbAssignKey) {
        return this.generalInsert(clazz, paras, autoDbAssignKey, true);
    }

    public int insert(Class<?> clazz, Object paras) {
        return this.insert(clazz, paras, false);
    }

    private int generalInsert(Class clazz, Object paras, boolean autoAssignKey, boolean template) {
        if (autoAssignKey) {
            KeyHolder holder = new KeyHolder();
            Class target = clazz;
            int result = template ? this.insertTemplate(target, paras, holder) : this.insert(target, paras, holder);
            String table = this.nc.getTableName(target);
            ClassDesc desc = this.metaDataManager.getTable(table).getClassDesc(target, this.nc);
            if (desc.getIdCols().isEmpty()) {
                return result;
            }
            Method getterMethod = (Method)desc.getIdMethods().get(desc.getIdAttrs().get(0));
            String name = getterMethod.getName();
            String setterName = name.replaceFirst("get", "set");
            try {
                Method setterMethod = target.getMethod(setterName, getterMethod.getReturnType());
                Object value = holder.getKey();
                if (value != null) {
                    value = BeanKit.convertValueToRequiredType(value, getterMethod.getReturnType());
                    setterMethod.invoke(paras, value);
                }
                return result;
            }
            catch (Exception ex) {
                throw new UnsupportedOperationException("autoAssignKey failure " + ex.getMessage());
            }
        }
        SQLScript script = this.getScript(clazz, template ? ConstantEnum.INSERT_TEMPLATE : ConstantEnum.INSERT);
        return script.insert(paras);
    }

    public int[] insertBatch(Class clazz, List<?> list) {
        SQLScript script = this.getScript(clazz, ConstantEnum.INSERT);
        int[] ret = script.insertBatch(list);
        return ret;
    }

    public int insert(Class<?> clazz, Object paras, KeyHolder holder) {
        SQLScript script = this.getScript(clazz, ConstantEnum.INSERT);
        return script.insert(paras, holder);
    }

    public int insertTemplate(Class<?> clazz, Object paras, KeyHolder holder) {
        SQLScript script = this.getScript(clazz, ConstantEnum.INSERT_TEMPLATE);
        return script.insert(paras, holder);
    }

    public int insert(String sqlId, Object paras, KeyHolder holder, String keyName) {
        SQLScript script = this.getScript(sqlId);
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("_root", paras);
        return script.insertBySqlId(map, holder, keyName);
    }

    public int insert(String sqlId, Object paras, KeyHolder holder) {
        SQLScript script = this.getScript(sqlId);
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("_root", paras);
        if (holder != null) {
            String tableName = this.nc.getTableName(paras.getClass());
            TableDesc table = this.metaDataManager.getTable(tableName);
            Set<String> idCols = table.getIdNames();
            if (idCols.size() != 1) {
                throw new BeetlSQLException(4, "\u6709\u591a\u4e2a\u4e3b\u952e\uff0c\u4e0d\u80fd\u81ea\u52a8\u8bbe\u7f6e");
            }
            return script.insertBySqlId(map, holder, ((CaseInsensitiveOrderSet)idCols).getFirst());
        }
        return script.insertBySqlId(map, null, null);
    }

    public int insert(String sqlId, Class<?> clazz, Map paras, KeyHolder holder) {
        SQLScript script = this.getScript(sqlId);
        if (holder != null) {
            String tableName = this.nc.getTableName(clazz);
            TableDesc table = this.metaDataManager.getTable(tableName);
            ClassDesc clsDesc = table.getClassDesc(this.nc);
            Set<String> idCols = table.getIdNames();
            if (idCols.size() != 1) {
                throw new BeetlSQLException(4, "\u6709\u591a\u4e2a\u4e3b\u952e\uff0c\u4e0d\u80fd\u81ea\u52a8\u8bbe\u7f6e");
            }
            return script.insertBySqlId(paras, holder, ((CaseInsensitiveOrderSet)idCols).getFirst());
        }
        return script.insertBySqlId(paras, holder, null);
    }

    public int insert(String sqlId, Map paras, KeyHolder holder, String keyName) {
        SQLScript script = this.getScript(sqlId);
        return script.insertBySqlId(paras, holder, keyName);
    }

    public int updateById(Object obj) {
        SQLScript script = this.getScript(obj.getClass(), ConstantEnum.UPDATE_BY_ID);
        return script.update(obj);
    }

    public int updateTemplateById(Object obj) {
        SQLScript script = this.getScript(obj.getClass(), ConstantEnum.UPDATE_TEMPLATE_BY_ID);
        return script.update(obj);
    }

    public int updateTemplateById(Class c, Map paras) {
        SQLScript script = this.getScript(c, ConstantEnum.UPDATE_TEMPLATE_BY_ID);
        return script.update(paras);
    }

    public int updateTemplateById(Class c, Object obj) {
        SQLScript script = this.getScript(c, ConstantEnum.UPDATE_TEMPLATE_BY_ID);
        return script.update(obj);
    }

    public int[] updateByIdBatch(List<?> list) {
        if (list == null || list.isEmpty()) {
            return new int[0];
        }
        SQLScript script = this.getScript(list.get(0).getClass(), ConstantEnum.UPDATE_BY_ID);
        return script.updateBatch(list);
    }

    public int update(String sqlId, Object obj) {
        SQLScript script = this.getScript(sqlId);
        return script.update(obj);
    }

    public int update(String sqlId) {
        SQLScript script = this.getScript(sqlId);
        return script.update(null);
    }

    public int update(String sqlId, Map<String, Object> paras) {
        SQLScript script = this.getScript(sqlId);
        return script.update(paras);
    }

    public int[] updateBatch(String sqlId, List<?> list) {
        SQLScript script = this.getScript(sqlId);
        return script.updateBatch(list);
    }

    public int[] updateBatchTemplateById(Class clz, List<?> list) {
        SQLScript script = this.getScript(clz, ConstantEnum.UPDATE_TEMPLATE_BY_ID);
        return script.updateBatch(list);
    }

    public int[] updateBatch(String sqlId, Map<String, Object>[] maps) {
        SQLScript script = this.getScript(sqlId);
        return script.updateBatch(maps);
    }

    public int updateAll(Class<?> clazz, Object param) {
        SQLScript script = this.getScript(clazz, ConstantEnum.UPDATE_ALL);
        return script.update(param);
    }

    public void useMaster(DBRunner f) {
        f.start(this, true);
    }

    public void useSlave(DBRunner f) {
        f.start(this, false);
    }

    public <T> List<T> execute(String sqlTemplate, Class<T> clazz, Object paras) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("_root", paras);
        return this.execute(sqlTemplate, clazz, map);
    }

    public <T> List<T> execute(String sqlTemplate, Class<T> clazz, Map paras) {
        String key = "auto._gen_" + sqlTemplate;
        SQLSource source = this.sqlLoader.getSQL(key);
        if (source == null) {
            source = new SQLSource(key, sqlTemplate);
            this.sqlLoader.addSQL(key, source);
        }
        SQLScript script = new SQLScript(source, this);
        return script.select(clazz, paras);
    }

    public <T> List<T> execute(String sqlTemplate, Class<T> clazz, Map paras, long start, long size) {
        String key = "auto._gen_page_" + sqlTemplate;
        SQLSource source = this.sqlLoader.getSQL(key);
        if (source == null) {
            String pageSql = this.dbStyle.getPageSQL(sqlTemplate);
            source = new SQLSource(key, pageSql);
            this.sqlLoader.addSQL(key, source);
        }
        if (paras == null) {
            paras = new HashMap<String, Object>();
        }
        this.dbStyle.initPagePara(paras, start, size);
        SQLScript script = new SQLScript(source, this);
        return script.select(clazz, paras);
    }

    public <T> List<T> execute(String sqlTemplate, Class<T> clazz, Object paras, long start, long size) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("_root", paras);
        return this.execute(sqlTemplate, clazz, map, start, size);
    }

    public int executeUpdate(String sqlTemplate, Object paras) {
        String key = "auto._gen_" + sqlTemplate;
        SQLSource source = this.sqlLoader.getSQL(key);
        if (source == null) {
            source = new SQLSource(key, sqlTemplate);
            this.sqlLoader.addSQL(key, source);
        }
        SQLScript script = new SQLScript(source, this);
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("_root", paras);
        return script.update(map);
    }

    public int executeUpdate(String sqlTemplate, Map paras) {
        String key = "auto._gen_" + sqlTemplate;
        SQLSource source = this.sqlLoader.getSQL(key);
        if (source == null) {
            source = new SQLSource(key, sqlTemplate);
            this.sqlLoader.addSQL(key, source);
        }
        SQLScript script = new SQLScript(source, this);
        return script.update(paras);
    }

    public <T> List<T> execute(SQLReady p, Class<T> clazz) {
        SQLSource source = new SQLSource("native." + p.getSql(), p.getSql());
        SQLScript script = new SQLScript(source, this);
        return script.sqlReadySelect(clazz, p);
    }

    public <T> PageQuery<T> execute(SQLReady p, Class<T> clazz, PageQuery<T> pageQuery) {
        if (pageQuery.getParas() != null) {
            throw new RuntimeException("\u53c2\u6570\u9700\u8981\u901a\u8fc7SQLReady\u4f20\u9012");
        }
        String sql = p.getSql();
        String countSql = PageKit.getCountSql(sql);
        List<Long> countList = this.execute(new SQLReady(countSql, p.getArgs()), Long.class);
        Long count = countList.get(0);
        List list = null;
        if (count == 0L) {
            list = Collections.emptyList();
        } else {
            long pageNumber = pageQuery.getPageNumber();
            long pageSize = pageQuery.getPageSize();
            long offset = (pageNumber - 1L) * pageSize + (long)(this.offsetStartZero ? 0 : 1);
            String pageSql = this.dbStyle.getPageSQLStatement(sql, offset, pageSize);
            list = this.execute(new SQLReady(pageSql, p.getArgs()), clazz);
        }
        pageQuery.setTotalRow(count);
        pageQuery.setList(list);
        return pageQuery;
    }

    public int executeUpdate(SQLReady p) {
        SQLSource source = new SQLSource("native." + p.getSql(), p.getSql());
        SQLScript script = new SQLScript(source, this);
        return script.sqlReadyExecuteUpdate(p);
    }

    public <T> T executeOnConnection(OnConnection<T> onConnection) {
        Connection conn = null;
        onConnection.setSqlManagaer(this);
        try {
            conn = onConnection.getConn(this.getDs());
            T t = onConnection.call(conn);
            return t;
        }
        catch (SQLException e) {
            throw new BeetlSQLException(1, e);
        }
        finally {
            if (!this.getDs().isTransaction()) {
                try {
                    if (!conn.getAutoCommit()) {
                        conn.commit();
                    }
                    conn.close();
                }
                catch (SQLException e) {
                    throw new BeetlSQLException(1, e);
                }
            }
        }
    }

    public void genPojoCode(String table, String pkg, String srcPath, GenConfig config) throws Exception {
        SourceGen gen = new SourceGen(this, table, pkg, srcPath, config);
        gen.gen();
    }

    public void genPojoCode(String table, String pkg, GenConfig config) throws Exception {
        String srcPath = GenKit.getJavaSRCPath();
        SourceGen gen = new SourceGen(this, table, pkg, srcPath, config);
        gen.gen();
    }

    public void genPojoCode(String table, String pkg) throws Exception {
        String srcPath = GenKit.getJavaSRCPath();
        SourceGen gen = new SourceGen(this, table, pkg, srcPath, new GenConfig());
        gen.gen();
    }

    public void genPojoCodeToConsole(String table, String pkg) throws Exception {
        String srcPath = System.getProperty("user.dir");
        SourceGen gen = new SourceGen(this, table, pkg, srcPath, new GenConfig().setDisplay(true));
        gen.gen();
    }

    public void genPojoCodeToConsole(String table) throws Exception {
        String pkg = SourceGen.defaultPkg;
        this.genPojoCodeToConsole(table, pkg);
    }

    public void genPojoCodeToConsole(String table, GenConfig config) throws Exception {
        String srcPath = System.getProperty("user.dir");
        config.setDisplay(true);
        SourceGen gen = new SourceGen(this, table, config.getOutputPackage(), srcPath, config);
        gen.gen();
    }

    public void genSQLFile(String table, GenConfig config) throws Exception {
        this.genSQLFile(table, null, config);
    }

    public void genSQLFile(String table, String alias, GenConfig config) throws Exception {
        String path = "/sql";
        if (this.sqlLoader instanceof ClasspathLoader) {
            path = ((ClasspathLoader)this.sqlLoader).sqlRoot;
        }
        String fileName = StringKit.toLowerCaseFirstOne(this.nc.getClassName(table));
        if (config.getIgnorePrefix() != null && !config.getIgnorePrefix().trim().equals("")) {
            fileName = fileName.replaceFirst(StringKit.toLowerCaseFirstOne(config.getIgnorePrefix()), "");
            fileName = StringKit.toLowerCaseFirstOne(fileName);
        }
        String target = GenKit.getJavaResourcePath() + "/" + path + "/" + fileName + ".md";
        FileWriter writer = new FileWriter(new File(target));
        this.genSQLTemplate(table, writer, alias);
        writer.close();
        System.out.println("gen \"" + table + "\" success at " + target);
    }

    public void genSQLTemplateToConsole(String table) throws Exception {
        this.genSQLTemplate(table, new OutputStreamWriter(System.out), null);
    }

    public void genSQLTemplateToConsole(String table, String alias) throws Exception {
        this.genSQLTemplate(table, new OutputStreamWriter(System.out), alias);
    }

    private void genSQLTemplate(String table, Writer w, String alias) throws IOException {
        MDCodeGen mdCodeGen = new MDCodeGen();
        TableDesc desc = this.metaDataManager.getTable(table);
        mdCodeGen.genCode(this.beetl, desc, this.nc, alias, w);
    }

    public void genALL(String pkg, GenConfig config, GenFilter filter) throws Exception {
        Set<String> tables = this.metaDataManager.allTable();
        for (String table : tables) {
            table = this.metaDataManager.getTable(table).getName();
            if (filter != null && !filter.accept(table)) continue;
            try {
                this.genPojoCode(table, pkg, config);
                this.genSQLFile(table, config);
            }
            catch (Exception e) {
                System.out.println(e.getMessage());
            }
        }
    }

    public void genBuiltInSqlToConsole(Class cls) {
        StringBuilder sb = new StringBuilder();
        SQLSource tempSource = this.dbStyle.genSelectById(cls);
        sb.append(tempSource.getTemplate());
        sb.append("\n\r");
        tempSource = this.dbStyle.genUpdateById(cls);
        sb.append(tempSource.getTemplate());
        sb.append("\n\r");
        tempSource = this.dbStyle.genDeleteById(cls);
        sb.append(tempSource.getTemplate());
        sb.append("\n\r");
        tempSource = this.dbStyle.genInsert(cls);
        sb.append(tempSource.getTemplate());
        sb.append("\n\r");
        System.out.println(sb);
    }

    public <T> T getMapper(Class<T> mapperInterface) {
        return this.mapperBuilder.getMapper(mapperInterface);
    }

    public SQLLoader getSqlLoader() {
        return this.sqlLoader;
    }

    public void setSqlLoader(SQLLoader sqlLoader) {
        this.sqlLoader = sqlLoader;
    }

    public ConnectionSource getDs() {
        return this.ds;
    }

    public void setDs(ConnectionSource ds) {
        this.ds = ds;
    }

    public NameConversion getNc() {
        return this.nc;
    }

    public void setNc(NameConversion nc) {
        this.nc = nc;
        this.dbStyle.setNameConversion(nc);
    }

    public DBStyle getDbStyle() {
        return this.dbStyle;
    }

    public Beetl getBeetl() {
        return this.beetl;
    }

    public MetadataManager getMetaDataManager() {
        return this.metaDataManager;
    }

    public String getDefaultSchema() {
        return this.defaultSchema;
    }

    public void setDefaultSchema(String defaultSchema) {
        this.defaultSchema = defaultSchema;
    }

    public MapperBuilder getMapperBuilder() {
        return this.mapperBuilder;
    }

    public void setMapperBuilder(MapperBuilder mapperBuilder) {
        this.mapperBuilder = mapperBuilder;
    }

    public Interceptor[] getInters() {
        return this.inters;
    }

    public void setInters(Interceptor[] inters) {
        this.inters = inters;
    }

    public void addIdAutonGen(String name, IDAutoGen alorithm) {
        this.idAutonGenMap.put(name, alorithm);
    }

    protected Object getAssignIdByIdAutonGen(String name, String param, String table) {
        IDAutoGen idGen = this.idAutonGenMap.get(name);
        if (idGen == null) {
            throw new BeetlSQLException(15, "\u672a\u53d1\u73b0\u81ea\u52a8id\u751f\u6210\u5668:" + name + " in " + table);
        }
        return idGen.nextID(param);
    }

    public Map<String, BeanProcessor> getProcessors() {
        return this.processors;
    }

    public void setProcessors(Map<String, BeanProcessor> processors) {
        this.processors = processors;
    }

    public BeanProcessor getDefaultBeanProcessors() {
        return this.defaultBeanProcessors;
    }

    public void setDefaultBeanProcessors(BeanProcessor defaultBeanProcessors) {
        this.defaultBeanProcessors = defaultBeanProcessors;
    }

    public void setSQLIdNameConversion(SQLIdNameConversion sqlIdNc) {
        this.idNameConversion = sqlIdNc;
        this.sqlLoader.setSQLIdNameConversion(sqlIdNc);
    }

    public SQLIdNameConversion getSQLIdNameConversion() {
        return this.idNameConversion;
    }

    public MapperConfig getMapperConfig() {
        return this.mapperConfig;
    }

    public MapperConfig setBaseMapper(Class c) {
        this.mapperConfig = new MapperConfig(c);
        return this.mapperConfig;
    }

    public String getSQLManagerName() {
        return this.sqlMananagerName;
    }

    public void refresh() {
        this.metaDataManager.refresh();
        this.sqlLoader.refresh();
        this.beetl.getGroupTemplate().getProgramCache().clearAll();
    }

    public ClassLoader getEntityLoader() {
        return this.entityLoader;
    }

    public void setEntityLoader(ClassLoader entityLoader) {
        this.entityLoader = entityLoader;
        if (this.sqlLoader instanceof ClasspathLoader) {
            ((ClasspathLoader)this.sqlLoader).setClassLoader(entityLoader);
        }
    }
}

