/*
 * Decompiled with CFR 0.152.
 */
package proguard;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.ListIterator;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import proguard.ClassPathEntry;
import proguard.io.DataEntryFilter;
import proguard.io.DataEntryNameFilter;
import proguard.io.DataEntryReader;
import proguard.io.FilteredDataEntryReader;
import proguard.io.JarReader;
import proguard.io.PrefixStrippingDataEntryReader;
import proguard.io.RenamedDataEntryReader;
import proguard.util.AndMatcher;
import proguard.util.ConstantMatcher;
import proguard.util.ExtensionMatcher;
import proguard.util.FileNameParser;
import proguard.util.FixedStringMatcher;
import proguard.util.ListFunctionParser;
import proguard.util.ListParser;
import proguard.util.NotMatcher;
import proguard.util.SingleFunctionParser;
import proguard.util.StringFunction;
import proguard.util.StringFunctionParser;
import proguard.util.StringMatcher;
import proguard.util.StringParser;
import proguard.util.WildcardManager;

public class DataEntryReaderFactory {
    private static final Logger logger = LogManager.getLogger(DataEntryReaderFactory.class);
    private static final String VERSIONS_PATTERN = "META-INF/versions";
    private static final String VERSIONS_EXCLUDE = "!META-INF/versions/**";
    private static final String CLASS_FILE_PREFIX = "classes/";
    private final boolean android;
    private final boolean verbose;

    public DataEntryReaderFactory(boolean android, boolean verbose) {
        this.android = android;
        this.verbose = verbose;
    }

    public DataEntryReader createDataEntryReader(String messagePrefix, ClassPathEntry classPathEntry, DataEntryReader reader) {
        boolean isApk = classPathEntry.isApk();
        boolean isAab = classPathEntry.isAab();
        boolean isJar = classPathEntry.isJar();
        boolean isAar = classPathEntry.isAar();
        boolean isWar = classPathEntry.isWar();
        boolean isEar = classPathEntry.isEar();
        boolean isJmod = classPathEntry.isJmod();
        boolean isZip = classPathEntry.isZip();
        List filter = DataEntryReaderFactory.getFilterExcludingVersionedClasses(classPathEntry);
        List apkFilter = classPathEntry.getApkFilter();
        List aabFilter = classPathEntry.getAabFilter();
        List jarFilter = classPathEntry.getJarFilter();
        List aarFilter = classPathEntry.getAarFilter();
        List warFilter = classPathEntry.getWarFilter();
        List earFilter = classPathEntry.getEarFilter();
        List jmodFilter = classPathEntry.getJmodFilter();
        List zipFilter = classPathEntry.getZipFilter();
        logger.info("{}{} [{}]{}", (Object)messagePrefix, (Object)(isApk ? "apk" : (isAab ? "aab" : (isJar ? "jar" : (isAar ? "aar" : (isWar ? "war" : (isEar ? "ear" : (isJmod ? "jmod" : (isZip ? "zip" : "directory")))))))), (Object)classPathEntry.getName(), (Object)(filter != null || apkFilter != null || aabFilter != null || jarFilter != null || aarFilter != null || warFilter != null || earFilter != null || jmodFilter != null || zipFilter != null ? " (filtered)" : ""));
        if (filter != null) {
            WildcardManager wildcardManager = new WildcardManager();
            StringFunction nameFunction = new ListFunctionParser((StringFunctionParser)new SingleFunctionParser((StringParser)new FileNameParser(wildcardManager), wildcardManager)).parse(filter);
            reader = new RenamedDataEntryReader(nameFunction, reader);
        }
        reader = this.wrapInJarReader(reader, false, false, isApk, apkFilter, ".apk");
        if (!isApk) {
            reader = this.wrapInJarReader(reader, false, false, isAab, aabFilter, ".aab");
            if (!isAab) {
                reader = this.wrapInJarReader(reader, false, false, isJar, jarFilter, ".jar");
                if (!isJar) {
                    reader = this.wrapInJarReader(reader, false, false, isAar, aarFilter, ".aar");
                    if (!isAar) {
                        reader = this.wrapInJarReader(reader, true, false, isWar, warFilter, ".war");
                        if (!isWar) {
                            reader = this.wrapInJarReader(reader, false, false, isEar, earFilter, ".ear");
                            if (!isEar) {
                                reader = this.wrapInJarReader(reader, true, true, isJmod, jmodFilter, ".jmod");
                                if (!isJmod) {
                                    reader = this.wrapInJarReader(reader, false, false, isZip, zipFilter, ".zip");
                                }
                            }
                        }
                    }
                }
            }
        }
        return reader;
    }

    private DataEntryReader wrapInJarReader(DataEntryReader reader, boolean stripClassesPrefix, boolean stripJmodHeader, boolean isJar, List jarFilter, String jarExtension) {
        if (stripClassesPrefix) {
            reader = new FilteredDataEntryReader((DataEntryFilter)new DataEntryNameFilter((StringMatcher)new ExtensionMatcher(".class")), (DataEntryReader)new PrefixStrippingDataEntryReader(CLASS_FILE_PREFIX, reader), reader);
        }
        JarReader jarReader = new JarReader(stripJmodHeader, reader);
        if (isJar) {
            return jarReader;
        }
        if (jarFilter != null) {
            jarReader = new FilteredDataEntryReader((DataEntryFilter)new DataEntryNameFilter(new ListParser((StringParser)new FileNameParser()).parse(jarFilter)), (DataEntryReader)jarReader);
        }
        ExtensionMatcher jarMatcher = new ExtensionMatcher(jarExtension);
        if (this.android) {
            jarMatcher = new AndMatcher((StringMatcher)new NotMatcher((StringMatcher)new FixedStringMatcher("assets/", (StringMatcher)new ConstantMatcher(true))), (StringMatcher)jarMatcher);
        }
        return new FilteredDataEntryReader((DataEntryFilter)new DataEntryNameFilter((StringMatcher)jarMatcher), (DataEntryReader)jarReader, reader);
    }

    public static List getFilterExcludingVersionedClasses(ClassPathEntry classPathEntry) {
        List originalFilter = classPathEntry.getFilter();
        if (originalFilter == null) {
            return Arrays.asList(VERSIONS_EXCLUDE);
        }
        ListIterator it = originalFilter.listIterator();
        while (it.hasNext()) {
            String element = (String)it.next();
            if (!element.contains(VERSIONS_PATTERN)) continue;
            return originalFilter;
        }
        ArrayList<String> filter = new ArrayList<String>();
        filter.add(VERSIONS_EXCLUDE);
        filter.addAll(originalFilter);
        return filter;
    }
}

