/*
 * Decompiled with CFR 0.152.
 */
package proguard.optimize.info;

import proguard.classfile.Clazz;
import proguard.classfile.Member;
import proguard.classfile.Method;
import proguard.classfile.attribute.Attribute;
import proguard.classfile.attribute.CodeAttribute;
import proguard.classfile.attribute.visitor.AttributeVisitor;
import proguard.classfile.util.AllParameterVisitor;
import proguard.classfile.util.ClassUtil;
import proguard.classfile.visitor.MemberVisitor;
import proguard.classfile.visitor.ParameterVisitor;
import proguard.optimize.info.ProgramMethodOptimizationInfo;
import proguard.optimize.info.UsedParameterFilter;

public class UnusedParameterOptimizationInfoUpdater
implements AttributeVisitor,
ParameterVisitor {
    private static final boolean DEBUG = false;
    private final MemberVisitor extraUnusedParameterMethodVisitor;
    private final MemberVisitor unusedParameterRemover = new AllParameterVisitor(true, (ParameterVisitor)new UsedParameterFilter(null, this));
    private int removedParameterSize;
    private int removedParameterCount;

    public UnusedParameterOptimizationInfoUpdater() {
        this(null);
    }

    public UnusedParameterOptimizationInfoUpdater(MemberVisitor extraUnusedParameterMethodVisitor) {
        this.extraUnusedParameterMethodVisitor = extraUnusedParameterMethodVisitor;
    }

    public void visitAnyAttribute(Clazz clazz, Attribute attribute) {
    }

    public void visitCodeAttribute(Clazz clazz, Method method, CodeAttribute codeAttribute) {
        this.removedParameterCount = 0;
        this.removedParameterSize = 0;
        method.accept(clazz, this.unusedParameterRemover);
        ProgramMethodOptimizationInfo programMethodOptimizationInfo = ProgramMethodOptimizationInfo.getProgramMethodOptimizationInfo(method);
        int newParameterSize = programMethodOptimizationInfo.getParameterSize() - this.removedParameterSize;
        programMethodOptimizationInfo.setParameterSize(newParameterSize);
        programMethodOptimizationInfo.updateUsedParameters(-1L);
    }

    public void visitParameter(Clazz clazz, Member member, int parameterIndex, int parameterCount, int parameterOffset, int parameterSize, String parameterType, Clazz referencedClass) {
        Method method = (Method)member;
        ProgramMethodOptimizationInfo programMethodOptimizationInfo = ProgramMethodOptimizationInfo.getProgramMethodOptimizationInfo(method);
        programMethodOptimizationInfo.removeParameter(parameterIndex - this.removedParameterCount++);
        this.removedParameterSize += ClassUtil.internalTypeSize((String)parameterType);
        if (this.extraUnusedParameterMethodVisitor != null) {
            method.accept(clazz, this.extraUnusedParameterMethodVisitor);
        }
    }
}

