/*
 * Decompiled with CFR 0.152.
 */
package proguard;

import java.io.File;
import java.security.KeyStore;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import proguard.ClassPath;
import proguard.ClassPathEntry;
import proguard.DataEntryReaderFactory;
import proguard.ProGuard;
import proguard.classfile.ClassPool;
import proguard.io.CascadingDataEntryWriter;
import proguard.io.ClassDataEntryWriter;
import proguard.io.DataEntryFilter;
import proguard.io.DataEntryNameFilter;
import proguard.io.DataEntryParentFilter;
import proguard.io.DataEntryWriter;
import proguard.io.DirectoryWriter;
import proguard.io.FilteredDataEntryWriter;
import proguard.io.FixedFileWriter;
import proguard.io.NameFilteredDataEntryWriter;
import proguard.io.NonClosingDataEntryWriter;
import proguard.io.ParentDataEntryWriter;
import proguard.io.PrefixAddingDataEntryWriter;
import proguard.io.RenamedDataEntryWriter;
import proguard.io.SignedJarWriter;
import proguard.io.ZipWriter;
import proguard.resources.file.ResourceFilePool;
import proguard.util.ConstantStringFunction;
import proguard.util.ExtensionMatcher;
import proguard.util.FileNameParser;
import proguard.util.ListFunctionParser;
import proguard.util.ListParser;
import proguard.util.SingleFunctionParser;
import proguard.util.StringFunction;
import proguard.util.StringFunctionParser;
import proguard.util.StringMatcher;
import proguard.util.StringParser;
import proguard.util.WildcardManager;

public class DataEntryWriterFactory {
    private static final String CLASS_FILE_PATTERN = "**.class";
    private static final String CLASS_FILE_PREFIX = "classes/";
    private static final byte[] JMOD_HEADER = new byte[]{74, 77, 1, 0};
    private static final int PAGE_ALIGNMENT = 4096;
    private final String[][] JMOD_PREFIXES = new String[][]{{"**.class", "classes/"}};
    private final String[][] WAR_PREFIXES = new String[][]{{"**.class", "classes/"}};
    private final ClassPool programClassPool;
    private final ResourceFilePool resourceFilePool;
    private final int modificationTime;
    private final StringMatcher uncompressedFilter;
    private final int uncompressedAlignment;
    private final boolean pageAlignNativeLibs;
    private final boolean mergeBundleJars;
    private final KeyStore.PrivateKeyEntry[] privateKeyEntries;
    private Map<File, DataEntryWriter> jarWriterCache = new HashMap<File, DataEntryWriter>();

    public DataEntryWriterFactory(ClassPool programClassPool, ResourceFilePool resourceFilePool, int modificationTime, StringMatcher uncompressedFilter, int uncompressedAlignment, boolean pageAlignNativeLibs, boolean mergeBundleJars, KeyStore.PrivateKeyEntry[] privateKeyEntries) {
        this.programClassPool = programClassPool;
        this.resourceFilePool = resourceFilePool;
        this.modificationTime = modificationTime;
        this.uncompressedFilter = uncompressedFilter;
        this.uncompressedAlignment = uncompressedAlignment;
        this.pageAlignNativeLibs = pageAlignNativeLibs;
        this.mergeBundleJars = mergeBundleJars;
        this.privateKeyEntries = privateKeyEntries;
    }

    public DataEntryWriter createDataEntryWriter(ClassPath classPath, int fromIndex, int toIndex, DataEntryWriter extraDataEntryWriter) {
        DataEntryWriter writer = null;
        for (int index = toIndex - 1; index >= fromIndex; --index) {
            ClassPathEntry entry = classPath.get(index);
            boolean addCheckingJarWriter = !this.outputFileOccurs(entry, classPath, 0, index);
            boolean closeCachedJarWriter = !this.outputFileOccurs(entry, classPath, index + 1, classPath.size());
            writer = this.createClassPathEntryWriter(entry, writer, extraDataEntryWriter, addCheckingJarWriter, closeCachedJarWriter);
        }
        return writer;
    }

    private boolean outputFileOccurs(ClassPathEntry entry, ClassPath classPath, int startIndex, int endIndex) {
        File file = entry.getFile();
        for (int index = startIndex; index < endIndex; ++index) {
            ClassPathEntry classPathEntry = classPath.get(index);
            if (!classPathEntry.isOutput() || !classPathEntry.getFile().equals(file)) continue;
            return true;
        }
        return false;
    }

    private DataEntryWriter createClassPathEntryWriter(ClassPathEntry classPathEntry, DataEntryWriter alternativeWriter, DataEntryWriter extraDataEntryWriter, boolean addCheckingJarWriter, boolean closeCachedJarWriter) {
        File file = classPathEntry.getFile();
        boolean isApk = classPathEntry.isApk();
        boolean isAab = classPathEntry.isAab();
        boolean isJar = classPathEntry.isJar();
        boolean isAar = classPathEntry.isAar();
        boolean isWar = classPathEntry.isWar();
        boolean isEar = classPathEntry.isEar();
        boolean isJmod = classPathEntry.isJmod();
        boolean isZip = classPathEntry.isZip();
        List filter = DataEntryReaderFactory.getFilterExcludingVersionedClasses(classPathEntry);
        List apkFilter = classPathEntry.getApkFilter();
        List aabFilter = classPathEntry.getAabFilter();
        List jarFilter = classPathEntry.getJarFilter();
        List aarFilter = classPathEntry.getAarFilter();
        List warFilter = classPathEntry.getWarFilter();
        List earFilter = classPathEntry.getEarFilter();
        List jmodFilter = classPathEntry.getJmodFilter();
        List zipFilter = classPathEntry.getZipFilter();
        System.out.println("Preparing " + (this.privateKeyEntries == null ? "" : "signed ") + "output " + (isApk ? "apk" : (isAab ? "aab" : (isJar ? "jar" : (isAar ? "aar" : (isWar ? "war" : (isEar ? "ear" : (isJmod ? "jmod" : (isZip ? "zip" : "directory")))))))) + " [" + classPathEntry.getName() + "]" + (filter != null || apkFilter != null || aabFilter != null || jarFilter != null || aarFilter != null || warFilter != null || earFilter != null || jmodFilter != null || zipFilter != null ? " (filtered)" : ""));
        FixedFileWriter writer = isApk || isAab || isJar || isAar || isWar || isEar || isJmod || isZip ? new FixedFileWriter(file) : new DirectoryWriter(file);
        boolean flattenApks = false;
        boolean flattenAabs = flattenApks || isApk;
        boolean flattenJars = flattenAabs || isAab;
        boolean flattenAars = flattenJars || isJar;
        boolean flattenWars = flattenAars || isAar;
        boolean flattenEars = flattenWars || isWar;
        boolean flattenJmods = flattenEars || isEar;
        boolean flattenZips = flattenJmods || isJmod;
        writer = this.wrapInJarWriter(file, (DataEntryWriter)writer, extraDataEntryWriter, closeCachedJarWriter, flattenZips, isZip, false, ".zip", zipFilter, null, false, null);
        writer = this.wrapInJarWriter(file, (DataEntryWriter)writer, extraDataEntryWriter, closeCachedJarWriter, flattenJmods, isJmod, false, ".jmod", jmodFilter, JMOD_HEADER, false, this.JMOD_PREFIXES);
        writer = this.wrapInJarWriter(file, (DataEntryWriter)writer, extraDataEntryWriter, closeCachedJarWriter, flattenEars, isEar, false, ".ear", earFilter, null, false, null);
        writer = this.wrapInJarWriter(file, (DataEntryWriter)writer, extraDataEntryWriter, closeCachedJarWriter, flattenWars, isWar, false, ".war", warFilter, null, false, this.WAR_PREFIXES);
        writer = this.wrapInJarWriter(file, (DataEntryWriter)writer, extraDataEntryWriter, closeCachedJarWriter, flattenAars, isAar, false, ".aar", aarFilter, null, false, null);
        if (isAar && this.mergeBundleJars) {
            writer = new FilteredDataEntryWriter((DataEntryFilter)new DataEntryNameFilter((StringMatcher)new ExtensionMatcher(".jar")), (DataEntryWriter)new RenamedDataEntryWriter((StringFunction)new ConstantStringFunction("classes.jar"), (DataEntryWriter)writer), (DataEntryWriter)writer);
        }
        writer = this.wrapInJarWriter(file, (DataEntryWriter)writer, extraDataEntryWriter, closeCachedJarWriter, flattenJars, isJar, false, ".jar", jarFilter, null, false, null);
        writer = isAab ? this.wrapInJarWriter(file, (DataEntryWriter)writer, extraDataEntryWriter, closeCachedJarWriter, flattenAabs, isAab, true, ".aab", aabFilter, null, false, null) : this.wrapInJarWriter(file, (DataEntryWriter)writer, extraDataEntryWriter, closeCachedJarWriter, flattenApks, isApk, false, ".apk", apkFilter, null, this.pageAlignNativeLibs, null);
        ClassDataEntryWriter classWriter = new ClassDataEntryWriter(this.programClassPool, (DataEntryWriter)new NonClosingDataEntryWriter((DataEntryWriter)writer));
        if (filter != null) {
            WildcardManager wildcardManager = new WildcardManager();
            StringFunction fileNameFunction = new ListFunctionParser((StringFunctionParser)new SingleFunctionParser((StringParser)new FileNameParser(wildcardManager), wildcardManager)).parse(filter);
            classWriter = new RenamedDataEntryWriter(fileNameFunction, (DataEntryWriter)classWriter);
            writer = new RenamedDataEntryWriter(fileNameFunction, (DataEntryWriter)writer);
        }
        writer = new NameFilteredDataEntryWriter((StringMatcher)new ExtensionMatcher(".class"), (DataEntryWriter)classWriter, (DataEntryWriter)writer);
        return alternativeWriter != null ? new CascadingDataEntryWriter((DataEntryWriter)writer, alternativeWriter) : writer;
    }

    private DataEntryWriter wrapInJarWriter(File file, DataEntryWriter writer, DataEntryWriter extraDataEntryWriter, boolean closeCachedJarWriter, boolean flatten, boolean isJar, boolean isAab, String jarFilterExtension, List jarFilter, byte[] jarHeader, boolean pageAlignNativeLibs, String[][] prefixes) {
        ParentDataEntryWriter zipWriter;
        StringMatcher pageAlignmentFilter;
        StringMatcher stringMatcher = pageAlignmentFilter = pageAlignNativeLibs ? new FileNameParser().parse("lib/*/*.so") : null;
        if (flatten) {
            zipWriter = new ParentDataEntryWriter(writer);
        } else if (!isJar || (zipWriter = this.jarWriterCache.get(file)) == null) {
            zipWriter = this.wrapInSignedJarWriter(writer, extraDataEntryWriter, isAab, jarHeader, pageAlignmentFilter);
            if (prefixes != null) {
                ParentDataEntryWriter prefixlessJarWriter = zipWriter;
                for (int index = prefixes.length - 1; index >= 0; --index) {
                    String prefixFileNameFilter = prefixes[index][0];
                    String prefix = prefixes[index][1];
                    zipWriter = new FilteredDataEntryWriter((DataEntryFilter)new DataEntryNameFilter(new ListParser((StringParser)new FileNameParser()).parse(prefixFileNameFilter)), (DataEntryWriter)new PrefixAddingDataEntryWriter(prefix, (DataEntryWriter)prefixlessJarWriter), (DataEntryWriter)zipWriter);
                }
            }
            if (isJar) {
                this.jarWriterCache.put(file, (DataEntryWriter)zipWriter);
            }
        }
        if (isJar && !closeCachedJarWriter) {
            zipWriter = new NonClosingDataEntryWriter((DataEntryWriter)zipWriter);
        }
        return new FilteredDataEntryWriter((DataEntryFilter)new DataEntryParentFilter((DataEntryFilter)new DataEntryNameFilter((StringMatcher)new ExtensionMatcher(jarFilterExtension))), (DataEntryWriter)(jarFilter != null ? new FilteredDataEntryWriter((DataEntryFilter)new DataEntryParentFilter((DataEntryFilter)new DataEntryNameFilter(new ListParser((StringParser)new FileNameParser()).parse(jarFilter))), (DataEntryWriter)zipWriter) : zipWriter), (DataEntryWriter)(isJar ? zipWriter : writer));
    }

    private DataEntryWriter wrapInSignedJarWriter(DataEntryWriter writer, DataEntryWriter extraDataEntryWriter, boolean isAab, byte[] jarHeader, StringMatcher pageAlignmentFilter) {
        ZipWriter zipWriter = new ZipWriter(this.uncompressedFilter, this.uncompressedAlignment, pageAlignmentFilter, 4096, this.modificationTime, jarHeader, writer);
        if (this.privateKeyEntries != null) {
            zipWriter = new SignedJarWriter(this.privateKeyEntries[0], new String[]{"SHA-256"}, ProGuard.VERSION, null, (DataEntryWriter)zipWriter);
        }
        return zipWriter;
    }
}

