/*
 * Decompiled with CFR 0.152.
 */
package com.google.code.morphia.dao;

import com.google.code.morphia.Morphia;
import com.google.code.morphia.dao.MongoDAO;
import com.mongodb.BasicDBObject;
import com.mongodb.DBCollection;
import com.mongodb.DBCursor;
import com.mongodb.DBObject;
import com.mongodb.ObjectId;
import java.util.ArrayList;
import java.util.List;

public abstract class AbstractMongoDAO<T>
implements MongoDAO<T> {
    private final Class<T> entityClass;
    private final Morphia morphia;

    public AbstractMongoDAO(Class<T> entityClass, Morphia morphia) {
        this.entityClass = entityClass;
        this.morphia = morphia;
    }

    protected abstract DBCollection collection();

    @Override
    public long getCount() {
        return this.collection().getCount();
    }

    @Override
    public void removeById(String id) {
        this.collection().remove((DBObject)new BasicDBObject("_id", (Object)new ObjectId(id)));
    }

    @Override
    public T save(T entity) {
        BasicDBObject obj = (BasicDBObject)this.morphia.toDBObject(entity);
        this.collection().save((DBObject)obj);
        return this.get(obj.get("_id").toString());
    }

    @Override
    public boolean exists(String key, String value) {
        return this.collection().getCount((DBObject)new BasicDBObject(key, (Object)value)) > 0L;
    }

    @Override
    public boolean exists(String key, int value) {
        return this.collection().getCount((DBObject)new BasicDBObject(key, (Object)value)) > 0L;
    }

    @Override
    public boolean exists(String key, long value) {
        return this.collection().getCount((DBObject)new BasicDBObject(key, (Object)value)) > 0L;
    }

    @Override
    public boolean exists(String key, double value) {
        return this.collection().getCount((DBObject)new BasicDBObject(key, (Object)value)) > 0L;
    }

    @Override
    public boolean exists(String key, boolean value) {
        return this.collection().getCount((DBObject)new BasicDBObject(key, (Object)value)) > 0L;
    }

    @Override
    public boolean exists(String key, Enum value) {
        return this.collection().getCount((DBObject)new BasicDBObject(key, (Object)value.name())) > 0L;
    }

    @Override
    public T get(String id) {
        return this.morphia.fromDBObject(this.entityClass, (BasicDBObject)this.collection().findOne((Object)new ObjectId(id)));
    }

    @Override
    public T getByValue(String key, String value) {
        return this.morphia.fromDBObject(this.entityClass, (BasicDBObject)this.collection().findOne((DBObject)new BasicDBObject(key, (Object)value)));
    }

    @Override
    public T getByValue(String key, int value) {
        return this.morphia.fromDBObject(this.entityClass, (BasicDBObject)this.collection().findOne((DBObject)new BasicDBObject(key, (Object)value)));
    }

    @Override
    public T getByValue(String key, long value) {
        return this.morphia.fromDBObject(this.entityClass, (BasicDBObject)this.collection().findOne((DBObject)new BasicDBObject(key, (Object)value)));
    }

    @Override
    public T getByValue(String key, double value) {
        return this.morphia.fromDBObject(this.entityClass, (BasicDBObject)this.collection().findOne((DBObject)new BasicDBObject(key, (Object)value)));
    }

    @Override
    public T getByValue(String key, boolean value) {
        return this.morphia.fromDBObject(this.entityClass, (BasicDBObject)this.collection().findOne((DBObject)new BasicDBObject(key, (Object)value)));
    }

    @Override
    public T getByValue(String key, Enum value) {
        return this.morphia.fromDBObject(this.entityClass, (BasicDBObject)this.collection().findOne((DBObject)new BasicDBObject(key, (Object)value.name())));
    }

    @Override
    public void dropCollection() {
        this.collection().drop();
    }

    @Override
    public List<T> findAll(int startIndex, int resultSize) {
        DBCursor cursor = this.collection().find();
        if (startIndex > 0) {
            cursor.skip(startIndex);
        }
        cursor.limit(resultSize);
        return this.toList(cursor);
    }

    protected T map(BasicDBObject dbObject) {
        return this.morphia.fromDBObject(this.entityClass, dbObject);
    }

    protected List<T> toList(DBCursor cursor) {
        ArrayList<T> list = new ArrayList<T>();
        while (cursor.hasNext()) {
            list.add(this.morphia.fromDBObject(this.entityClass, (BasicDBObject)cursor.next()));
        }
        return list;
    }
}

