/*
 * Decompiled with CFR 0.152.
 */
package com.google.code.morphia;

import com.google.code.morphia.MongoMappingException;
import com.google.code.morphia.annotations.MongoCollectionName;
import com.google.code.morphia.annotations.MongoEmbedded;
import com.google.code.morphia.annotations.MongoID;
import com.google.code.morphia.annotations.MongoReference;
import com.google.code.morphia.annotations.MongoValue;
import com.google.code.morphia.utils.ReflectionUtils;
import java.lang.reflect.Field;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;

public class Validator {
    private static final Logger logger = Logger.getLogger(Validator.class.getName());

    Set<Class> validate(Class c, boolean dynamicInstantiation) {
        HashSet<Class> validClasses = new HashSet<Class>();
        this.validateInternal(c, validClasses, dynamicInstantiation, true, false);
        return validClasses;
    }

    private void validateInternal(Class c, Set<Class> validClasses, boolean dynamicInstantiation, boolean idFieldNeeded, boolean collectionNameFieldNeeded) {
        if (!validClasses.contains(c)) {
            if (logger.isLoggable(Level.FINE)) {
                logger.finer("Processing class: " + c.getName());
            }
            validClasses.add(c);
            if (!c.isInterface() || !dynamicInstantiation) {
                this.validateFields(c, ReflectionUtils.getDeclaredAndInheritedFields(c, true), validClasses, dynamicInstantiation, idFieldNeeded, collectionNameFieldNeeded);
            }
        }
    }

    private void validateFields(Class c, Field[] fields, Set<Class> validClasses, boolean dynamicInstantiation, boolean idFieldNeeded, boolean collectionNameFieldNeeded) {
        boolean foundIDField = false;
        boolean foundCollectionNameField = false;
        for (Field field : fields) {
            Class<?> fieldType;
            field.setAccessible(true);
            if (logger.isLoggable(Level.FINE)) {
                logger.finer("In [" + c.getName() + "]: Processing field: " + field.getName());
            }
            if (field.isAnnotationPresent(MongoValue.class)) {
                if (ReflectionUtils.implementsInterface(field.getType(), List.class)) {
                    if (ReflectionUtils.isFieldParameterizedWithPropertyType(field)) continue;
                    throw new MongoMappingException("In [" + c.getName() + "]: Field [" + field.getName() + "] which is a List annotated as @MongoValue is not parameterized with an invalid type.");
                }
                if (ReflectionUtils.isPropertyType(field.getType())) continue;
                throw new MongoMappingException("In [" + c.getName() + "]: Field [" + field.getName() + "] which is annotated as @MongoValue is of type that cannot be mapped (type is " + field.getType().getName() + ").");
            }
            if (field.isAnnotationPresent(MongoID.class)) {
                if (field.getType() != String.class) {
                    throw new MongoMappingException("In [" + c.getName() + "]: Field [" + field.getName() + "] which is annotated as @MongoID must be of type java.lang.String, but is of type: " + field.getType().getName());
                }
                foundIDField = true;
                continue;
            }
            if (field.isAnnotationPresent(MongoCollectionName.class)) {
                if (field.getType() != String.class) {
                    throw new MongoMappingException("In [" + c.getName() + "]: Field [" + field.getName() + "] which is annotated as @MongoCollectionName must be of type java.lang.String, but is of type: " + field.getType().getName());
                }
                foundCollectionNameField = true;
                continue;
            }
            if (field.isAnnotationPresent(MongoEmbedded.class)) {
                this.validateInternal(field.getType(), validClasses, dynamicInstantiation, false, false);
                continue;
            }
            if (!field.isAnnotationPresent(MongoReference.class) || (fieldType = ReflectionUtils.implementsInterface(field.getType(), List.class) ? ReflectionUtils.getParameterizedClass(field) : field.getType()) == null) continue;
            this.validateInternal(fieldType, validClasses, dynamicInstantiation, true, true);
        }
        if (!foundIDField && idFieldNeeded) {
            throw new MongoMappingException("In [" + c.getName() + "]: No field is annotated with @MongoID");
        }
        if (!foundCollectionNameField && collectionNameFieldNeeded) {
            throw new MongoMappingException("In [" + c.getName() + "]: No field is annotated with @MongoCollectionName");
        }
    }
}

