/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.aiplatform.v1beta1;

import com.google.api.core.ApiFuture;
import com.google.api.core.ApiFutures;
import com.google.api.core.BetaApi;
import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.paging.AbstractFixedSizeCollection;
import com.google.api.gax.paging.AbstractPage;
import com.google.api.gax.paging.AbstractPagedListResponse;
import com.google.api.gax.rpc.PageContext;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.aiplatform.v1beta1.Content;
import com.google.cloud.aiplatform.v1beta1.ExecuteExtensionRequest;
import com.google.cloud.aiplatform.v1beta1.ExecuteExtensionResponse;
import com.google.cloud.aiplatform.v1beta1.ExtensionExecutionServiceSettings;
import com.google.cloud.aiplatform.v1beta1.ExtensionName;
import com.google.cloud.aiplatform.v1beta1.QueryExtensionRequest;
import com.google.cloud.aiplatform.v1beta1.QueryExtensionResponse;
import com.google.cloud.aiplatform.v1beta1.stub.ExtensionExecutionServiceStub;
import com.google.cloud.aiplatform.v1beta1.stub.ExtensionExecutionServiceStubSettings;
import com.google.cloud.location.GetLocationRequest;
import com.google.cloud.location.ListLocationsRequest;
import com.google.cloud.location.ListLocationsResponse;
import com.google.cloud.location.Location;
import com.google.common.util.concurrent.MoreExecutors;
import com.google.iam.v1.GetIamPolicyRequest;
import com.google.iam.v1.Policy;
import com.google.iam.v1.SetIamPolicyRequest;
import com.google.iam.v1.TestIamPermissionsRequest;
import com.google.iam.v1.TestIamPermissionsResponse;
import java.io.IOException;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;

@BetaApi
public class ExtensionExecutionServiceClient
implements BackgroundResource {
    private final ExtensionExecutionServiceSettings settings;
    private final ExtensionExecutionServiceStub stub;

    public static final ExtensionExecutionServiceClient create() throws IOException {
        return ExtensionExecutionServiceClient.create(ExtensionExecutionServiceSettings.newBuilder().build());
    }

    public static final ExtensionExecutionServiceClient create(ExtensionExecutionServiceSettings settings) throws IOException {
        return new ExtensionExecutionServiceClient(settings);
    }

    public static final ExtensionExecutionServiceClient create(ExtensionExecutionServiceStub stub) {
        return new ExtensionExecutionServiceClient(stub);
    }

    protected ExtensionExecutionServiceClient(ExtensionExecutionServiceSettings settings) throws IOException {
        this.settings = settings;
        this.stub = ((ExtensionExecutionServiceStubSettings)settings.getStubSettings()).createStub();
    }

    protected ExtensionExecutionServiceClient(ExtensionExecutionServiceStub stub) {
        this.settings = null;
        this.stub = stub;
    }

    public final ExtensionExecutionServiceSettings getSettings() {
        return this.settings;
    }

    public ExtensionExecutionServiceStub getStub() {
        return this.stub;
    }

    public final ExecuteExtensionResponse executeExtension(ExtensionName name, String operationId) {
        ExecuteExtensionRequest request = ExecuteExtensionRequest.newBuilder().setName(name == null ? null : name.toString()).setOperationId(operationId).build();
        return this.executeExtension(request);
    }

    public final ExecuteExtensionResponse executeExtension(String name, String operationId) {
        ExecuteExtensionRequest request = ExecuteExtensionRequest.newBuilder().setName(name).setOperationId(operationId).build();
        return this.executeExtension(request);
    }

    public final ExecuteExtensionResponse executeExtension(ExecuteExtensionRequest request) {
        return (ExecuteExtensionResponse)this.executeExtensionCallable().call((Object)request);
    }

    public final UnaryCallable<ExecuteExtensionRequest, ExecuteExtensionResponse> executeExtensionCallable() {
        return this.stub.executeExtensionCallable();
    }

    public final QueryExtensionResponse queryExtension(ExtensionName name, List<Content> contents) {
        QueryExtensionRequest request = QueryExtensionRequest.newBuilder().setName(name == null ? null : name.toString()).addAllContents(contents).build();
        return this.queryExtension(request);
    }

    public final QueryExtensionResponse queryExtension(String name, List<Content> contents) {
        QueryExtensionRequest request = QueryExtensionRequest.newBuilder().setName(name).addAllContents(contents).build();
        return this.queryExtension(request);
    }

    public final QueryExtensionResponse queryExtension(QueryExtensionRequest request) {
        return (QueryExtensionResponse)this.queryExtensionCallable().call((Object)request);
    }

    public final UnaryCallable<QueryExtensionRequest, QueryExtensionResponse> queryExtensionCallable() {
        return this.stub.queryExtensionCallable();
    }

    public final ListLocationsPagedResponse listLocations(ListLocationsRequest request) {
        return (ListLocationsPagedResponse)((Object)this.listLocationsPagedCallable().call((Object)request));
    }

    public final UnaryCallable<ListLocationsRequest, ListLocationsPagedResponse> listLocationsPagedCallable() {
        return this.stub.listLocationsPagedCallable();
    }

    public final UnaryCallable<ListLocationsRequest, ListLocationsResponse> listLocationsCallable() {
        return this.stub.listLocationsCallable();
    }

    public final Location getLocation(GetLocationRequest request) {
        return (Location)this.getLocationCallable().call((Object)request);
    }

    public final UnaryCallable<GetLocationRequest, Location> getLocationCallable() {
        return this.stub.getLocationCallable();
    }

    public final Policy setIamPolicy(SetIamPolicyRequest request) {
        return (Policy)this.setIamPolicyCallable().call((Object)request);
    }

    public final UnaryCallable<SetIamPolicyRequest, Policy> setIamPolicyCallable() {
        return this.stub.setIamPolicyCallable();
    }

    public final Policy getIamPolicy(GetIamPolicyRequest request) {
        return (Policy)this.getIamPolicyCallable().call((Object)request);
    }

    public final UnaryCallable<GetIamPolicyRequest, Policy> getIamPolicyCallable() {
        return this.stub.getIamPolicyCallable();
    }

    public final TestIamPermissionsResponse testIamPermissions(TestIamPermissionsRequest request) {
        return (TestIamPermissionsResponse)this.testIamPermissionsCallable().call((Object)request);
    }

    public final UnaryCallable<TestIamPermissionsRequest, TestIamPermissionsResponse> testIamPermissionsCallable() {
        return this.stub.testIamPermissionsCallable();
    }

    public final void close() {
        this.stub.close();
    }

    public void shutdown() {
        this.stub.shutdown();
    }

    public boolean isShutdown() {
        return this.stub.isShutdown();
    }

    public boolean isTerminated() {
        return this.stub.isTerminated();
    }

    public void shutdownNow() {
        this.stub.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.stub.awaitTermination(duration, unit);
    }

    public static class ListLocationsFixedSizeCollection
    extends AbstractFixedSizeCollection<ListLocationsRequest, ListLocationsResponse, Location, ListLocationsPage, ListLocationsFixedSizeCollection> {
        private ListLocationsFixedSizeCollection(List<ListLocationsPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ListLocationsFixedSizeCollection createEmptyCollection() {
            return new ListLocationsFixedSizeCollection(null, 0);
        }

        protected ListLocationsFixedSizeCollection createCollection(List<ListLocationsPage> pages, int collectionSize) {
            return new ListLocationsFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class ListLocationsPage
    extends AbstractPage<ListLocationsRequest, ListLocationsResponse, Location, ListLocationsPage> {
        private ListLocationsPage(PageContext<ListLocationsRequest, ListLocationsResponse, Location> context, ListLocationsResponse response) {
            super(context, (Object)response);
        }

        private static ListLocationsPage createEmptyPage() {
            return new ListLocationsPage(null, null);
        }

        protected ListLocationsPage createPage(PageContext<ListLocationsRequest, ListLocationsResponse, Location> context, ListLocationsResponse response) {
            return new ListLocationsPage(context, response);
        }

        public ApiFuture<ListLocationsPage> createPageAsync(PageContext<ListLocationsRequest, ListLocationsResponse, Location> context, ApiFuture<ListLocationsResponse> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class ListLocationsPagedResponse
    extends AbstractPagedListResponse<ListLocationsRequest, ListLocationsResponse, Location, ListLocationsPage, ListLocationsFixedSizeCollection> {
        public static ApiFuture<ListLocationsPagedResponse> createAsync(PageContext<ListLocationsRequest, ListLocationsResponse, Location> context, ApiFuture<ListLocationsResponse> futureResponse) {
            ApiFuture<ListLocationsPage> futurePage = ListLocationsPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, input -> new ListLocationsPagedResponse((ListLocationsPage)((Object)input)), (Executor)MoreExecutors.directExecutor());
        }

        private ListLocationsPagedResponse(ListLocationsPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)ListLocationsFixedSizeCollection.createEmptyCollection());
        }
    }
}

