/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.customsearch.v1.model;

/**
 * A custom search result.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Custom Search API. For a detailed explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class Result extends com.google.api.client.json.GenericJson {

  /**
   * Indicates the ID of Google's cached version of the search result.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String cacheId;

  /**
   * An abridged version of this search result’s URL, e.g. www.example.com.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String displayLink;

  /**
   * The file format of the search result.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String fileFormat;

  /**
   * The URL displayed after the snippet for each search result.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String formattedUrl;

  /**
   * The HTML-formatted URL displayed after the snippet for each search result.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String htmlFormattedUrl;

  /**
   * The snippet of the search result, in HTML.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String htmlSnippet;

  /**
   * The title of the search result, in HTML.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String htmlTitle;

  /**
   * Image belonging to a custom search result.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private Image image;

  /**
   * A unique identifier for the type of current object. For this API, it is `customsearch#result.`
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String kind;

  /**
   * Encapsulates all information about refinement labels.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.List<Labels> labels;

  static {
    // hack to force ProGuard to consider Labels used, since otherwise it would be stripped out
    // see https://github.com/google/google-api-java-client/issues/543
    com.google.api.client.util.Data.nullOf(Labels.class);
  }

  /**
   * The full URL to which the search result is pointing, e.g. http://www.example.com/foo/bar.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String link;

  /**
   * The MIME type of the search result.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String mime;

  /**
   * Contains [PageMap](https://developers.google.com/custom-search/docs/structured_data#pagemaps)
   * information for this search result.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.Map<String, java.lang.Object> pagemap;

  /**
   * The snippet of the search result, in plain text.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String snippet;

  /**
   * The title of the search result, in plain text.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String title;

  /**
   * Indicates the ID of Google's cached version of the search result.
   * @return value or {@code null} for none
   */
  public java.lang.String getCacheId() {
    return cacheId;
  }

  /**
   * Indicates the ID of Google's cached version of the search result.
   * @param cacheId cacheId or {@code null} for none
   */
  public Result setCacheId(java.lang.String cacheId) {
    this.cacheId = cacheId;
    return this;
  }

  /**
   * An abridged version of this search result’s URL, e.g. www.example.com.
   * @return value or {@code null} for none
   */
  public java.lang.String getDisplayLink() {
    return displayLink;
  }

  /**
   * An abridged version of this search result’s URL, e.g. www.example.com.
   * @param displayLink displayLink or {@code null} for none
   */
  public Result setDisplayLink(java.lang.String displayLink) {
    this.displayLink = displayLink;
    return this;
  }

  /**
   * The file format of the search result.
   * @return value or {@code null} for none
   */
  public java.lang.String getFileFormat() {
    return fileFormat;
  }

  /**
   * The file format of the search result.
   * @param fileFormat fileFormat or {@code null} for none
   */
  public Result setFileFormat(java.lang.String fileFormat) {
    this.fileFormat = fileFormat;
    return this;
  }

  /**
   * The URL displayed after the snippet for each search result.
   * @return value or {@code null} for none
   */
  public java.lang.String getFormattedUrl() {
    return formattedUrl;
  }

  /**
   * The URL displayed after the snippet for each search result.
   * @param formattedUrl formattedUrl or {@code null} for none
   */
  public Result setFormattedUrl(java.lang.String formattedUrl) {
    this.formattedUrl = formattedUrl;
    return this;
  }

  /**
   * The HTML-formatted URL displayed after the snippet for each search result.
   * @return value or {@code null} for none
   */
  public java.lang.String getHtmlFormattedUrl() {
    return htmlFormattedUrl;
  }

  /**
   * The HTML-formatted URL displayed after the snippet for each search result.
   * @param htmlFormattedUrl htmlFormattedUrl or {@code null} for none
   */
  public Result setHtmlFormattedUrl(java.lang.String htmlFormattedUrl) {
    this.htmlFormattedUrl = htmlFormattedUrl;
    return this;
  }

  /**
   * The snippet of the search result, in HTML.
   * @return value or {@code null} for none
   */
  public java.lang.String getHtmlSnippet() {
    return htmlSnippet;
  }

  /**
   * The snippet of the search result, in HTML.
   * @param htmlSnippet htmlSnippet or {@code null} for none
   */
  public Result setHtmlSnippet(java.lang.String htmlSnippet) {
    this.htmlSnippet = htmlSnippet;
    return this;
  }

  /**
   * The title of the search result, in HTML.
   * @return value or {@code null} for none
   */
  public java.lang.String getHtmlTitle() {
    return htmlTitle;
  }

  /**
   * The title of the search result, in HTML.
   * @param htmlTitle htmlTitle or {@code null} for none
   */
  public Result setHtmlTitle(java.lang.String htmlTitle) {
    this.htmlTitle = htmlTitle;
    return this;
  }

  /**
   * Image belonging to a custom search result.
   * @return value or {@code null} for none
   */
  public Image getImage() {
    return image;
  }

  /**
   * Image belonging to a custom search result.
   * @param image image or {@code null} for none
   */
  public Result setImage(Image image) {
    this.image = image;
    return this;
  }

  /**
   * A unique identifier for the type of current object. For this API, it is `customsearch#result.`
   * @return value or {@code null} for none
   */
  public java.lang.String getKind() {
    return kind;
  }

  /**
   * A unique identifier for the type of current object. For this API, it is `customsearch#result.`
   * @param kind kind or {@code null} for none
   */
  public Result setKind(java.lang.String kind) {
    this.kind = kind;
    return this;
  }

  /**
   * Encapsulates all information about refinement labels.
   * @return value or {@code null} for none
   */
  public java.util.List<Labels> getLabels() {
    return labels;
  }

  /**
   * Encapsulates all information about refinement labels.
   * @param labels labels or {@code null} for none
   */
  public Result setLabels(java.util.List<Labels> labels) {
    this.labels = labels;
    return this;
  }

  /**
   * The full URL to which the search result is pointing, e.g. http://www.example.com/foo/bar.
   * @return value or {@code null} for none
   */
  public java.lang.String getLink() {
    return link;
  }

  /**
   * The full URL to which the search result is pointing, e.g. http://www.example.com/foo/bar.
   * @param link link or {@code null} for none
   */
  public Result setLink(java.lang.String link) {
    this.link = link;
    return this;
  }

  /**
   * The MIME type of the search result.
   * @return value or {@code null} for none
   */
  public java.lang.String getMime() {
    return mime;
  }

  /**
   * The MIME type of the search result.
   * @param mime mime or {@code null} for none
   */
  public Result setMime(java.lang.String mime) {
    this.mime = mime;
    return this;
  }

  /**
   * Contains [PageMap](https://developers.google.com/custom-search/docs/structured_data#pagemaps)
   * information for this search result.
   * @return value or {@code null} for none
   */
  public java.util.Map<String, java.lang.Object> getPagemap() {
    return pagemap;
  }

  /**
   * Contains [PageMap](https://developers.google.com/custom-search/docs/structured_data#pagemaps)
   * information for this search result.
   * @param pagemap pagemap or {@code null} for none
   */
  public Result setPagemap(java.util.Map<String, java.lang.Object> pagemap) {
    this.pagemap = pagemap;
    return this;
  }

  /**
   * The snippet of the search result, in plain text.
   * @return value or {@code null} for none
   */
  public java.lang.String getSnippet() {
    return snippet;
  }

  /**
   * The snippet of the search result, in plain text.
   * @param snippet snippet or {@code null} for none
   */
  public Result setSnippet(java.lang.String snippet) {
    this.snippet = snippet;
    return this;
  }

  /**
   * The title of the search result, in plain text.
   * @return value or {@code null} for none
   */
  public java.lang.String getTitle() {
    return title;
  }

  /**
   * The title of the search result, in plain text.
   * @param title title or {@code null} for none
   */
  public Result setTitle(java.lang.String title) {
    this.title = title;
    return this;
  }

  @Override
  public Result set(String fieldName, Object value) {
    return (Result) super.set(fieldName, value);
  }

  @Override
  public Result clone() {
    return (Result) super.clone();
  }

  /**
   * Image belonging to a custom search result.
   */
  public static final class Image extends com.google.api.client.json.GenericJson {

    /**
     * The size of the image, in bytes.
     * The value may be {@code null}.
     */
    @com.google.api.client.util.Key
    private java.lang.Integer byteSize;

    /**
     * A URL pointing to the webpage hosting the image.
     * The value may be {@code null}.
     */
    @com.google.api.client.util.Key
    private java.lang.String contextLink;

    /**
     * The height of the image, in pixels.
     * The value may be {@code null}.
     */
    @com.google.api.client.util.Key
    private java.lang.Integer height;

    /**
     * The height of the thumbnail image, in pixels.
     * The value may be {@code null}.
     */
    @com.google.api.client.util.Key
    private java.lang.Integer thumbnailHeight;

    /**
     * A URL to the thumbnail image.
     * The value may be {@code null}.
     */
    @com.google.api.client.util.Key
    private java.lang.String thumbnailLink;

    /**
     * The width of the thumbnail image, in pixels.
     * The value may be {@code null}.
     */
    @com.google.api.client.util.Key
    private java.lang.Integer thumbnailWidth;

    /**
     * The width of the image, in pixels.
     * The value may be {@code null}.
     */
    @com.google.api.client.util.Key
    private java.lang.Integer width;

    /**
     * The size of the image, in bytes.
     * @return value or {@code null} for none
     */
    public java.lang.Integer getByteSize() {
      return byteSize;
    }

    /**
     * The size of the image, in bytes.
     * @param byteSize byteSize or {@code null} for none
     */
    public Image setByteSize(java.lang.Integer byteSize) {
      this.byteSize = byteSize;
      return this;
    }

    /**
     * A URL pointing to the webpage hosting the image.
     * @return value or {@code null} for none
     */
    public java.lang.String getContextLink() {
      return contextLink;
    }

    /**
     * A URL pointing to the webpage hosting the image.
     * @param contextLink contextLink or {@code null} for none
     */
    public Image setContextLink(java.lang.String contextLink) {
      this.contextLink = contextLink;
      return this;
    }

    /**
     * The height of the image, in pixels.
     * @return value or {@code null} for none
     */
    public java.lang.Integer getHeight() {
      return height;
    }

    /**
     * The height of the image, in pixels.
     * @param height height or {@code null} for none
     */
    public Image setHeight(java.lang.Integer height) {
      this.height = height;
      return this;
    }

    /**
     * The height of the thumbnail image, in pixels.
     * @return value or {@code null} for none
     */
    public java.lang.Integer getThumbnailHeight() {
      return thumbnailHeight;
    }

    /**
     * The height of the thumbnail image, in pixels.
     * @param thumbnailHeight thumbnailHeight or {@code null} for none
     */
    public Image setThumbnailHeight(java.lang.Integer thumbnailHeight) {
      this.thumbnailHeight = thumbnailHeight;
      return this;
    }

    /**
     * A URL to the thumbnail image.
     * @return value or {@code null} for none
     */
    public java.lang.String getThumbnailLink() {
      return thumbnailLink;
    }

    /**
     * A URL to the thumbnail image.
     * @param thumbnailLink thumbnailLink or {@code null} for none
     */
    public Image setThumbnailLink(java.lang.String thumbnailLink) {
      this.thumbnailLink = thumbnailLink;
      return this;
    }

    /**
     * The width of the thumbnail image, in pixels.
     * @return value or {@code null} for none
     */
    public java.lang.Integer getThumbnailWidth() {
      return thumbnailWidth;
    }

    /**
     * The width of the thumbnail image, in pixels.
     * @param thumbnailWidth thumbnailWidth or {@code null} for none
     */
    public Image setThumbnailWidth(java.lang.Integer thumbnailWidth) {
      this.thumbnailWidth = thumbnailWidth;
      return this;
    }

    /**
     * The width of the image, in pixels.
     * @return value or {@code null} for none
     */
    public java.lang.Integer getWidth() {
      return width;
    }

    /**
     * The width of the image, in pixels.
     * @param width width or {@code null} for none
     */
    public Image setWidth(java.lang.Integer width) {
      this.width = width;
      return this;
    }

    @Override
    public Image set(String fieldName, Object value) {
      return (Image) super.set(fieldName, value);
    }

    @Override
    public Image clone() {
      return (Image) super.clone();
    }

  }

  /**
   * Refinement label associated with a custom search result.
   */
  public static final class Labels extends com.google.api.client.json.GenericJson {

    /**
     * The display name of a refinement label. This is the name you should display in your user
     * interface.
     * The value may be {@code null}.
     */
    @com.google.api.client.util.Key
    private java.lang.String displayName;

    /**
     * Refinement label and the associated refinement operation.
     * The value may be {@code null}.
     */
    @com.google.api.client.util.Key("label_with_op")
    private java.lang.String labelWithOp;

    /**
     * The name of a refinement label, which you can use to refine searches. Don't display this in
     * your user interface; instead, use displayName.
     * The value may be {@code null}.
     */
    @com.google.api.client.util.Key
    private java.lang.String name;

    /**
     * The display name of a refinement label. This is the name you should display in your user
     * interface.
     * @return value or {@code null} for none
     */
    public java.lang.String getDisplayName() {
      return displayName;
    }

    /**
     * The display name of a refinement label. This is the name you should display in your user
     * interface.
     * @param displayName displayName or {@code null} for none
     */
    public Labels setDisplayName(java.lang.String displayName) {
      this.displayName = displayName;
      return this;
    }

    /**
     * Refinement label and the associated refinement operation.
     * @return value or {@code null} for none
     */
    public java.lang.String getLabelWithOp() {
      return labelWithOp;
    }

    /**
     * Refinement label and the associated refinement operation.
     * @param labelWithOp labelWithOp or {@code null} for none
     */
    public Labels setLabelWithOp(java.lang.String labelWithOp) {
      this.labelWithOp = labelWithOp;
      return this;
    }

    /**
     * The name of a refinement label, which you can use to refine searches. Don't display this in
     * your user interface; instead, use displayName.
     * @return value or {@code null} for none
     */
    public java.lang.String getName() {
      return name;
    }

    /**
     * The name of a refinement label, which you can use to refine searches. Don't display this in
     * your user interface; instead, use displayName.
     * @param name name or {@code null} for none
     */
    public Labels setName(java.lang.String name) {
      this.name = name;
      return this;
    }

    @Override
    public Labels set(String fieldName, Object value) {
      return (Labels) super.set(fieldName, value);
    }

    @Override
    public Labels clone() {
      return (Labels) super.clone();
    }

  }

}
