/*
 * Copyright 2020 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/apps/card/v1/card.proto

// Protobuf Java Version: 3.25.3
package com.google.apps.card.v1;

public interface SelectionInputOrBuilder
    extends
    // @@protoc_insertion_point(interface_extends:google.apps.card.v1.SelectionInput)
    com.google.protobuf.MessageOrBuilder {

  /**
   *
   *
   * <pre>
   * The name that identifies the selection input in a form input event.
   *
   * For details about working with form inputs, see [Receive form
   * data](https://developers.google.com/workspace/chat/read-form-data).
   * </pre>
   *
   * <code>string name = 1;</code>
   *
   * @return The name.
   */
  java.lang.String getName();
  /**
   *
   *
   * <pre>
   * The name that identifies the selection input in a form input event.
   *
   * For details about working with form inputs, see [Receive form
   * data](https://developers.google.com/workspace/chat/read-form-data).
   * </pre>
   *
   * <code>string name = 1;</code>
   *
   * @return The bytes for name.
   */
  com.google.protobuf.ByteString getNameBytes();

  /**
   *
   *
   * <pre>
   * The text that appears above the selection input field in the user
   * interface.
   *
   * Specify text that helps the user enter the information your app needs.
   * For example, if users are selecting the urgency of a work ticket from a
   * drop-down menu, the label might be "Urgency" or "Select urgency".
   * </pre>
   *
   * <code>string label = 2;</code>
   *
   * @return The label.
   */
  java.lang.String getLabel();
  /**
   *
   *
   * <pre>
   * The text that appears above the selection input field in the user
   * interface.
   *
   * Specify text that helps the user enter the information your app needs.
   * For example, if users are selecting the urgency of a work ticket from a
   * drop-down menu, the label might be "Urgency" or "Select urgency".
   * </pre>
   *
   * <code>string label = 2;</code>
   *
   * @return The bytes for label.
   */
  com.google.protobuf.ByteString getLabelBytes();

  /**
   *
   *
   * <pre>
   * The type of items that are displayed to users in a `SelectionInput` widget.
   * Selection types support different types of interactions. For example, users
   * can select one or more checkboxes, but they can only select one value from
   * a dropdown menu.
   * </pre>
   *
   * <code>.google.apps.card.v1.SelectionInput.SelectionType type = 3;</code>
   *
   * @return The enum numeric value on the wire for type.
   */
  int getTypeValue();
  /**
   *
   *
   * <pre>
   * The type of items that are displayed to users in a `SelectionInput` widget.
   * Selection types support different types of interactions. For example, users
   * can select one or more checkboxes, but they can only select one value from
   * a dropdown menu.
   * </pre>
   *
   * <code>.google.apps.card.v1.SelectionInput.SelectionType type = 3;</code>
   *
   * @return The type.
   */
  com.google.apps.card.v1.SelectionInput.SelectionType getType();

  /**
   *
   *
   * <pre>
   * An array of selectable items. For example, an array of radio buttons or
   * checkboxes. Supports up to 100 items.
   * </pre>
   *
   * <code>repeated .google.apps.card.v1.SelectionInput.SelectionItem items = 4;</code>
   */
  java.util.List<com.google.apps.card.v1.SelectionInput.SelectionItem> getItemsList();
  /**
   *
   *
   * <pre>
   * An array of selectable items. For example, an array of radio buttons or
   * checkboxes. Supports up to 100 items.
   * </pre>
   *
   * <code>repeated .google.apps.card.v1.SelectionInput.SelectionItem items = 4;</code>
   */
  com.google.apps.card.v1.SelectionInput.SelectionItem getItems(int index);
  /**
   *
   *
   * <pre>
   * An array of selectable items. For example, an array of radio buttons or
   * checkboxes. Supports up to 100 items.
   * </pre>
   *
   * <code>repeated .google.apps.card.v1.SelectionInput.SelectionItem items = 4;</code>
   */
  int getItemsCount();
  /**
   *
   *
   * <pre>
   * An array of selectable items. For example, an array of radio buttons or
   * checkboxes. Supports up to 100 items.
   * </pre>
   *
   * <code>repeated .google.apps.card.v1.SelectionInput.SelectionItem items = 4;</code>
   */
  java.util.List<? extends com.google.apps.card.v1.SelectionInput.SelectionItemOrBuilder>
      getItemsOrBuilderList();
  /**
   *
   *
   * <pre>
   * An array of selectable items. For example, an array of radio buttons or
   * checkboxes. Supports up to 100 items.
   * </pre>
   *
   * <code>repeated .google.apps.card.v1.SelectionInput.SelectionItem items = 4;</code>
   */
  com.google.apps.card.v1.SelectionInput.SelectionItemOrBuilder getItemsOrBuilder(int index);

  /**
   *
   *
   * <pre>
   * If specified, the form is submitted when the selection changes. If not
   * specified, you must specify a separate button that submits the form.
   *
   * For details about working with form inputs, see [Receive form
   * data](https://developers.google.com/workspace/chat/read-form-data).
   * </pre>
   *
   * <code>.google.apps.card.v1.Action on_change_action = 5;</code>
   *
   * @return Whether the onChangeAction field is set.
   */
  boolean hasOnChangeAction();
  /**
   *
   *
   * <pre>
   * If specified, the form is submitted when the selection changes. If not
   * specified, you must specify a separate button that submits the form.
   *
   * For details about working with form inputs, see [Receive form
   * data](https://developers.google.com/workspace/chat/read-form-data).
   * </pre>
   *
   * <code>.google.apps.card.v1.Action on_change_action = 5;</code>
   *
   * @return The onChangeAction.
   */
  com.google.apps.card.v1.Action getOnChangeAction();
  /**
   *
   *
   * <pre>
   * If specified, the form is submitted when the selection changes. If not
   * specified, you must specify a separate button that submits the form.
   *
   * For details about working with form inputs, see [Receive form
   * data](https://developers.google.com/workspace/chat/read-form-data).
   * </pre>
   *
   * <code>.google.apps.card.v1.Action on_change_action = 5;</code>
   */
  com.google.apps.card.v1.ActionOrBuilder getOnChangeActionOrBuilder();

  /**
   *
   *
   * <pre>
   * For multiselect menus, the maximum number of items that a user can select.
   * Minimum value is 1 item. If unspecified, defaults to 3 items.
   * </pre>
   *
   * <code>int32 multi_select_max_selected_items = 6;</code>
   *
   * @return The multiSelectMaxSelectedItems.
   */
  int getMultiSelectMaxSelectedItems();

  /**
   *
   *
   * <pre>
   * For multiselect menus, the number of text characters that a user inputs
   * before the app queries autocomplete and displays suggested items
   * in the menu.
   *
   * If unspecified, defaults to 0 characters for static data sources and 3
   * characters for external data sources.
   * </pre>
   *
   * <code>int32 multi_select_min_query_length = 7;</code>
   *
   * @return The multiSelectMinQueryLength.
   */
  int getMultiSelectMinQueryLength();

  /**
   *
   *
   * <pre>
   * An external data source, such as a relational data base.
   * </pre>
   *
   * <code>.google.apps.card.v1.Action external_data_source = 8;</code>
   *
   * @return Whether the externalDataSource field is set.
   */
  boolean hasExternalDataSource();
  /**
   *
   *
   * <pre>
   * An external data source, such as a relational data base.
   * </pre>
   *
   * <code>.google.apps.card.v1.Action external_data_source = 8;</code>
   *
   * @return The externalDataSource.
   */
  com.google.apps.card.v1.Action getExternalDataSource();
  /**
   *
   *
   * <pre>
   * An external data source, such as a relational data base.
   * </pre>
   *
   * <code>.google.apps.card.v1.Action external_data_source = 8;</code>
   */
  com.google.apps.card.v1.ActionOrBuilder getExternalDataSourceOrBuilder();

  /**
   *
   *
   * <pre>
   * A data source from Google Workspace.
   * </pre>
   *
   * <code>.google.apps.card.v1.SelectionInput.PlatformDataSource platform_data_source = 9;</code>
   *
   * @return Whether the platformDataSource field is set.
   */
  boolean hasPlatformDataSource();
  /**
   *
   *
   * <pre>
   * A data source from Google Workspace.
   * </pre>
   *
   * <code>.google.apps.card.v1.SelectionInput.PlatformDataSource platform_data_source = 9;</code>
   *
   * @return The platformDataSource.
   */
  com.google.apps.card.v1.SelectionInput.PlatformDataSource getPlatformDataSource();
  /**
   *
   *
   * <pre>
   * A data source from Google Workspace.
   * </pre>
   *
   * <code>.google.apps.card.v1.SelectionInput.PlatformDataSource platform_data_source = 9;</code>
   */
  com.google.apps.card.v1.SelectionInput.PlatformDataSourceOrBuilder
      getPlatformDataSourceOrBuilder();

  com.google.apps.card.v1.SelectionInput.MultiSelectDataSourceCase getMultiSelectDataSourceCase();
}
