/*
 * Copyright 2024 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/aiplatform/v1beta1/tool.proto

// Protobuf Java Version: 3.25.3
package com.google.cloud.aiplatform.v1beta1;

/**
 *
 *
 * <pre>
 * Tool details that the model may use to generate response.
 *
 * A `Tool` is a piece of code that enables the system to interact with
 * external systems to perform an action, or set of actions, outside of
 * knowledge and scope of the model. A Tool object should contain exactly
 * one type of Tool (e.g FunctionDeclaration, Retrieval or
 * GoogleSearchRetrieval).
 * </pre>
 *
 * Protobuf type {@code google.cloud.aiplatform.v1beta1.Tool}
 */
public final class Tool extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.aiplatform.v1beta1.Tool)
    ToolOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use Tool.newBuilder() to construct.
  private Tool(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private Tool() {
    functionDeclarations_ = java.util.Collections.emptyList();
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new Tool();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.aiplatform.v1beta1.ToolProto
        .internal_static_google_cloud_aiplatform_v1beta1_Tool_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.aiplatform.v1beta1.ToolProto
        .internal_static_google_cloud_aiplatform_v1beta1_Tool_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.aiplatform.v1beta1.Tool.class,
            com.google.cloud.aiplatform.v1beta1.Tool.Builder.class);
  }

  private int bitField0_;
  public static final int FUNCTION_DECLARATIONS_FIELD_NUMBER = 1;

  @SuppressWarnings("serial")
  private java.util.List<com.google.cloud.aiplatform.v1beta1.FunctionDeclaration>
      functionDeclarations_;
  /**
   *
   *
   * <pre>
   * Optional. Function tool type.
   * One or more function declarations to be passed to the model along with the
   * current user query. Model may decide to call a subset of these functions
   * by populating [FunctionCall][content.part.function_call] in the response.
   * User should provide a [FunctionResponse][content.part.function_response]
   * for each function call in the next turn. Based on the function responses,
   * Model will generate the final response back to the user.
   * Maximum 64 function declarations can be provided.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.aiplatform.v1beta1.FunctionDeclaration function_declarations = 1 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  @java.lang.Override
  public java.util.List<com.google.cloud.aiplatform.v1beta1.FunctionDeclaration>
      getFunctionDeclarationsList() {
    return functionDeclarations_;
  }
  /**
   *
   *
   * <pre>
   * Optional. Function tool type.
   * One or more function declarations to be passed to the model along with the
   * current user query. Model may decide to call a subset of these functions
   * by populating [FunctionCall][content.part.function_call] in the response.
   * User should provide a [FunctionResponse][content.part.function_response]
   * for each function call in the next turn. Based on the function responses,
   * Model will generate the final response back to the user.
   * Maximum 64 function declarations can be provided.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.aiplatform.v1beta1.FunctionDeclaration function_declarations = 1 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  @java.lang.Override
  public java.util.List<? extends com.google.cloud.aiplatform.v1beta1.FunctionDeclarationOrBuilder>
      getFunctionDeclarationsOrBuilderList() {
    return functionDeclarations_;
  }
  /**
   *
   *
   * <pre>
   * Optional. Function tool type.
   * One or more function declarations to be passed to the model along with the
   * current user query. Model may decide to call a subset of these functions
   * by populating [FunctionCall][content.part.function_call] in the response.
   * User should provide a [FunctionResponse][content.part.function_response]
   * for each function call in the next turn. Based on the function responses,
   * Model will generate the final response back to the user.
   * Maximum 64 function declarations can be provided.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.aiplatform.v1beta1.FunctionDeclaration function_declarations = 1 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  @java.lang.Override
  public int getFunctionDeclarationsCount() {
    return functionDeclarations_.size();
  }
  /**
   *
   *
   * <pre>
   * Optional. Function tool type.
   * One or more function declarations to be passed to the model along with the
   * current user query. Model may decide to call a subset of these functions
   * by populating [FunctionCall][content.part.function_call] in the response.
   * User should provide a [FunctionResponse][content.part.function_response]
   * for each function call in the next turn. Based on the function responses,
   * Model will generate the final response back to the user.
   * Maximum 64 function declarations can be provided.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.aiplatform.v1beta1.FunctionDeclaration function_declarations = 1 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.aiplatform.v1beta1.FunctionDeclaration getFunctionDeclarations(
      int index) {
    return functionDeclarations_.get(index);
  }
  /**
   *
   *
   * <pre>
   * Optional. Function tool type.
   * One or more function declarations to be passed to the model along with the
   * current user query. Model may decide to call a subset of these functions
   * by populating [FunctionCall][content.part.function_call] in the response.
   * User should provide a [FunctionResponse][content.part.function_response]
   * for each function call in the next turn. Based on the function responses,
   * Model will generate the final response back to the user.
   * Maximum 64 function declarations can be provided.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.aiplatform.v1beta1.FunctionDeclaration function_declarations = 1 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.aiplatform.v1beta1.FunctionDeclarationOrBuilder
      getFunctionDeclarationsOrBuilder(int index) {
    return functionDeclarations_.get(index);
  }

  public static final int RETRIEVAL_FIELD_NUMBER = 2;
  private com.google.cloud.aiplatform.v1beta1.Retrieval retrieval_;
  /**
   *
   *
   * <pre>
   * Optional. Retrieval tool type.
   * System will always execute the provided retrieval tool(s) to get external
   * knowledge to answer the prompt. Retrieval results are presented to the
   * model for generation.
   * </pre>
   *
   * <code>
   * .google.cloud.aiplatform.v1beta1.Retrieval retrieval = 2 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return Whether the retrieval field is set.
   */
  @java.lang.Override
  public boolean hasRetrieval() {
    return ((bitField0_ & 0x00000001) != 0);
  }
  /**
   *
   *
   * <pre>
   * Optional. Retrieval tool type.
   * System will always execute the provided retrieval tool(s) to get external
   * knowledge to answer the prompt. Retrieval results are presented to the
   * model for generation.
   * </pre>
   *
   * <code>
   * .google.cloud.aiplatform.v1beta1.Retrieval retrieval = 2 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return The retrieval.
   */
  @java.lang.Override
  public com.google.cloud.aiplatform.v1beta1.Retrieval getRetrieval() {
    return retrieval_ == null
        ? com.google.cloud.aiplatform.v1beta1.Retrieval.getDefaultInstance()
        : retrieval_;
  }
  /**
   *
   *
   * <pre>
   * Optional. Retrieval tool type.
   * System will always execute the provided retrieval tool(s) to get external
   * knowledge to answer the prompt. Retrieval results are presented to the
   * model for generation.
   * </pre>
   *
   * <code>
   * .google.cloud.aiplatform.v1beta1.Retrieval retrieval = 2 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.aiplatform.v1beta1.RetrievalOrBuilder getRetrievalOrBuilder() {
    return retrieval_ == null
        ? com.google.cloud.aiplatform.v1beta1.Retrieval.getDefaultInstance()
        : retrieval_;
  }

  public static final int GOOGLE_SEARCH_RETRIEVAL_FIELD_NUMBER = 3;
  private com.google.cloud.aiplatform.v1beta1.GoogleSearchRetrieval googleSearchRetrieval_;
  /**
   *
   *
   * <pre>
   * Optional. GoogleSearchRetrieval tool type.
   * Specialized retrieval tool that is powered by Google search.
   * </pre>
   *
   * <code>
   * .google.cloud.aiplatform.v1beta1.GoogleSearchRetrieval google_search_retrieval = 3 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return Whether the googleSearchRetrieval field is set.
   */
  @java.lang.Override
  public boolean hasGoogleSearchRetrieval() {
    return ((bitField0_ & 0x00000002) != 0);
  }
  /**
   *
   *
   * <pre>
   * Optional. GoogleSearchRetrieval tool type.
   * Specialized retrieval tool that is powered by Google search.
   * </pre>
   *
   * <code>
   * .google.cloud.aiplatform.v1beta1.GoogleSearchRetrieval google_search_retrieval = 3 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return The googleSearchRetrieval.
   */
  @java.lang.Override
  public com.google.cloud.aiplatform.v1beta1.GoogleSearchRetrieval getGoogleSearchRetrieval() {
    return googleSearchRetrieval_ == null
        ? com.google.cloud.aiplatform.v1beta1.GoogleSearchRetrieval.getDefaultInstance()
        : googleSearchRetrieval_;
  }
  /**
   *
   *
   * <pre>
   * Optional. GoogleSearchRetrieval tool type.
   * Specialized retrieval tool that is powered by Google search.
   * </pre>
   *
   * <code>
   * .google.cloud.aiplatform.v1beta1.GoogleSearchRetrieval google_search_retrieval = 3 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.aiplatform.v1beta1.GoogleSearchRetrievalOrBuilder
      getGoogleSearchRetrievalOrBuilder() {
    return googleSearchRetrieval_ == null
        ? com.google.cloud.aiplatform.v1beta1.GoogleSearchRetrieval.getDefaultInstance()
        : googleSearchRetrieval_;
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    for (int i = 0; i < functionDeclarations_.size(); i++) {
      output.writeMessage(1, functionDeclarations_.get(i));
    }
    if (((bitField0_ & 0x00000001) != 0)) {
      output.writeMessage(2, getRetrieval());
    }
    if (((bitField0_ & 0x00000002) != 0)) {
      output.writeMessage(3, getGoogleSearchRetrieval());
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    for (int i = 0; i < functionDeclarations_.size(); i++) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(1, functionDeclarations_.get(i));
    }
    if (((bitField0_ & 0x00000001) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(2, getRetrieval());
    }
    if (((bitField0_ & 0x00000002) != 0)) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(3, getGoogleSearchRetrieval());
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.aiplatform.v1beta1.Tool)) {
      return super.equals(obj);
    }
    com.google.cloud.aiplatform.v1beta1.Tool other = (com.google.cloud.aiplatform.v1beta1.Tool) obj;

    if (!getFunctionDeclarationsList().equals(other.getFunctionDeclarationsList())) return false;
    if (hasRetrieval() != other.hasRetrieval()) return false;
    if (hasRetrieval()) {
      if (!getRetrieval().equals(other.getRetrieval())) return false;
    }
    if (hasGoogleSearchRetrieval() != other.hasGoogleSearchRetrieval()) return false;
    if (hasGoogleSearchRetrieval()) {
      if (!getGoogleSearchRetrieval().equals(other.getGoogleSearchRetrieval())) return false;
    }
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    if (getFunctionDeclarationsCount() > 0) {
      hash = (37 * hash) + FUNCTION_DECLARATIONS_FIELD_NUMBER;
      hash = (53 * hash) + getFunctionDeclarationsList().hashCode();
    }
    if (hasRetrieval()) {
      hash = (37 * hash) + RETRIEVAL_FIELD_NUMBER;
      hash = (53 * hash) + getRetrieval().hashCode();
    }
    if (hasGoogleSearchRetrieval()) {
      hash = (37 * hash) + GOOGLE_SEARCH_RETRIEVAL_FIELD_NUMBER;
      hash = (53 * hash) + getGoogleSearchRetrieval().hashCode();
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.aiplatform.v1beta1.Tool parseFrom(java.nio.ByteBuffer data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.aiplatform.v1beta1.Tool parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.aiplatform.v1beta1.Tool parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.aiplatform.v1beta1.Tool parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.aiplatform.v1beta1.Tool parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.aiplatform.v1beta1.Tool parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.aiplatform.v1beta1.Tool parseFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.aiplatform.v1beta1.Tool parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.aiplatform.v1beta1.Tool parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.aiplatform.v1beta1.Tool parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.aiplatform.v1beta1.Tool parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.aiplatform.v1beta1.Tool parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.cloud.aiplatform.v1beta1.Tool prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * Tool details that the model may use to generate response.
   *
   * A `Tool` is a piece of code that enables the system to interact with
   * external systems to perform an action, or set of actions, outside of
   * knowledge and scope of the model. A Tool object should contain exactly
   * one type of Tool (e.g FunctionDeclaration, Retrieval or
   * GoogleSearchRetrieval).
   * </pre>
   *
   * Protobuf type {@code google.cloud.aiplatform.v1beta1.Tool}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.aiplatform.v1beta1.Tool)
      com.google.cloud.aiplatform.v1beta1.ToolOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.aiplatform.v1beta1.ToolProto
          .internal_static_google_cloud_aiplatform_v1beta1_Tool_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.aiplatform.v1beta1.ToolProto
          .internal_static_google_cloud_aiplatform_v1beta1_Tool_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.aiplatform.v1beta1.Tool.class,
              com.google.cloud.aiplatform.v1beta1.Tool.Builder.class);
    }

    // Construct using com.google.cloud.aiplatform.v1beta1.Tool.newBuilder()
    private Builder() {
      maybeForceBuilderInitialization();
    }

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
      maybeForceBuilderInitialization();
    }

    private void maybeForceBuilderInitialization() {
      if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {
        getFunctionDeclarationsFieldBuilder();
        getRetrievalFieldBuilder();
        getGoogleSearchRetrievalFieldBuilder();
      }
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      if (functionDeclarationsBuilder_ == null) {
        functionDeclarations_ = java.util.Collections.emptyList();
      } else {
        functionDeclarations_ = null;
        functionDeclarationsBuilder_.clear();
      }
      bitField0_ = (bitField0_ & ~0x00000001);
      retrieval_ = null;
      if (retrievalBuilder_ != null) {
        retrievalBuilder_.dispose();
        retrievalBuilder_ = null;
      }
      googleSearchRetrieval_ = null;
      if (googleSearchRetrievalBuilder_ != null) {
        googleSearchRetrievalBuilder_.dispose();
        googleSearchRetrievalBuilder_ = null;
      }
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.aiplatform.v1beta1.ToolProto
          .internal_static_google_cloud_aiplatform_v1beta1_Tool_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.aiplatform.v1beta1.Tool getDefaultInstanceForType() {
      return com.google.cloud.aiplatform.v1beta1.Tool.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.aiplatform.v1beta1.Tool build() {
      com.google.cloud.aiplatform.v1beta1.Tool result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.aiplatform.v1beta1.Tool buildPartial() {
      com.google.cloud.aiplatform.v1beta1.Tool result =
          new com.google.cloud.aiplatform.v1beta1.Tool(this);
      buildPartialRepeatedFields(result);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      onBuilt();
      return result;
    }

    private void buildPartialRepeatedFields(com.google.cloud.aiplatform.v1beta1.Tool result) {
      if (functionDeclarationsBuilder_ == null) {
        if (((bitField0_ & 0x00000001) != 0)) {
          functionDeclarations_ = java.util.Collections.unmodifiableList(functionDeclarations_);
          bitField0_ = (bitField0_ & ~0x00000001);
        }
        result.functionDeclarations_ = functionDeclarations_;
      } else {
        result.functionDeclarations_ = functionDeclarationsBuilder_.build();
      }
    }

    private void buildPartial0(com.google.cloud.aiplatform.v1beta1.Tool result) {
      int from_bitField0_ = bitField0_;
      int to_bitField0_ = 0;
      if (((from_bitField0_ & 0x00000002) != 0)) {
        result.retrieval_ = retrievalBuilder_ == null ? retrieval_ : retrievalBuilder_.build();
        to_bitField0_ |= 0x00000001;
      }
      if (((from_bitField0_ & 0x00000004) != 0)) {
        result.googleSearchRetrieval_ =
            googleSearchRetrievalBuilder_ == null
                ? googleSearchRetrieval_
                : googleSearchRetrievalBuilder_.build();
        to_bitField0_ |= 0x00000002;
      }
      result.bitField0_ |= to_bitField0_;
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.aiplatform.v1beta1.Tool) {
        return mergeFrom((com.google.cloud.aiplatform.v1beta1.Tool) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.aiplatform.v1beta1.Tool other) {
      if (other == com.google.cloud.aiplatform.v1beta1.Tool.getDefaultInstance()) return this;
      if (functionDeclarationsBuilder_ == null) {
        if (!other.functionDeclarations_.isEmpty()) {
          if (functionDeclarations_.isEmpty()) {
            functionDeclarations_ = other.functionDeclarations_;
            bitField0_ = (bitField0_ & ~0x00000001);
          } else {
            ensureFunctionDeclarationsIsMutable();
            functionDeclarations_.addAll(other.functionDeclarations_);
          }
          onChanged();
        }
      } else {
        if (!other.functionDeclarations_.isEmpty()) {
          if (functionDeclarationsBuilder_.isEmpty()) {
            functionDeclarationsBuilder_.dispose();
            functionDeclarationsBuilder_ = null;
            functionDeclarations_ = other.functionDeclarations_;
            bitField0_ = (bitField0_ & ~0x00000001);
            functionDeclarationsBuilder_ =
                com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                    ? getFunctionDeclarationsFieldBuilder()
                    : null;
          } else {
            functionDeclarationsBuilder_.addAllMessages(other.functionDeclarations_);
          }
        }
      }
      if (other.hasRetrieval()) {
        mergeRetrieval(other.getRetrieval());
      }
      if (other.hasGoogleSearchRetrieval()) {
        mergeGoogleSearchRetrieval(other.getGoogleSearchRetrieval());
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                com.google.cloud.aiplatform.v1beta1.FunctionDeclaration m =
                    input.readMessage(
                        com.google.cloud.aiplatform.v1beta1.FunctionDeclaration.parser(),
                        extensionRegistry);
                if (functionDeclarationsBuilder_ == null) {
                  ensureFunctionDeclarationsIsMutable();
                  functionDeclarations_.add(m);
                } else {
                  functionDeclarationsBuilder_.addMessage(m);
                }
                break;
              } // case 10
            case 18:
              {
                input.readMessage(getRetrievalFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000002;
                break;
              } // case 18
            case 26:
              {
                input.readMessage(
                    getGoogleSearchRetrievalFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000004;
                break;
              } // case 26
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private java.util.List<com.google.cloud.aiplatform.v1beta1.FunctionDeclaration>
        functionDeclarations_ = java.util.Collections.emptyList();

    private void ensureFunctionDeclarationsIsMutable() {
      if (!((bitField0_ & 0x00000001) != 0)) {
        functionDeclarations_ =
            new java.util.ArrayList<com.google.cloud.aiplatform.v1beta1.FunctionDeclaration>(
                functionDeclarations_);
        bitField0_ |= 0x00000001;
      }
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.aiplatform.v1beta1.FunctionDeclaration,
            com.google.cloud.aiplatform.v1beta1.FunctionDeclaration.Builder,
            com.google.cloud.aiplatform.v1beta1.FunctionDeclarationOrBuilder>
        functionDeclarationsBuilder_;

    /**
     *
     *
     * <pre>
     * Optional. Function tool type.
     * One or more function declarations to be passed to the model along with the
     * current user query. Model may decide to call a subset of these functions
     * by populating [FunctionCall][content.part.function_call] in the response.
     * User should provide a [FunctionResponse][content.part.function_response]
     * for each function call in the next turn. Based on the function responses,
     * Model will generate the final response back to the user.
     * Maximum 64 function declarations can be provided.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1beta1.FunctionDeclaration function_declarations = 1 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public java.util.List<com.google.cloud.aiplatform.v1beta1.FunctionDeclaration>
        getFunctionDeclarationsList() {
      if (functionDeclarationsBuilder_ == null) {
        return java.util.Collections.unmodifiableList(functionDeclarations_);
      } else {
        return functionDeclarationsBuilder_.getMessageList();
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. Function tool type.
     * One or more function declarations to be passed to the model along with the
     * current user query. Model may decide to call a subset of these functions
     * by populating [FunctionCall][content.part.function_call] in the response.
     * User should provide a [FunctionResponse][content.part.function_response]
     * for each function call in the next turn. Based on the function responses,
     * Model will generate the final response back to the user.
     * Maximum 64 function declarations can be provided.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1beta1.FunctionDeclaration function_declarations = 1 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public int getFunctionDeclarationsCount() {
      if (functionDeclarationsBuilder_ == null) {
        return functionDeclarations_.size();
      } else {
        return functionDeclarationsBuilder_.getCount();
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. Function tool type.
     * One or more function declarations to be passed to the model along with the
     * current user query. Model may decide to call a subset of these functions
     * by populating [FunctionCall][content.part.function_call] in the response.
     * User should provide a [FunctionResponse][content.part.function_response]
     * for each function call in the next turn. Based on the function responses,
     * Model will generate the final response back to the user.
     * Maximum 64 function declarations can be provided.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1beta1.FunctionDeclaration function_declarations = 1 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.cloud.aiplatform.v1beta1.FunctionDeclaration getFunctionDeclarations(
        int index) {
      if (functionDeclarationsBuilder_ == null) {
        return functionDeclarations_.get(index);
      } else {
        return functionDeclarationsBuilder_.getMessage(index);
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. Function tool type.
     * One or more function declarations to be passed to the model along with the
     * current user query. Model may decide to call a subset of these functions
     * by populating [FunctionCall][content.part.function_call] in the response.
     * User should provide a [FunctionResponse][content.part.function_response]
     * for each function call in the next turn. Based on the function responses,
     * Model will generate the final response back to the user.
     * Maximum 64 function declarations can be provided.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1beta1.FunctionDeclaration function_declarations = 1 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder setFunctionDeclarations(
        int index, com.google.cloud.aiplatform.v1beta1.FunctionDeclaration value) {
      if (functionDeclarationsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureFunctionDeclarationsIsMutable();
        functionDeclarations_.set(index, value);
        onChanged();
      } else {
        functionDeclarationsBuilder_.setMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Function tool type.
     * One or more function declarations to be passed to the model along with the
     * current user query. Model may decide to call a subset of these functions
     * by populating [FunctionCall][content.part.function_call] in the response.
     * User should provide a [FunctionResponse][content.part.function_response]
     * for each function call in the next turn. Based on the function responses,
     * Model will generate the final response back to the user.
     * Maximum 64 function declarations can be provided.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1beta1.FunctionDeclaration function_declarations = 1 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder setFunctionDeclarations(
        int index,
        com.google.cloud.aiplatform.v1beta1.FunctionDeclaration.Builder builderForValue) {
      if (functionDeclarationsBuilder_ == null) {
        ensureFunctionDeclarationsIsMutable();
        functionDeclarations_.set(index, builderForValue.build());
        onChanged();
      } else {
        functionDeclarationsBuilder_.setMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Function tool type.
     * One or more function declarations to be passed to the model along with the
     * current user query. Model may decide to call a subset of these functions
     * by populating [FunctionCall][content.part.function_call] in the response.
     * User should provide a [FunctionResponse][content.part.function_response]
     * for each function call in the next turn. Based on the function responses,
     * Model will generate the final response back to the user.
     * Maximum 64 function declarations can be provided.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1beta1.FunctionDeclaration function_declarations = 1 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder addFunctionDeclarations(
        com.google.cloud.aiplatform.v1beta1.FunctionDeclaration value) {
      if (functionDeclarationsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureFunctionDeclarationsIsMutable();
        functionDeclarations_.add(value);
        onChanged();
      } else {
        functionDeclarationsBuilder_.addMessage(value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Function tool type.
     * One or more function declarations to be passed to the model along with the
     * current user query. Model may decide to call a subset of these functions
     * by populating [FunctionCall][content.part.function_call] in the response.
     * User should provide a [FunctionResponse][content.part.function_response]
     * for each function call in the next turn. Based on the function responses,
     * Model will generate the final response back to the user.
     * Maximum 64 function declarations can be provided.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1beta1.FunctionDeclaration function_declarations = 1 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder addFunctionDeclarations(
        int index, com.google.cloud.aiplatform.v1beta1.FunctionDeclaration value) {
      if (functionDeclarationsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureFunctionDeclarationsIsMutable();
        functionDeclarations_.add(index, value);
        onChanged();
      } else {
        functionDeclarationsBuilder_.addMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Function tool type.
     * One or more function declarations to be passed to the model along with the
     * current user query. Model may decide to call a subset of these functions
     * by populating [FunctionCall][content.part.function_call] in the response.
     * User should provide a [FunctionResponse][content.part.function_response]
     * for each function call in the next turn. Based on the function responses,
     * Model will generate the final response back to the user.
     * Maximum 64 function declarations can be provided.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1beta1.FunctionDeclaration function_declarations = 1 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder addFunctionDeclarations(
        com.google.cloud.aiplatform.v1beta1.FunctionDeclaration.Builder builderForValue) {
      if (functionDeclarationsBuilder_ == null) {
        ensureFunctionDeclarationsIsMutable();
        functionDeclarations_.add(builderForValue.build());
        onChanged();
      } else {
        functionDeclarationsBuilder_.addMessage(builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Function tool type.
     * One or more function declarations to be passed to the model along with the
     * current user query. Model may decide to call a subset of these functions
     * by populating [FunctionCall][content.part.function_call] in the response.
     * User should provide a [FunctionResponse][content.part.function_response]
     * for each function call in the next turn. Based on the function responses,
     * Model will generate the final response back to the user.
     * Maximum 64 function declarations can be provided.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1beta1.FunctionDeclaration function_declarations = 1 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder addFunctionDeclarations(
        int index,
        com.google.cloud.aiplatform.v1beta1.FunctionDeclaration.Builder builderForValue) {
      if (functionDeclarationsBuilder_ == null) {
        ensureFunctionDeclarationsIsMutable();
        functionDeclarations_.add(index, builderForValue.build());
        onChanged();
      } else {
        functionDeclarationsBuilder_.addMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Function tool type.
     * One or more function declarations to be passed to the model along with the
     * current user query. Model may decide to call a subset of these functions
     * by populating [FunctionCall][content.part.function_call] in the response.
     * User should provide a [FunctionResponse][content.part.function_response]
     * for each function call in the next turn. Based on the function responses,
     * Model will generate the final response back to the user.
     * Maximum 64 function declarations can be provided.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1beta1.FunctionDeclaration function_declarations = 1 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder addAllFunctionDeclarations(
        java.lang.Iterable<? extends com.google.cloud.aiplatform.v1beta1.FunctionDeclaration>
            values) {
      if (functionDeclarationsBuilder_ == null) {
        ensureFunctionDeclarationsIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(values, functionDeclarations_);
        onChanged();
      } else {
        functionDeclarationsBuilder_.addAllMessages(values);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Function tool type.
     * One or more function declarations to be passed to the model along with the
     * current user query. Model may decide to call a subset of these functions
     * by populating [FunctionCall][content.part.function_call] in the response.
     * User should provide a [FunctionResponse][content.part.function_response]
     * for each function call in the next turn. Based on the function responses,
     * Model will generate the final response back to the user.
     * Maximum 64 function declarations can be provided.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1beta1.FunctionDeclaration function_declarations = 1 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder clearFunctionDeclarations() {
      if (functionDeclarationsBuilder_ == null) {
        functionDeclarations_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00000001);
        onChanged();
      } else {
        functionDeclarationsBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Function tool type.
     * One or more function declarations to be passed to the model along with the
     * current user query. Model may decide to call a subset of these functions
     * by populating [FunctionCall][content.part.function_call] in the response.
     * User should provide a [FunctionResponse][content.part.function_response]
     * for each function call in the next turn. Based on the function responses,
     * Model will generate the final response back to the user.
     * Maximum 64 function declarations can be provided.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1beta1.FunctionDeclaration function_declarations = 1 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder removeFunctionDeclarations(int index) {
      if (functionDeclarationsBuilder_ == null) {
        ensureFunctionDeclarationsIsMutable();
        functionDeclarations_.remove(index);
        onChanged();
      } else {
        functionDeclarationsBuilder_.remove(index);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Function tool type.
     * One or more function declarations to be passed to the model along with the
     * current user query. Model may decide to call a subset of these functions
     * by populating [FunctionCall][content.part.function_call] in the response.
     * User should provide a [FunctionResponse][content.part.function_response]
     * for each function call in the next turn. Based on the function responses,
     * Model will generate the final response back to the user.
     * Maximum 64 function declarations can be provided.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1beta1.FunctionDeclaration function_declarations = 1 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.cloud.aiplatform.v1beta1.FunctionDeclaration.Builder
        getFunctionDeclarationsBuilder(int index) {
      return getFunctionDeclarationsFieldBuilder().getBuilder(index);
    }
    /**
     *
     *
     * <pre>
     * Optional. Function tool type.
     * One or more function declarations to be passed to the model along with the
     * current user query. Model may decide to call a subset of these functions
     * by populating [FunctionCall][content.part.function_call] in the response.
     * User should provide a [FunctionResponse][content.part.function_response]
     * for each function call in the next turn. Based on the function responses,
     * Model will generate the final response back to the user.
     * Maximum 64 function declarations can be provided.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1beta1.FunctionDeclaration function_declarations = 1 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.cloud.aiplatform.v1beta1.FunctionDeclarationOrBuilder
        getFunctionDeclarationsOrBuilder(int index) {
      if (functionDeclarationsBuilder_ == null) {
        return functionDeclarations_.get(index);
      } else {
        return functionDeclarationsBuilder_.getMessageOrBuilder(index);
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. Function tool type.
     * One or more function declarations to be passed to the model along with the
     * current user query. Model may decide to call a subset of these functions
     * by populating [FunctionCall][content.part.function_call] in the response.
     * User should provide a [FunctionResponse][content.part.function_response]
     * for each function call in the next turn. Based on the function responses,
     * Model will generate the final response back to the user.
     * Maximum 64 function declarations can be provided.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1beta1.FunctionDeclaration function_declarations = 1 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public java.util.List<
            ? extends com.google.cloud.aiplatform.v1beta1.FunctionDeclarationOrBuilder>
        getFunctionDeclarationsOrBuilderList() {
      if (functionDeclarationsBuilder_ != null) {
        return functionDeclarationsBuilder_.getMessageOrBuilderList();
      } else {
        return java.util.Collections.unmodifiableList(functionDeclarations_);
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. Function tool type.
     * One or more function declarations to be passed to the model along with the
     * current user query. Model may decide to call a subset of these functions
     * by populating [FunctionCall][content.part.function_call] in the response.
     * User should provide a [FunctionResponse][content.part.function_response]
     * for each function call in the next turn. Based on the function responses,
     * Model will generate the final response back to the user.
     * Maximum 64 function declarations can be provided.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1beta1.FunctionDeclaration function_declarations = 1 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.cloud.aiplatform.v1beta1.FunctionDeclaration.Builder
        addFunctionDeclarationsBuilder() {
      return getFunctionDeclarationsFieldBuilder()
          .addBuilder(com.google.cloud.aiplatform.v1beta1.FunctionDeclaration.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * Optional. Function tool type.
     * One or more function declarations to be passed to the model along with the
     * current user query. Model may decide to call a subset of these functions
     * by populating [FunctionCall][content.part.function_call] in the response.
     * User should provide a [FunctionResponse][content.part.function_response]
     * for each function call in the next turn. Based on the function responses,
     * Model will generate the final response back to the user.
     * Maximum 64 function declarations can be provided.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1beta1.FunctionDeclaration function_declarations = 1 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.cloud.aiplatform.v1beta1.FunctionDeclaration.Builder
        addFunctionDeclarationsBuilder(int index) {
      return getFunctionDeclarationsFieldBuilder()
          .addBuilder(
              index, com.google.cloud.aiplatform.v1beta1.FunctionDeclaration.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * Optional. Function tool type.
     * One or more function declarations to be passed to the model along with the
     * current user query. Model may decide to call a subset of these functions
     * by populating [FunctionCall][content.part.function_call] in the response.
     * User should provide a [FunctionResponse][content.part.function_response]
     * for each function call in the next turn. Based on the function responses,
     * Model will generate the final response back to the user.
     * Maximum 64 function declarations can be provided.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1beta1.FunctionDeclaration function_declarations = 1 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public java.util.List<com.google.cloud.aiplatform.v1beta1.FunctionDeclaration.Builder>
        getFunctionDeclarationsBuilderList() {
      return getFunctionDeclarationsFieldBuilder().getBuilderList();
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.aiplatform.v1beta1.FunctionDeclaration,
            com.google.cloud.aiplatform.v1beta1.FunctionDeclaration.Builder,
            com.google.cloud.aiplatform.v1beta1.FunctionDeclarationOrBuilder>
        getFunctionDeclarationsFieldBuilder() {
      if (functionDeclarationsBuilder_ == null) {
        functionDeclarationsBuilder_ =
            new com.google.protobuf.RepeatedFieldBuilderV3<
                com.google.cloud.aiplatform.v1beta1.FunctionDeclaration,
                com.google.cloud.aiplatform.v1beta1.FunctionDeclaration.Builder,
                com.google.cloud.aiplatform.v1beta1.FunctionDeclarationOrBuilder>(
                functionDeclarations_,
                ((bitField0_ & 0x00000001) != 0),
                getParentForChildren(),
                isClean());
        functionDeclarations_ = null;
      }
      return functionDeclarationsBuilder_;
    }

    private com.google.cloud.aiplatform.v1beta1.Retrieval retrieval_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.aiplatform.v1beta1.Retrieval,
            com.google.cloud.aiplatform.v1beta1.Retrieval.Builder,
            com.google.cloud.aiplatform.v1beta1.RetrievalOrBuilder>
        retrievalBuilder_;
    /**
     *
     *
     * <pre>
     * Optional. Retrieval tool type.
     * System will always execute the provided retrieval tool(s) to get external
     * knowledge to answer the prompt. Retrieval results are presented to the
     * model for generation.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.Retrieval retrieval = 2 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return Whether the retrieval field is set.
     */
    public boolean hasRetrieval() {
      return ((bitField0_ & 0x00000002) != 0);
    }
    /**
     *
     *
     * <pre>
     * Optional. Retrieval tool type.
     * System will always execute the provided retrieval tool(s) to get external
     * knowledge to answer the prompt. Retrieval results are presented to the
     * model for generation.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.Retrieval retrieval = 2 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return The retrieval.
     */
    public com.google.cloud.aiplatform.v1beta1.Retrieval getRetrieval() {
      if (retrievalBuilder_ == null) {
        return retrieval_ == null
            ? com.google.cloud.aiplatform.v1beta1.Retrieval.getDefaultInstance()
            : retrieval_;
      } else {
        return retrievalBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. Retrieval tool type.
     * System will always execute the provided retrieval tool(s) to get external
     * knowledge to answer the prompt. Retrieval results are presented to the
     * model for generation.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.Retrieval retrieval = 2 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder setRetrieval(com.google.cloud.aiplatform.v1beta1.Retrieval value) {
      if (retrievalBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        retrieval_ = value;
      } else {
        retrievalBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Retrieval tool type.
     * System will always execute the provided retrieval tool(s) to get external
     * knowledge to answer the prompt. Retrieval results are presented to the
     * model for generation.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.Retrieval retrieval = 2 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder setRetrieval(
        com.google.cloud.aiplatform.v1beta1.Retrieval.Builder builderForValue) {
      if (retrievalBuilder_ == null) {
        retrieval_ = builderForValue.build();
      } else {
        retrievalBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Retrieval tool type.
     * System will always execute the provided retrieval tool(s) to get external
     * knowledge to answer the prompt. Retrieval results are presented to the
     * model for generation.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.Retrieval retrieval = 2 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder mergeRetrieval(com.google.cloud.aiplatform.v1beta1.Retrieval value) {
      if (retrievalBuilder_ == null) {
        if (((bitField0_ & 0x00000002) != 0)
            && retrieval_ != null
            && retrieval_ != com.google.cloud.aiplatform.v1beta1.Retrieval.getDefaultInstance()) {
          getRetrievalBuilder().mergeFrom(value);
        } else {
          retrieval_ = value;
        }
      } else {
        retrievalBuilder_.mergeFrom(value);
      }
      if (retrieval_ != null) {
        bitField0_ |= 0x00000002;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Retrieval tool type.
     * System will always execute the provided retrieval tool(s) to get external
     * knowledge to answer the prompt. Retrieval results are presented to the
     * model for generation.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.Retrieval retrieval = 2 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder clearRetrieval() {
      bitField0_ = (bitField0_ & ~0x00000002);
      retrieval_ = null;
      if (retrievalBuilder_ != null) {
        retrievalBuilder_.dispose();
        retrievalBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Retrieval tool type.
     * System will always execute the provided retrieval tool(s) to get external
     * knowledge to answer the prompt. Retrieval results are presented to the
     * model for generation.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.Retrieval retrieval = 2 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.cloud.aiplatform.v1beta1.Retrieval.Builder getRetrievalBuilder() {
      bitField0_ |= 0x00000002;
      onChanged();
      return getRetrievalFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Optional. Retrieval tool type.
     * System will always execute the provided retrieval tool(s) to get external
     * knowledge to answer the prompt. Retrieval results are presented to the
     * model for generation.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.Retrieval retrieval = 2 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.cloud.aiplatform.v1beta1.RetrievalOrBuilder getRetrievalOrBuilder() {
      if (retrievalBuilder_ != null) {
        return retrievalBuilder_.getMessageOrBuilder();
      } else {
        return retrieval_ == null
            ? com.google.cloud.aiplatform.v1beta1.Retrieval.getDefaultInstance()
            : retrieval_;
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. Retrieval tool type.
     * System will always execute the provided retrieval tool(s) to get external
     * knowledge to answer the prompt. Retrieval results are presented to the
     * model for generation.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.Retrieval retrieval = 2 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.aiplatform.v1beta1.Retrieval,
            com.google.cloud.aiplatform.v1beta1.Retrieval.Builder,
            com.google.cloud.aiplatform.v1beta1.RetrievalOrBuilder>
        getRetrievalFieldBuilder() {
      if (retrievalBuilder_ == null) {
        retrievalBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.aiplatform.v1beta1.Retrieval,
                com.google.cloud.aiplatform.v1beta1.Retrieval.Builder,
                com.google.cloud.aiplatform.v1beta1.RetrievalOrBuilder>(
                getRetrieval(), getParentForChildren(), isClean());
        retrieval_ = null;
      }
      return retrievalBuilder_;
    }

    private com.google.cloud.aiplatform.v1beta1.GoogleSearchRetrieval googleSearchRetrieval_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.aiplatform.v1beta1.GoogleSearchRetrieval,
            com.google.cloud.aiplatform.v1beta1.GoogleSearchRetrieval.Builder,
            com.google.cloud.aiplatform.v1beta1.GoogleSearchRetrievalOrBuilder>
        googleSearchRetrievalBuilder_;
    /**
     *
     *
     * <pre>
     * Optional. GoogleSearchRetrieval tool type.
     * Specialized retrieval tool that is powered by Google search.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.GoogleSearchRetrieval google_search_retrieval = 3 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return Whether the googleSearchRetrieval field is set.
     */
    public boolean hasGoogleSearchRetrieval() {
      return ((bitField0_ & 0x00000004) != 0);
    }
    /**
     *
     *
     * <pre>
     * Optional. GoogleSearchRetrieval tool type.
     * Specialized retrieval tool that is powered by Google search.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.GoogleSearchRetrieval google_search_retrieval = 3 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return The googleSearchRetrieval.
     */
    public com.google.cloud.aiplatform.v1beta1.GoogleSearchRetrieval getGoogleSearchRetrieval() {
      if (googleSearchRetrievalBuilder_ == null) {
        return googleSearchRetrieval_ == null
            ? com.google.cloud.aiplatform.v1beta1.GoogleSearchRetrieval.getDefaultInstance()
            : googleSearchRetrieval_;
      } else {
        return googleSearchRetrievalBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. GoogleSearchRetrieval tool type.
     * Specialized retrieval tool that is powered by Google search.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.GoogleSearchRetrieval google_search_retrieval = 3 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder setGoogleSearchRetrieval(
        com.google.cloud.aiplatform.v1beta1.GoogleSearchRetrieval value) {
      if (googleSearchRetrievalBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        googleSearchRetrieval_ = value;
      } else {
        googleSearchRetrievalBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. GoogleSearchRetrieval tool type.
     * Specialized retrieval tool that is powered by Google search.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.GoogleSearchRetrieval google_search_retrieval = 3 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder setGoogleSearchRetrieval(
        com.google.cloud.aiplatform.v1beta1.GoogleSearchRetrieval.Builder builderForValue) {
      if (googleSearchRetrievalBuilder_ == null) {
        googleSearchRetrieval_ = builderForValue.build();
      } else {
        googleSearchRetrievalBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. GoogleSearchRetrieval tool type.
     * Specialized retrieval tool that is powered by Google search.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.GoogleSearchRetrieval google_search_retrieval = 3 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder mergeGoogleSearchRetrieval(
        com.google.cloud.aiplatform.v1beta1.GoogleSearchRetrieval value) {
      if (googleSearchRetrievalBuilder_ == null) {
        if (((bitField0_ & 0x00000004) != 0)
            && googleSearchRetrieval_ != null
            && googleSearchRetrieval_
                != com.google.cloud.aiplatform.v1beta1.GoogleSearchRetrieval.getDefaultInstance()) {
          getGoogleSearchRetrievalBuilder().mergeFrom(value);
        } else {
          googleSearchRetrieval_ = value;
        }
      } else {
        googleSearchRetrievalBuilder_.mergeFrom(value);
      }
      if (googleSearchRetrieval_ != null) {
        bitField0_ |= 0x00000004;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. GoogleSearchRetrieval tool type.
     * Specialized retrieval tool that is powered by Google search.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.GoogleSearchRetrieval google_search_retrieval = 3 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder clearGoogleSearchRetrieval() {
      bitField0_ = (bitField0_ & ~0x00000004);
      googleSearchRetrieval_ = null;
      if (googleSearchRetrievalBuilder_ != null) {
        googleSearchRetrievalBuilder_.dispose();
        googleSearchRetrievalBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. GoogleSearchRetrieval tool type.
     * Specialized retrieval tool that is powered by Google search.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.GoogleSearchRetrieval google_search_retrieval = 3 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.cloud.aiplatform.v1beta1.GoogleSearchRetrieval.Builder
        getGoogleSearchRetrievalBuilder() {
      bitField0_ |= 0x00000004;
      onChanged();
      return getGoogleSearchRetrievalFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Optional. GoogleSearchRetrieval tool type.
     * Specialized retrieval tool that is powered by Google search.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.GoogleSearchRetrieval google_search_retrieval = 3 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.cloud.aiplatform.v1beta1.GoogleSearchRetrievalOrBuilder
        getGoogleSearchRetrievalOrBuilder() {
      if (googleSearchRetrievalBuilder_ != null) {
        return googleSearchRetrievalBuilder_.getMessageOrBuilder();
      } else {
        return googleSearchRetrieval_ == null
            ? com.google.cloud.aiplatform.v1beta1.GoogleSearchRetrieval.getDefaultInstance()
            : googleSearchRetrieval_;
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. GoogleSearchRetrieval tool type.
     * Specialized retrieval tool that is powered by Google search.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.GoogleSearchRetrieval google_search_retrieval = 3 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.aiplatform.v1beta1.GoogleSearchRetrieval,
            com.google.cloud.aiplatform.v1beta1.GoogleSearchRetrieval.Builder,
            com.google.cloud.aiplatform.v1beta1.GoogleSearchRetrievalOrBuilder>
        getGoogleSearchRetrievalFieldBuilder() {
      if (googleSearchRetrievalBuilder_ == null) {
        googleSearchRetrievalBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.aiplatform.v1beta1.GoogleSearchRetrieval,
                com.google.cloud.aiplatform.v1beta1.GoogleSearchRetrieval.Builder,
                com.google.cloud.aiplatform.v1beta1.GoogleSearchRetrievalOrBuilder>(
                getGoogleSearchRetrieval(), getParentForChildren(), isClean());
        googleSearchRetrieval_ = null;
      }
      return googleSearchRetrievalBuilder_;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.aiplatform.v1beta1.Tool)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.aiplatform.v1beta1.Tool)
  private static final com.google.cloud.aiplatform.v1beta1.Tool DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.aiplatform.v1beta1.Tool();
  }

  public static com.google.cloud.aiplatform.v1beta1.Tool getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<Tool> PARSER =
      new com.google.protobuf.AbstractParser<Tool>() {
        @java.lang.Override
        public Tool parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<Tool> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<Tool> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.aiplatform.v1beta1.Tool getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
