/*
 * Decompiled with CFR 0.152.
 */
package com.google.longrunning;

import com.google.api.core.ApiFuture;
import com.google.api.core.BetaApi;
import com.google.api.gax.core.CredentialsProvider;
import com.google.api.gax.core.GoogleCredentialsProvider;
import com.google.api.gax.core.PropertiesProvider;
import com.google.api.gax.grpc.CallContext;
import com.google.api.gax.grpc.ChannelProvider;
import com.google.api.gax.grpc.ClientSettings;
import com.google.api.gax.grpc.ExecutorProvider;
import com.google.api.gax.grpc.InstantiatingChannelProvider;
import com.google.api.gax.grpc.InstantiatingExecutorProvider;
import com.google.api.gax.grpc.PageContext;
import com.google.api.gax.grpc.PagedCallSettings;
import com.google.api.gax.grpc.PagedListDescriptor;
import com.google.api.gax.grpc.PagedListResponseFactory;
import com.google.api.gax.grpc.SimpleCallSettings;
import com.google.api.gax.grpc.UnaryCallSettings;
import com.google.api.gax.grpc.UnaryCallable;
import com.google.api.gax.retrying.RetrySettings;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.google.longrunning.CancelOperationRequest;
import com.google.longrunning.DeleteOperationRequest;
import com.google.longrunning.GetOperationRequest;
import com.google.longrunning.ListOperationsRequest;
import com.google.longrunning.ListOperationsResponse;
import com.google.longrunning.Operation;
import com.google.longrunning.PagedResponseWrappers;
import com.google.protobuf.Empty;
import com.google.protobuf.Message;
import io.grpc.MethodDescriptor;
import io.grpc.Status;
import io.grpc.protobuf.ProtoUtils;
import java.io.IOException;
import java.util.Set;
import org.threeten.bp.Duration;

@BetaApi
public class OperationsSettings
extends ClientSettings {
    private static final String DEFAULT_GAPIC_NAME = "gapic";
    private static final String DEFAULT_GAPIC_VERSION = "";
    private static final String PROPERTIES_FILE = "/com/google/longrunning/project.properties";
    private static final String META_VERSION_KEY = "artifact.version";
    private static String gapicVersion;
    private static final MethodDescriptor<GetOperationRequest, Operation> METHOD_GET_OPERATION;
    private static final MethodDescriptor<ListOperationsRequest, ListOperationsResponse> METHOD_LIST_OPERATIONS;
    private static final MethodDescriptor<CancelOperationRequest, Empty> METHOD_CANCEL_OPERATION;
    private static final MethodDescriptor<DeleteOperationRequest, Empty> METHOD_DELETE_OPERATION;
    private final SimpleCallSettings<GetOperationRequest, Operation> getOperationSettings;
    private final PagedCallSettings<ListOperationsRequest, ListOperationsResponse, PagedResponseWrappers.ListOperationsPagedResponse> listOperationsSettings;
    private final SimpleCallSettings<CancelOperationRequest, Empty> cancelOperationSettings;
    private final SimpleCallSettings<DeleteOperationRequest, Empty> deleteOperationSettings;
    private static final PagedListDescriptor<ListOperationsRequest, ListOperationsResponse, Operation> LIST_OPERATIONS_PAGE_STR_DESC;
    private static final PagedListResponseFactory<ListOperationsRequest, ListOperationsResponse, PagedResponseWrappers.ListOperationsPagedResponse> LIST_OPERATIONS_PAGE_STR_FACT;

    public SimpleCallSettings<GetOperationRequest, Operation> getOperationSettings() {
        return this.getOperationSettings;
    }

    public PagedCallSettings<ListOperationsRequest, ListOperationsResponse, PagedResponseWrappers.ListOperationsPagedResponse> listOperationsSettings() {
        return this.listOperationsSettings;
    }

    public SimpleCallSettings<CancelOperationRequest, Empty> cancelOperationSettings() {
        return this.cancelOperationSettings;
    }

    public SimpleCallSettings<DeleteOperationRequest, Empty> deleteOperationSettings() {
        return this.deleteOperationSettings;
    }

    public static InstantiatingExecutorProvider.Builder defaultExecutorProviderBuilder() {
        return InstantiatingExecutorProvider.newBuilder();
    }

    public static GoogleCredentialsProvider.Builder defaultCredentialsProviderBuilder() {
        return GoogleCredentialsProvider.newBuilder();
    }

    public static InstantiatingChannelProvider.Builder defaultChannelProviderBuilder() {
        return InstantiatingChannelProvider.newBuilder().setGeneratorHeader(DEFAULT_GAPIC_NAME, OperationsSettings.getGapicVersion());
    }

    private static String getGapicVersion() {
        if (gapicVersion == null) {
            gapicVersion = PropertiesProvider.loadProperty(OperationsSettings.class, (String)PROPERTIES_FILE, (String)META_VERSION_KEY);
            gapicVersion = gapicVersion == null ? DEFAULT_GAPIC_VERSION : gapicVersion;
        }
        return gapicVersion;
    }

    public static Builder defaultBuilder() {
        return Builder.createDefault();
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    private OperationsSettings(Builder settingsBuilder) throws IOException {
        super(settingsBuilder.getExecutorProvider(), settingsBuilder.getChannelProvider(), settingsBuilder.getCredentialsProvider());
        this.getOperationSettings = settingsBuilder.getOperationSettings().build();
        this.listOperationsSettings = settingsBuilder.listOperationsSettings().build();
        this.cancelOperationSettings = settingsBuilder.cancelOperationSettings().build();
        this.deleteOperationSettings = settingsBuilder.deleteOperationSettings().build();
    }

    static {
        METHOD_GET_OPERATION = MethodDescriptor.create((MethodDescriptor.MethodType)MethodDescriptor.MethodType.UNARY, (String)"google.longrunning.Operations/GetOperation", (MethodDescriptor.Marshaller)ProtoUtils.marshaller((Message)GetOperationRequest.getDefaultInstance()), (MethodDescriptor.Marshaller)ProtoUtils.marshaller((Message)Operation.getDefaultInstance()));
        METHOD_LIST_OPERATIONS = MethodDescriptor.create((MethodDescriptor.MethodType)MethodDescriptor.MethodType.UNARY, (String)"google.longrunning.Operations/ListOperations", (MethodDescriptor.Marshaller)ProtoUtils.marshaller((Message)ListOperationsRequest.getDefaultInstance()), (MethodDescriptor.Marshaller)ProtoUtils.marshaller((Message)ListOperationsResponse.getDefaultInstance()));
        METHOD_CANCEL_OPERATION = MethodDescriptor.create((MethodDescriptor.MethodType)MethodDescriptor.MethodType.UNARY, (String)"google.longrunning.Operations/CancelOperation", (MethodDescriptor.Marshaller)ProtoUtils.marshaller((Message)CancelOperationRequest.getDefaultInstance()), (MethodDescriptor.Marshaller)ProtoUtils.marshaller((Message)Empty.getDefaultInstance()));
        METHOD_DELETE_OPERATION = MethodDescriptor.create((MethodDescriptor.MethodType)MethodDescriptor.MethodType.UNARY, (String)"google.longrunning.Operations/DeleteOperation", (MethodDescriptor.Marshaller)ProtoUtils.marshaller((Message)DeleteOperationRequest.getDefaultInstance()), (MethodDescriptor.Marshaller)ProtoUtils.marshaller((Message)Empty.getDefaultInstance()));
        LIST_OPERATIONS_PAGE_STR_DESC = new PagedListDescriptor<ListOperationsRequest, ListOperationsResponse, Operation>(){

            @Override
            public String emptyToken() {
                return OperationsSettings.DEFAULT_GAPIC_VERSION;
            }

            @Override
            public ListOperationsRequest injectToken(ListOperationsRequest payload, String token) {
                return ListOperationsRequest.newBuilder((ListOperationsRequest)payload).setPageToken(token).build();
            }

            @Override
            public ListOperationsRequest injectPageSize(ListOperationsRequest payload, int pageSize) {
                return ListOperationsRequest.newBuilder((ListOperationsRequest)payload).setPageSize(pageSize).build();
            }

            @Override
            public Integer extractPageSize(ListOperationsRequest payload) {
                return payload.getPageSize();
            }

            @Override
            public String extractNextToken(ListOperationsResponse payload) {
                return payload.getNextPageToken();
            }

            @Override
            public Iterable<Operation> extractResources(ListOperationsResponse payload) {
                return payload.getOperationsList();
            }
        };
        LIST_OPERATIONS_PAGE_STR_FACT = new PagedListResponseFactory<ListOperationsRequest, ListOperationsResponse, PagedResponseWrappers.ListOperationsPagedResponse>(){

            @Override
            public ApiFuture<PagedResponseWrappers.ListOperationsPagedResponse> getFuturePagedResponse(UnaryCallable<ListOperationsRequest, ListOperationsResponse> callable, ListOperationsRequest request, CallContext context, ApiFuture<ListOperationsResponse> futureResponse) {
                PageContext<ListOperationsRequest, ListOperationsResponse, Operation> pageContext = PageContext.create(callable, LIST_OPERATIONS_PAGE_STR_DESC, request, context);
                return PagedResponseWrappers.ListOperationsPagedResponse.createAsync(pageContext, futureResponse);
            }
        };
    }

    public static class Builder
    extends ClientSettings.Builder {
        private final ImmutableList<UnaryCallSettings.Builder> unaryMethodSettingsBuilders;
        private final SimpleCallSettings.Builder<GetOperationRequest, Operation> getOperationSettings;
        private final PagedCallSettings.Builder<ListOperationsRequest, ListOperationsResponse, PagedResponseWrappers.ListOperationsPagedResponse> listOperationsSettings;
        private final SimpleCallSettings.Builder<CancelOperationRequest, Empty> cancelOperationSettings;
        private final SimpleCallSettings.Builder<DeleteOperationRequest, Empty> deleteOperationSettings;
        private static final ImmutableMap<String, ImmutableSet<Status.Code>> RETRYABLE_CODE_DEFINITIONS;
        private static final ImmutableMap<String, RetrySettings.Builder> RETRY_PARAM_DEFINITIONS;

        private Builder() {
            super((InstantiatingChannelProvider)null);
            this.getOperationSettings = SimpleCallSettings.newBuilder(METHOD_GET_OPERATION);
            this.listOperationsSettings = PagedCallSettings.newBuilder(METHOD_LIST_OPERATIONS, LIST_OPERATIONS_PAGE_STR_FACT);
            this.cancelOperationSettings = SimpleCallSettings.newBuilder(METHOD_CANCEL_OPERATION);
            this.deleteOperationSettings = SimpleCallSettings.newBuilder(METHOD_DELETE_OPERATION);
            this.unaryMethodSettingsBuilders = ImmutableList.of(this.getOperationSettings, this.listOperationsSettings, this.cancelOperationSettings, this.deleteOperationSettings);
        }

        private static Builder createDefault() {
            Builder builder = new Builder();
            ((SimpleCallSettings.Builder)builder.getOperationSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"idempotent"))).setRetrySettingsBuilder((RetrySettings.Builder)RETRY_PARAM_DEFINITIONS.get((Object)"default"));
            ((PagedCallSettings.Builder)builder.listOperationsSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"idempotent"))).setRetrySettingsBuilder((RetrySettings.Builder)RETRY_PARAM_DEFINITIONS.get((Object)"default"));
            ((SimpleCallSettings.Builder)builder.cancelOperationSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"idempotent"))).setRetrySettingsBuilder((RetrySettings.Builder)RETRY_PARAM_DEFINITIONS.get((Object)"default"));
            ((SimpleCallSettings.Builder)builder.deleteOperationSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"idempotent"))).setRetrySettingsBuilder((RetrySettings.Builder)RETRY_PARAM_DEFINITIONS.get((Object)"default"));
            return builder;
        }

        private Builder(OperationsSettings settings) {
            super(settings);
            this.getOperationSettings = settings.getOperationSettings.toBuilder();
            this.listOperationsSettings = settings.listOperationsSettings.toBuilder();
            this.cancelOperationSettings = settings.cancelOperationSettings.toBuilder();
            this.deleteOperationSettings = settings.deleteOperationSettings.toBuilder();
            this.unaryMethodSettingsBuilders = ImmutableList.of(this.getOperationSettings, this.listOperationsSettings, this.cancelOperationSettings, this.deleteOperationSettings);
        }

        @Override
        public Builder setExecutorProvider(ExecutorProvider executorProvider) {
            super.setExecutorProvider(executorProvider);
            return this;
        }

        @Override
        public Builder setChannelProvider(ChannelProvider channelProvider) {
            super.setChannelProvider(channelProvider);
            return this;
        }

        @Override
        public Builder setCredentialsProvider(CredentialsProvider credentialsProvider) {
            super.setCredentialsProvider(credentialsProvider);
            return this;
        }

        public Builder applyToAllUnaryMethods(UnaryCallSettings.Builder unaryCallSettings) throws Exception {
            super.applyToAllUnaryMethods((Iterable<UnaryCallSettings.Builder>)this.unaryMethodSettingsBuilders, unaryCallSettings);
            return this;
        }

        public SimpleCallSettings.Builder<GetOperationRequest, Operation> getOperationSettings() {
            return this.getOperationSettings;
        }

        public PagedCallSettings.Builder<ListOperationsRequest, ListOperationsResponse, PagedResponseWrappers.ListOperationsPagedResponse> listOperationsSettings() {
            return this.listOperationsSettings;
        }

        public SimpleCallSettings.Builder<CancelOperationRequest, Empty> cancelOperationSettings() {
            return this.cancelOperationSettings;
        }

        public SimpleCallSettings.Builder<DeleteOperationRequest, Empty> deleteOperationSettings() {
            return this.deleteOperationSettings;
        }

        @Override
        public OperationsSettings build() throws IOException {
            return new OperationsSettings(this);
        }

        static {
            ImmutableMap.Builder definitions = ImmutableMap.builder();
            definitions.put((Object)"idempotent", (Object)Sets.immutableEnumSet((Iterable)Lists.newArrayList((Object[])new Status.Code[]{Status.Code.DEADLINE_EXCEEDED, Status.Code.UNAVAILABLE})));
            definitions.put((Object)"non_idempotent", (Object)Sets.immutableEnumSet((Iterable)Lists.newArrayList((Object[])new Status.Code[]{Status.Code.UNAVAILABLE})));
            RETRYABLE_CODE_DEFINITIONS = definitions.build();
            definitions = ImmutableMap.builder();
            RetrySettings.Builder settingsBuilder = null;
            settingsBuilder = RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)100L)).setRetryDelayMultiplier(1.3).setMaxRetryDelay(Duration.ofMillis((long)60000L)).setInitialRpcTimeout(Duration.ofMillis((long)20000L)).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ofMillis((long)20000L)).setTotalTimeout(Duration.ofMillis((long)600000L));
            definitions.put((Object)"default", (Object)settingsBuilder);
            RETRY_PARAM_DEFINITIONS = definitions.build();
        }
    }
}

