/*
 * Decompiled with CFR 0.152.
 */
package me.chanjar.weixin.open.api.impl;

import me.chanjar.weixin.common.bean.oauth2.WxOAuth2AccessToken;
import me.chanjar.weixin.common.error.WxErrorException;
import me.chanjar.weixin.common.service.WxOAuth2Service;
import me.chanjar.weixin.common.service.WxOAuth2ServiceDecorator;
import me.chanjar.weixin.common.util.http.URIUtil;
import me.chanjar.weixin.mp.config.WxMpConfigStorage;
import me.chanjar.weixin.open.api.WxOpenComponentService;
import org.apache.commons.lang3.StringUtils;

public class WxOpenMpOAuth2ServiceImpl
extends WxOAuth2ServiceDecorator {
    private final WxOpenComponentService wxOpenComponentService;
    private final WxMpConfigStorage wxMpConfigStorage;

    public WxOpenMpOAuth2ServiceImpl(WxOpenComponentService wxOpenComponentService, WxOAuth2Service wxOAuth2Service, WxMpConfigStorage wxMpConfigStorage) {
        super(wxOAuth2Service);
        this.wxOpenComponentService = wxOpenComponentService;
        this.wxMpConfigStorage = wxMpConfigStorage;
    }

    public WxOAuth2AccessToken getAccessToken(String code) throws WxErrorException {
        String url = String.format("https://api.weixin.qq.com/sns/oauth2/component/access_token?appid=%s&code=%s&grant_type=authorization_code&component_appid=%s", this.wxMpConfigStorage.getAppId(), code, this.wxOpenComponentService.getWxOpenConfigStorage().getComponentAppId());
        String responseContent = this.wxOpenComponentService.get(url);
        return WxOAuth2AccessToken.fromJson((String)responseContent);
    }

    public String buildAuthorizationUrl(String redirectUri, String scope, String state) {
        return String.format("https://open.weixin.qq.com/connect/oauth2/authorize?appid=%s&redirect_uri=%s&response_type=code&scope=%s&state=%s&component_appid=%s#wechat_redirect", this.wxMpConfigStorage.getAppId(), URIUtil.encodeURIComponent((String)redirectUri), scope, StringUtils.trimToEmpty((String)state), this.wxOpenComponentService.getWxOpenConfigStorage().getComponentAppId());
    }
}

