/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.module.jaxb;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.annotation.ObjectIdGenerators;
import com.fasterxml.jackson.core.Version;
import com.fasterxml.jackson.core.Versioned;
import com.fasterxml.jackson.databind.AnnotationIntrospector;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.cfg.MapperConfig;
import com.fasterxml.jackson.databind.introspect.Annotated;
import com.fasterxml.jackson.databind.introspect.AnnotatedClass;
import com.fasterxml.jackson.databind.introspect.AnnotatedField;
import com.fasterxml.jackson.databind.introspect.AnnotatedMember;
import com.fasterxml.jackson.databind.introspect.AnnotatedMethod;
import com.fasterxml.jackson.databind.introspect.AnnotatedParameter;
import com.fasterxml.jackson.databind.introspect.ObjectIdInfo;
import com.fasterxml.jackson.databind.introspect.VisibilityChecker;
import com.fasterxml.jackson.databind.jsontype.NamedType;
import com.fasterxml.jackson.databind.jsontype.TypeResolverBuilder;
import com.fasterxml.jackson.databind.jsontype.impl.StdTypeResolverBuilder;
import com.fasterxml.jackson.databind.type.TypeFactory;
import com.fasterxml.jackson.databind.util.BeanUtil;
import com.fasterxml.jackson.databind.util.ClassUtil;
import com.fasterxml.jackson.module.jaxb.ModuleVersion;
import com.fasterxml.jackson.module.jaxb.deser.XmlAdapterJsonDeserializer;
import com.fasterxml.jackson.module.jaxb.ser.XmlAdapterJsonSerializer;
import java.beans.Introspector;
import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Member;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.annotation.XmlAccessOrder;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorOrder;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlElementRef;
import javax.xml.bind.annotation.XmlElementRefs;
import javax.xml.bind.annotation.XmlElementWrapper;
import javax.xml.bind.annotation.XmlElements;
import javax.xml.bind.annotation.XmlEnumValue;
import javax.xml.bind.annotation.XmlID;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlTransient;
import javax.xml.bind.annotation.XmlType;
import javax.xml.bind.annotation.XmlValue;
import javax.xml.bind.annotation.adapters.XmlAdapter;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapters;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JaxbAnnotationIntrospector
extends AnnotationIntrospector
implements Versioned {
    protected static final String MARKER_FOR_DEFAULT = "##default";
    protected final String _jaxbPackageName;
    protected final JsonSerializer<?> _dataHandlerSerializer;
    protected final JsonDeserializer<?> _dataHandlerDeserializer;
    protected final TypeFactory _typeFactory;

    public JaxbAnnotationIntrospector() {
        this(TypeFactory.defaultInstance());
    }

    public JaxbAnnotationIntrospector(MapperConfig<?> config) {
        this(config.getTypeFactory());
    }

    public JaxbAnnotationIntrospector(TypeFactory typeFactory) {
        this._typeFactory = typeFactory == null ? TypeFactory.defaultInstance() : typeFactory;
        this._jaxbPackageName = XmlElement.class.getPackage().getName();
        JsonSerializer dataHandlerSerializer = null;
        JsonDeserializer dataHandlerDeserializer = null;
        try {
            dataHandlerSerializer = (JsonSerializer)Class.forName("com.fasterxml.jackson.module.jaxb.ser.DataHandlerJsonSerializer").newInstance();
            dataHandlerDeserializer = (JsonDeserializer)Class.forName("com.fasterxml.jackson.module.jaxb.deser.DataHandlerJsonDeserializer").newInstance();
        }
        catch (Throwable e) {
            // empty catch block
        }
        this._dataHandlerSerializer = dataHandlerSerializer;
        this._dataHandlerDeserializer = dataHandlerDeserializer;
    }

    public Version version() {
        return ModuleVersion.instance.version();
    }

    public boolean isHandled(Annotation ann) {
        String pkgName;
        Class<? extends Annotation> cls = ann.annotationType();
        Package pkg = cls.getPackage();
        String string = pkgName = pkg != null ? pkg.getName() : cls.getName();
        return pkgName.startsWith(this._jaxbPackageName);
    }

    public ObjectIdInfo findObjectIdInfo(Annotated ann) {
        XmlID idProp;
        if (!(ann instanceof AnnotatedClass)) {
            return null;
        }
        AnnotatedClass ac = (AnnotatedClass)ann;
        String idPropName = null;
        block4: for (AnnotatedMethod m : ac.memberMethods()) {
            idProp = (XmlID)m.getAnnotation(XmlID.class);
            if (idProp == null) continue;
            switch (m.getParameterCount()) {
                case 0: {
                    idPropName = JaxbAnnotationIntrospector.findJaxbPropertyName((Annotated)m, m.getRawType(), BeanUtil.okNameForGetter((AnnotatedMethod)m));
                    break block4;
                }
                case 1: {
                    idPropName = JaxbAnnotationIntrospector.findJaxbPropertyName((Annotated)m, m.getRawType(), BeanUtil.okNameForSetter((AnnotatedMethod)m));
                    break block4;
                }
                default: {
                    continue block4;
                }
            }
        }
        if (idPropName == null) {
            for (AnnotatedField f : ac.fields()) {
                idProp = (XmlID)f.getAnnotation(XmlID.class);
                if (idProp == null) continue;
                idPropName = JaxbAnnotationIntrospector.findJaxbPropertyName((Annotated)f, f.getRawType(), f.getName());
                break;
            }
        }
        if (idPropName != null) {
            Class<Object> scope = Object.class;
            return new ObjectIdInfo(idPropName, scope, ObjectIdGenerators.PropertyGenerator.class);
        }
        return null;
    }

    public String findRootName(AnnotatedClass ac) {
        XmlRootElement elem = this.findRootElementAnnotation(ac);
        if (elem != null) {
            String name = elem.name();
            return MARKER_FOR_DEFAULT.equals(name) ? "" : name;
        }
        return null;
    }

    public Boolean findIgnoreUnknownProperties(AnnotatedClass ac) {
        return null;
    }

    public Boolean isIgnorableType(AnnotatedClass ac) {
        return null;
    }

    public boolean hasIgnoreMarker(AnnotatedMember m) {
        return m.getAnnotation(XmlTransient.class) != null;
    }

    public VisibilityChecker<?> findAutoDetectVisibility(AnnotatedClass ac, VisibilityChecker<?> checker) {
        XmlAccessType at = this.findAccessType((Annotated)ac);
        if (at == null) {
            return checker;
        }
        switch (at) {
            case FIELD: {
                return checker.withFieldVisibility(JsonAutoDetect.Visibility.ANY).withSetterVisibility(JsonAutoDetect.Visibility.NONE).withGetterVisibility(JsonAutoDetect.Visibility.NONE).withIsGetterVisibility(JsonAutoDetect.Visibility.NONE);
            }
            case NONE: {
                return checker.withFieldVisibility(JsonAutoDetect.Visibility.NONE).withSetterVisibility(JsonAutoDetect.Visibility.NONE).withGetterVisibility(JsonAutoDetect.Visibility.NONE).withIsGetterVisibility(JsonAutoDetect.Visibility.NONE);
            }
            case PROPERTY: {
                return checker.withFieldVisibility(JsonAutoDetect.Visibility.NONE).withSetterVisibility(JsonAutoDetect.Visibility.PUBLIC_ONLY).withGetterVisibility(JsonAutoDetect.Visibility.PUBLIC_ONLY).withIsGetterVisibility(JsonAutoDetect.Visibility.PUBLIC_ONLY);
            }
            case PUBLIC_MEMBER: {
                return checker.withFieldVisibility(JsonAutoDetect.Visibility.PUBLIC_ONLY).withSetterVisibility(JsonAutoDetect.Visibility.PUBLIC_ONLY).withGetterVisibility(JsonAutoDetect.Visibility.PUBLIC_ONLY).withIsGetterVisibility(JsonAutoDetect.Visibility.PUBLIC_ONLY);
            }
        }
        return checker;
    }

    protected XmlAccessType findAccessType(Annotated ac) {
        XmlAccessorType at = this.findAnnotation(XmlAccessorType.class, ac, true, true, true);
        return at == null ? null : at.value();
    }

    public TypeResolverBuilder<?> findTypeResolver(MapperConfig<?> config, AnnotatedClass ac, JavaType baseType) {
        return null;
    }

    public TypeResolverBuilder<?> findPropertyTypeResolver(MapperConfig<?> config, AnnotatedMember am, JavaType baseType) {
        if (baseType.isContainerType()) {
            return null;
        }
        return this._typeResolverFromXmlElements(am);
    }

    public TypeResolverBuilder<?> findPropertyContentTypeResolver(MapperConfig<?> config, AnnotatedMember am, JavaType containerType) {
        if (!containerType.isContainerType()) {
            throw new IllegalArgumentException("Must call method with a container type (got " + containerType + ")");
        }
        return this._typeResolverFromXmlElements(am);
    }

    protected TypeResolverBuilder<?> _typeResolverFromXmlElements(AnnotatedMember am) {
        XmlElements elems = this.findAnnotation(XmlElements.class, (Annotated)am, false, false, false);
        XmlElementRefs elemRefs = this.findAnnotation(XmlElementRefs.class, (Annotated)am, false, false, false);
        if (elems == null && elemRefs == null) {
            return null;
        }
        StdTypeResolverBuilder b = new StdTypeResolverBuilder();
        b = b.init(JsonTypeInfo.Id.NAME, null);
        b = b.inclusion(JsonTypeInfo.As.WRAPPER_OBJECT);
        return b;
    }

    public List<NamedType> findSubtypes(Annotated a) {
        XmlElements elems = this.findAnnotation(XmlElements.class, a, false, false, false);
        if (elems != null) {
            ArrayList<NamedType> result = new ArrayList<NamedType>();
            for (XmlElement elem : elems.value()) {
                String name = elem.name();
                if (MARKER_FOR_DEFAULT.equals(name)) {
                    name = null;
                }
                result.add(new NamedType(elem.type(), name));
            }
            return result;
        }
        XmlElementRefs elemRefs = this.findAnnotation(XmlElementRefs.class, a, false, false, false);
        if (elemRefs != null) {
            ArrayList<NamedType> result = new ArrayList<NamedType>();
            for (XmlElementRef elemRef : elemRefs.value()) {
                XmlRootElement rootElement;
                Class refType = elemRef.type();
                if (JAXBElement.class.isAssignableFrom(refType)) continue;
                String name = elemRef.name();
                if ((name == null || MARKER_FOR_DEFAULT.equals(name)) && (rootElement = refType.getAnnotation(XmlRootElement.class)) != null) {
                    name = rootElement.name();
                }
                if (name == null || MARKER_FOR_DEFAULT.equals(name)) {
                    name = Introspector.decapitalize(refType.getSimpleName());
                }
                result.add(new NamedType(refType, name));
            }
            return result;
        }
        return null;
    }

    public String findTypeName(AnnotatedClass ac) {
        String name;
        XmlType type = this.findAnnotation(XmlType.class, (Annotated)ac, false, false, false);
        if (type != null && !MARKER_FOR_DEFAULT.equals(name = type.name())) {
            return name;
        }
        return null;
    }

    public JsonSerializer<?> findSerializer(Annotated am) {
        Class type = am.getRawType();
        XmlAdapter<Object, Object> adapter = this.findAdapter(am, true, type);
        if (adapter != null) {
            if (this.isContainerType(type)) {
                if (this.adapterTypeMatches(adapter, type)) {
                    return new XmlAdapterJsonSerializer(adapter);
                }
            } else {
                return new XmlAdapterJsonSerializer(adapter);
            }
        }
        if (type != null && this._dataHandlerSerializer != null && this.isDataHandler(type)) {
            return this._dataHandlerSerializer;
        }
        return null;
    }

    private boolean isDataHandler(Class<?> type) {
        return type != null && Object.class != type && ("javax.activation.DataHandler".equals(type.getName()) || this.isDataHandler(type.getSuperclass()));
    }

    public Object findContentSerializer(Annotated am) {
        XmlAdapter<?, ?> adapter = this._findContentAdapter(am);
        return adapter == null ? null : new XmlAdapterJsonSerializer(adapter);
    }

    public Class<?> findSerializationType(Annotated a) {
        XmlElement annotation = this.findAnnotation(XmlElement.class, a, false, false, false);
        if (annotation == null || annotation.type() == XmlElement.DEFAULT.class) {
            return null;
        }
        Class rawPropType = a.getRawType();
        if (this.isContainerType(rawPropType)) {
            return null;
        }
        Class allegedType = annotation.type();
        if (a.getAnnotation(XmlJavaTypeAdapter.class) != null) {
            return null;
        }
        return allegedType;
    }

    public JsonInclude.Include findSerializationInclusion(Annotated a, JsonInclude.Include defValue) {
        XmlElementWrapper w = (XmlElementWrapper)a.getAnnotation(XmlElementWrapper.class);
        if (w != null) {
            return w.nillable() ? JsonInclude.Include.ALWAYS : JsonInclude.Include.NON_NULL;
        }
        XmlElement e = (XmlElement)a.getAnnotation(XmlElement.class);
        if (e != null) {
            return e.nillable() ? JsonInclude.Include.ALWAYS : JsonInclude.Include.NON_NULL;
        }
        return defValue;
    }

    public String[] findSerializationPropertyOrder(AnnotatedClass ac) {
        XmlType type = this.findAnnotation(XmlType.class, (Annotated)ac, true, true, true);
        if (type == null) {
            return null;
        }
        String[] order = type.propOrder();
        if (order == null || order.length == 0) {
            return null;
        }
        return order;
    }

    public Boolean findSerializationSortAlphabetically(AnnotatedClass ac) {
        XmlAccessorOrder order = this.findAnnotation(XmlAccessorOrder.class, (Annotated)ac, true, true, true);
        return order == null ? null : Boolean.valueOf(order.value() == XmlAccessOrder.ALPHABETICAL);
    }

    public String findSerializationName(AnnotatedMethod am) {
        if (!this.isVisible(am)) {
            return null;
        }
        String name = JaxbAnnotationIntrospector.findJaxbPropertyName((Annotated)am, am.getRawType(), BeanUtil.okNameForGetter((AnnotatedMethod)am));
        if (name == null) {
            // empty if block
        }
        return name;
    }

    public boolean hasAsValueAnnotation(AnnotatedMethod am) {
        return false;
    }

    public String findEnumValue(Enum<?> e) {
        Class<?> enumClass = e.getDeclaringClass();
        String enumValue = e.name();
        try {
            XmlEnumValue xmlEnumValue = enumClass.getDeclaredField(enumValue).getAnnotation(XmlEnumValue.class);
            return xmlEnumValue != null ? xmlEnumValue.value() : enumValue;
        }
        catch (NoSuchFieldException e1) {
            throw new IllegalStateException("Could not locate Enum entry '" + enumValue + "' (Enum class " + enumClass.getName() + ")", e1);
        }
    }

    public String findSerializationName(AnnotatedField af) {
        if (!this.isVisible(af)) {
            return null;
        }
        String name = JaxbAnnotationIntrospector.findJaxbPropertyName((Annotated)af, af.getRawType(), null);
        return name == null ? af.getName() : name;
    }

    public Object findDeserializer(Annotated am) {
        Class type = am.getRawType();
        XmlAdapter<Object, Object> adapter = this.findAdapter(am, true, type);
        if (adapter != null) {
            if (this.isContainerType(type)) {
                if (this.adapterTypeMatches(adapter, type)) {
                    return new XmlAdapterJsonDeserializer(adapter);
                }
            } else {
                return new XmlAdapterJsonDeserializer(adapter);
            }
        }
        if (type != null && this._dataHandlerDeserializer != null && this.isDataHandler(type)) {
            return this._dataHandlerDeserializer;
        }
        return null;
    }

    public Object findKeyDeserializer(Annotated am) {
        return null;
    }

    public Object findContentDeserializer(Annotated am) {
        XmlAdapter<?, ?> adapter = this._findContentAdapter(am);
        return adapter == null ? null : new XmlAdapterJsonDeserializer(adapter);
    }

    public Class<?> findDeserializationType(Annotated a, JavaType baseType) {
        if (!baseType.isContainerType()) {
            return this._doFindDeserializationType(a, baseType);
        }
        return null;
    }

    public Class<?> findDeserializationContentType(Annotated a, JavaType baseContentType) {
        return this._doFindDeserializationType(a, baseContentType);
    }

    protected Class<?> _doFindDeserializationType(Annotated a, JavaType baseType) {
        Class type;
        if (a.hasAnnotation(XmlJavaTypeAdapter.class)) {
            return null;
        }
        XmlElement annotation = this.findAnnotation(XmlElement.class, a, false, false, false);
        if (annotation != null && (type = annotation.type()) != XmlElement.DEFAULT.class) {
            return type;
        }
        return null;
    }

    public String findDeserializationName(AnnotatedMethod am) {
        if (!this.isVisible(am)) {
            return null;
        }
        Class rawType = am.getRawParameterType(0);
        String name = JaxbAnnotationIntrospector.findJaxbPropertyName((Annotated)am, rawType, BeanUtil.okNameForSetter((AnnotatedMethod)am));
        return name;
    }

    public boolean hasAnySetterAnnotation(AnnotatedMethod am) {
        return false;
    }

    public boolean hasCreatorAnnotation(Annotated am) {
        return false;
    }

    public String findDeserializationName(AnnotatedField af) {
        if (!this.isVisible(af)) {
            return null;
        }
        String name = JaxbAnnotationIntrospector.findJaxbPropertyName((Annotated)af, af.getRawType(), null);
        return name == null ? af.getName() : name;
    }

    public String findDeserializationName(AnnotatedParameter param) {
        return null;
    }

    private boolean isVisible(AnnotatedField f) {
        for (Annotation annotation : f.getAnnotated().getDeclaredAnnotations()) {
            if (!this.isHandled(annotation)) continue;
            return true;
        }
        XmlAccessType accessType = XmlAccessType.PUBLIC_MEMBER;
        XmlAccessorType at = this.findAnnotation(XmlAccessorType.class, (Annotated)f, true, true, true);
        if (at != null) {
            accessType = at.value();
        }
        if (accessType == XmlAccessType.FIELD) {
            return true;
        }
        if (accessType == XmlAccessType.PUBLIC_MEMBER) {
            return Modifier.isPublic(f.getAnnotated().getModifiers());
        }
        return false;
    }

    private boolean isVisible(AnnotatedMethod m) {
        for (Annotation annotation : m.getAnnotated().getDeclaredAnnotations()) {
            if (!this.isHandled(annotation)) continue;
            return true;
        }
        XmlAccessType accessType = XmlAccessType.PUBLIC_MEMBER;
        XmlAccessorType at = this.findAnnotation(XmlAccessorType.class, (Annotated)m, true, true, true);
        if (at != null) {
            accessType = at.value();
        }
        if (accessType == XmlAccessType.PROPERTY || accessType == XmlAccessType.PUBLIC_MEMBER) {
            return Modifier.isPublic(m.getModifiers());
        }
        return false;
    }

    private <A extends Annotation> A findAnnotation(Class<A> annotationClass, Annotated annotated, boolean includePackage, boolean includeClass, boolean includeSuperclasses) {
        Annotation annotation = annotated.getAnnotation(annotationClass);
        if (annotation != null) {
            return (A)annotation;
        }
        Class memberClass = null;
        if (annotated instanceof AnnotatedParameter) {
            memberClass = ((AnnotatedParameter)annotated).getDeclaringClass();
        } else {
            AnnotatedElement annType = annotated.getAnnotated();
            if (annType instanceof Member) {
                memberClass = ((Member)((Object)annType)).getDeclaringClass();
                if (includeClass && (annotation = memberClass.getAnnotation(annotationClass)) != null) {
                    return (A)annotation;
                }
            } else if (annType instanceof Class) {
                memberClass = (Class)annType;
            } else {
                throw new IllegalStateException("Unsupported annotated member: " + annotated.getClass().getName());
            }
        }
        if (memberClass != null) {
            Package pkg;
            if (includeSuperclasses) {
                for (Class<?> superclass = memberClass.getSuperclass(); superclass != null && superclass != Object.class; superclass = superclass.getSuperclass()) {
                    annotation = superclass.getAnnotation(annotationClass);
                    if (annotation == null) continue;
                    return (A)annotation;
                }
            }
            if (includePackage && (pkg = memberClass.getPackage()) != null) {
                return memberClass.getPackage().getAnnotation(annotationClass);
            }
        }
        return null;
    }

    private static String findJaxbPropertyName(Annotated ae, Class<?> aeType, String defaultName) {
        XmlValue valueInfo;
        XmlAttribute attribute = (XmlAttribute)ae.getAnnotation(XmlAttribute.class);
        if (attribute != null) {
            String name = attribute.name();
            if (!MARKER_FOR_DEFAULT.equals(name)) {
                return name;
            }
            return defaultName;
        }
        XmlElement element = (XmlElement)ae.getAnnotation(XmlElement.class);
        if (element != null) {
            String name = element.name();
            if (!MARKER_FOR_DEFAULT.equals(name)) {
                return name;
            }
            return defaultName;
        }
        XmlElementWrapper elementWrapper = (XmlElementWrapper)ae.getAnnotation(XmlElementWrapper.class);
        if (elementWrapper != null) {
            String name = elementWrapper.name();
            if (!MARKER_FOR_DEFAULT.equals(name)) {
                return name;
            }
            return defaultName;
        }
        XmlElementRef elementRef = (XmlElementRef)ae.getAnnotation(XmlElementRef.class);
        if (elementRef != null) {
            XmlRootElement rootElement;
            String name = elementRef.name();
            if (!MARKER_FOR_DEFAULT.equals(name)) {
                return name;
            }
            if (aeType != null && (rootElement = aeType.getAnnotation(XmlRootElement.class)) != null) {
                name = rootElement.name();
                if (!MARKER_FOR_DEFAULT.equals(name)) {
                    return name;
                }
                return Introspector.decapitalize(aeType.getSimpleName());
            }
        }
        if ((valueInfo = (XmlValue)ae.getAnnotation(XmlValue.class)) != null) {
            return "value";
        }
        return null;
    }

    private XmlRootElement findRootElementAnnotation(AnnotatedClass ac) {
        return this.findAnnotation(XmlRootElement.class, (Annotated)ac, true, false, true);
    }

    private XmlAdapter<Object, Object> findAdapter(Annotated am, boolean forSerialization, Class<?> type) {
        XmlAdapter<Object, Object> adapter;
        XmlAdapter<Object, Object> adapter2;
        XmlJavaTypeAdapter adapterInfo;
        Class<?> potentialAdaptee;
        if (am instanceof AnnotatedClass) {
            return this.findAdapterForClass((AnnotatedClass)am, forSerialization);
        }
        Member member = (Member)((Object)am.getAnnotated());
        if (member != null && (potentialAdaptee = member.getDeclaringClass()) != null && (adapterInfo = potentialAdaptee.getAnnotation(XmlJavaTypeAdapter.class)) != null && (adapter2 = this.checkAdapter(adapterInfo, type)) != null) {
            return adapter2;
        }
        XmlJavaTypeAdapter adapterInfo2 = this.findAnnotation(XmlJavaTypeAdapter.class, am, true, false, false);
        if (adapterInfo2 != null && (adapter = this.checkAdapter(adapterInfo2, type)) != null) {
            return adapter;
        }
        XmlJavaTypeAdapters adapters = this.findAnnotation(XmlJavaTypeAdapters.class, am, true, false, false);
        if (adapters != null) {
            for (XmlJavaTypeAdapter info : adapters.value()) {
                XmlAdapter<Object, Object> adapter3 = this.checkAdapter(info, type);
                if (adapter3 == null) continue;
                return adapter3;
            }
        }
        return null;
    }

    private final XmlAdapter<Object, Object> checkAdapter(XmlJavaTypeAdapter adapterInfo, Class<?> typeNeeded) {
        Class adaptedType = adapterInfo.type();
        if (adaptedType == XmlJavaTypeAdapter.DEFAULT.class || adaptedType.isAssignableFrom(typeNeeded)) {
            Class cls = adapterInfo.value();
            return (XmlAdapter)ClassUtil.createInstance((Class)cls, (boolean)false);
        }
        return null;
    }

    private XmlAdapter<Object, Object> findAdapterForClass(AnnotatedClass ac, boolean forSerialization) {
        XmlJavaTypeAdapter adapterInfo = ac.getAnnotated().getAnnotation(XmlJavaTypeAdapter.class);
        if (adapterInfo != null) {
            Class cls = adapterInfo.value();
            return (XmlAdapter)ClassUtil.createInstance((Class)cls, (boolean)false);
        }
        return null;
    }

    private final TypeFactory getTypeFactory() {
        return this._typeFactory;
    }

    private boolean isContainerType(Class<?> raw) {
        return raw.isArray() || Collection.class.isAssignableFrom(raw) || Map.class.isAssignableFrom(raw);
    }

    private boolean adapterTypeMatches(XmlAdapter<?, ?> adapter, Class<?> targetType) {
        return this.findAdapterBoundType(adapter).isAssignableFrom(targetType);
    }

    private Class<?> findAdapterBoundType(XmlAdapter<?, ?> adapter) {
        JavaType adapterType;
        TypeFactory tf = this.getTypeFactory();
        JavaType[] params = tf.findTypeParameters(adapterType = tf.constructType(adapter.getClass()), XmlAdapter.class);
        if (params == null || params.length < 2) {
            return Object.class;
        }
        return params[1].getRawClass();
    }

    protected XmlAdapter<?, ?> _findContentAdapter(Annotated ann) {
        Class type = ann.getRawType();
        if (this.isContainerType(type) && ann instanceof AnnotatedMember) {
            AnnotatedMember member = (AnnotatedMember)ann;
            JavaType containerType = this.getTypeFactory().constructType(member.getGenericType(), member.getDeclaringClass());
            Class contentType = containerType.getContentType().getRawClass();
            XmlAdapter<Object, Object> adapter = this.findAdapter((Annotated)member, true, type);
            if (adapter != null && this.adapterTypeMatches(adapter, contentType)) {
                return adapter;
            }
        }
        return null;
    }

    public Boolean hasRequiredMarker(AnnotatedMember m) {
        XmlElement annotation = (XmlElement)m.getAnnotation(XmlElement.class);
        return annotation == null ? null : Boolean.valueOf(annotation.required());
    }
}

