/*
 * Decompiled with CFR 0.152.
 */
package io.stargate.sdk;

import io.stargate.sdk.Service;
import io.stargate.sdk.api.TokenProvider;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class ServiceDatacenter<SERVICE extends Service> {
    private final String id;
    private TokenProvider tokenProvider;
    private final Map<String, SERVICE> services = new HashMap<String, SERVICE>();

    public ServiceDatacenter(String id) {
        this.id = id;
    }

    public ServiceDatacenter(String id, TokenProvider tokenProvider, List<SERVICE> nodes) {
        this(id);
        this.tokenProvider = tokenProvider;
        nodes.forEach(this::addService);
    }

    public ServiceDatacenter(String id, TokenProvider tokenProvider, SERVICE ... nodes) {
        this(id, tokenProvider, Arrays.asList(nodes));
    }

    public SERVICE getService(String dcId) {
        return (SERVICE)((Service)this.getServices().get(dcId));
    }

    public Map<String, SERVICE> getServices() {
        return this.services;
    }

    public TokenProvider getTokenProvider() {
        return this.tokenProvider;
    }

    public String getId() {
        return this.id;
    }

    public void setTokenProvider(TokenProvider tokenProvider) {
        this.tokenProvider = tokenProvider;
    }

    public void addService(SERVICE s) {
        if (s != null) {
            this.services.put(((Service)s).getId(), s);
        }
    }
}

