/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.dse.driver.internal.core.graph;

import com.datastax.dse.driver.api.core.graph.AsyncGraphResultSet;
import com.datastax.dse.driver.api.core.graph.GraphExecutionInfo;
import com.datastax.dse.driver.api.core.graph.GraphNode;
import com.datastax.dse.driver.internal.core.graph.ContinuousGraphRequestHandler;
import com.datastax.dse.driver.internal.core.graph.GraphExecutionInfoConverter;
import com.datastax.dse.driver.internal.core.graph.GraphProtocol;
import com.datastax.dse.driver.internal.core.graph.GraphResultIterator;
import com.datastax.oss.driver.api.core.cql.ExecutionInfo;
import com.datastax.oss.driver.internal.core.util.CountingIterator;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.util.Collections;
import java.util.Queue;
import java.util.concurrent.CompletionStage;
import net.jcip.annotations.NotThreadSafe;

@NotThreadSafe
public class ContinuousAsyncGraphResultSet
implements AsyncGraphResultSet {
    private final CountingIterator<GraphNode> iterator;
    private final int pageNumber;
    private final boolean hasMorePages;
    private final ExecutionInfo executionInfo;
    private final ContinuousGraphRequestHandler continuousGraphRequestHandler;
    private final Iterable<GraphNode> currentPage;

    public ContinuousAsyncGraphResultSet(ExecutionInfo executionInfo, Queue<GraphNode> data, int pageNumber, boolean hasMorePages, ContinuousGraphRequestHandler continuousGraphRequestHandler, GraphProtocol graphProtocol) {
        this.iterator = new GraphResultIterator(data, graphProtocol);
        this.pageNumber = pageNumber;
        this.hasMorePages = hasMorePages;
        this.executionInfo = executionInfo;
        this.continuousGraphRequestHandler = continuousGraphRequestHandler;
        this.currentPage = () -> this.iterator;
    }

    @Override
    @NonNull
    public ExecutionInfo getRequestExecutionInfo() {
        return this.executionInfo;
    }

    @Override
    @Deprecated
    @NonNull
    public GraphExecutionInfo getExecutionInfo() {
        return GraphExecutionInfoConverter.convert(this.executionInfo);
    }

    @Override
    public int remaining() {
        return this.iterator.remaining();
    }

    @Override
    @NonNull
    public Iterable<GraphNode> currentPage() {
        return this.currentPage;
    }

    @Override
    public boolean hasMorePages() {
        return this.hasMorePages;
    }

    @Override
    @NonNull
    public CompletionStage<AsyncGraphResultSet> fetchNextPage() throws IllegalStateException {
        if (!this.hasMorePages()) {
            throw new IllegalStateException("Can't call fetchNextPage() on the last page (use hasMorePages() to check)");
        }
        return this.continuousGraphRequestHandler.fetchNextPage();
    }

    @Override
    public void cancel() {
        this.continuousGraphRequestHandler.cancel();
    }

    public int pageNumber() {
        return this.pageNumber;
    }

    static AsyncGraphResultSet empty(final ExecutionInfo executionInfo) {
        return new AsyncGraphResultSet(){

            @Override
            @NonNull
            public ExecutionInfo getRequestExecutionInfo() {
                return executionInfo;
            }

            @Override
            @Deprecated
            @NonNull
            public GraphExecutionInfo getExecutionInfo() {
                return GraphExecutionInfoConverter.convert(executionInfo);
            }

            @Override
            @NonNull
            public Iterable<GraphNode> currentPage() {
                return Collections.emptyList();
            }

            @Override
            public int remaining() {
                return 0;
            }

            @Override
            public boolean hasMorePages() {
                return false;
            }

            @Override
            @NonNull
            public CompletionStage<AsyncGraphResultSet> fetchNextPage() throws IllegalStateException {
                throw new IllegalStateException("Can't call fetchNextPage() on the last page (use hasMorePages() to check)");
            }

            @Override
            public void cancel() {
            }
        };
    }
}

