/*
 * Decompiled with CFR 0.152.
 */
package com.vectorsearch.faiss.utils;

import com.globalload.LibraryLoaderJNI;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.FileSystemNotFoundException;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.ProviderNotFoundException;
import java.nio.file.StandardCopyOption;
import java.util.logging.Logger;

public class NativeUtils2 {
    public static final String NATIVE_FOLDER_PATH_PREFIX = "nativeutils2";
    private static final Logger LOGGER = Logger.getLogger(NativeUtils2.class.getName());
    private static final int MIN_PREFIX_LENGTH = 3;
    private static File temporaryDir;

    private NativeUtils2() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void loadLibraryFromJar(String path, String[] requiredLibPaths) throws IOException {
        if (temporaryDir == null) {
            temporaryDir = NativeUtils2.createTempDirectory();
            temporaryDir.deleteOnExit();
        }
        NativeUtils2.copyFileToDir(path, temporaryDir);
        for (String libPath : requiredLibPaths) {
            NativeUtils2.copyFileToDir(libPath, temporaryDir);
        }
        for (String libPath : requiredLibPaths) {
            File tempLibToLoadBefore = new File(temporaryDir, NativeUtils2.baseName(libPath));
            try {
                LibraryLoaderJNI.loadLibrary((String)tempLibToLoadBefore.getAbsolutePath());
            }
            catch (UnsatisfiedLinkError e) {
                LOGGER.warning(e.getMessage());
            }
        }
        File tempLibToLoad = new File(temporaryDir, NativeUtils2.baseName(path));
        try {
            System.load(tempLibToLoad.getAbsolutePath());
        }
        finally {
            if (NativeUtils2.isPosixCompliant()) {
                boolean status = tempLibToLoad.delete();
                if (status) {
                    LOGGER.info("Deleted file : " + tempLibToLoad.getAbsolutePath());
                }
            } else {
                tempLibToLoad.deleteOnExit();
            }
        }
    }

    private static void copyFileToDir(String srcPath, File dstDirPath) throws IOException {
        if (srcPath == null || !srcPath.startsWith("/")) {
            throw new IllegalArgumentException("The path has to be absolute (start with '/').");
        }
        String filename = NativeUtils2.baseName(srcPath);
        if (filename == null || filename.length() < 3) {
            throw new IllegalArgumentException("The filename has to be at least 3 characters long.");
        }
        File dstTemp = new File(dstDirPath, filename);
        try (InputStream is = NativeUtils2.class.getResourceAsStream(srcPath);){
            Files.copy(is, dstTemp.toPath(), StandardCopyOption.REPLACE_EXISTING);
        }
        catch (IOException e) {
            boolean status = dstTemp.delete();
            if (status) {
                LOGGER.info("Deleted file : " + dstTemp.getAbsolutePath());
            }
            throw e;
        }
        catch (NullPointerException e) {
            boolean status = dstTemp.delete();
            if (status) {
                LOGGER.info("Deleted file : " + dstTemp.getAbsolutePath());
            }
            throw new FileNotFoundException("File " + srcPath + " was not found inside JAR.");
        }
    }

    private static String sourceDir(String path) {
        String dirPath = (String)path.subSequence(0, path.lastIndexOf("/"));
        return dirPath;
    }

    private static String baseName(String path) {
        String[] parts = path.split("/");
        return parts.length > 1 ? parts[parts.length - 1] : null;
    }

    private static boolean isPosixCompliant() {
        try {
            return FileSystems.getDefault().supportedFileAttributeViews().contains("posix");
        }
        catch (SecurityException | FileSystemNotFoundException | ProviderNotFoundException e) {
            return false;
        }
    }

    private static File createTempDirectory() throws IOException {
        String tempDir = System.getProperty("java.io.tmpdir");
        File generatedDir = new File(tempDir, NATIVE_FOLDER_PATH_PREFIX + System.nanoTime());
        if (!generatedDir.mkdir()) {
            throw new IOException("Failed to create temp directory " + generatedDir.getName());
        }
        return generatedDir;
    }
}

