/*
 * Decompiled with CFR 0.152.
 */
package com.vectorsearch.faiss.swig;

import com.vectorsearch.faiss.swig.ByteVector;
import com.vectorsearch.faiss.swig.IOWriter;
import com.vectorsearch.faiss.swig.swigfaissJNI;

public class VectorIOWriter
extends IOWriter {
    private transient long swigCPtr;

    protected VectorIOWriter(long cPtr, boolean cMemoryOwn) {
        super(swigfaissJNI.VectorIOWriter_SWIGUpcast(cPtr), cMemoryOwn);
        this.swigCPtr = cPtr;
    }

    protected static long getCPtr(VectorIOWriter obj) {
        return obj == null ? 0L : obj.swigCPtr;
    }

    @Override
    protected void finalize() {
        this.delete();
    }

    @Override
    public synchronized void delete() {
        if (this.swigCPtr != 0L) {
            if (this.swigCMemOwn) {
                this.swigCMemOwn = false;
                swigfaissJNI.delete_VectorIOWriter(this.swigCPtr);
            }
            this.swigCPtr = 0L;
        }
        super.delete();
    }

    public void setData(ByteVector value) {
        swigfaissJNI.VectorIOWriter_data_set(this.swigCPtr, this, ByteVector.getCPtr(value), value);
    }

    public ByteVector getData() {
        long cPtr = swigfaissJNI.VectorIOWriter_data_get(this.swigCPtr, this);
        return cPtr == 0L ? null : new ByteVector(cPtr, false);
    }

    public VectorIOWriter() {
        this(swigfaissJNI.new_VectorIOWriter(), true);
    }
}

