/*
 * Decompiled with CFR 0.152.
 */
package com.vectorsearch.faiss.swig;

import com.vectorsearch.faiss.swig.FloatVector;
import com.vectorsearch.faiss.swig.Index;
import com.vectorsearch.faiss.swig.MetricType;
import com.vectorsearch.faiss.swig.SWIGTYPE_p_faiss__InvertedListScanner;
import com.vectorsearch.faiss.swig.SWIGTYPE_p_faiss__ScalarQuantizer__SQDistanceComputer;
import com.vectorsearch.faiss.swig.SWIGTYPE_p_float;
import com.vectorsearch.faiss.swig.SWIGTYPE_p_unsigned_char;
import com.vectorsearch.faiss.swig.swigfaissJNI;

public class ScalarQuantizer {
    private transient long swigCPtr;
    protected transient boolean swigCMemOwn;

    protected ScalarQuantizer(long cPtr, boolean cMemoryOwn) {
        this.swigCMemOwn = cMemoryOwn;
        this.swigCPtr = cPtr;
    }

    protected static long getCPtr(ScalarQuantizer obj) {
        return obj == null ? 0L : obj.swigCPtr;
    }

    protected void finalize() {
        this.delete();
    }

    public synchronized void delete() {
        if (this.swigCPtr != 0L) {
            if (this.swigCMemOwn) {
                this.swigCMemOwn = false;
                swigfaissJNI.delete_ScalarQuantizer(this.swigCPtr);
            }
            this.swigCPtr = 0L;
        }
    }

    public void setQtype(QuantizerType value) {
        swigfaissJNI.ScalarQuantizer_qtype_set(this.swigCPtr, this, value.swigValue());
    }

    public QuantizerType getQtype() {
        return QuantizerType.swigToEnum(swigfaissJNI.ScalarQuantizer_qtype_get(this.swigCPtr, this));
    }

    public void setRangestat(RangeStat value) {
        swigfaissJNI.ScalarQuantizer_rangestat_set(this.swigCPtr, this, value.swigValue());
    }

    public RangeStat getRangestat() {
        return RangeStat.swigToEnum(swigfaissJNI.ScalarQuantizer_rangestat_get(this.swigCPtr, this));
    }

    public void setRangestat_arg(float value) {
        swigfaissJNI.ScalarQuantizer_rangestat_arg_set(this.swigCPtr, this, value);
    }

    public float getRangestat_arg() {
        return swigfaissJNI.ScalarQuantizer_rangestat_arg_get(this.swigCPtr, this);
    }

    public void setD(long value) {
        swigfaissJNI.ScalarQuantizer_d_set(this.swigCPtr, this, value);
    }

    public long getD() {
        return swigfaissJNI.ScalarQuantizer_d_get(this.swigCPtr, this);
    }

    public void setBits(long value) {
        swigfaissJNI.ScalarQuantizer_bits_set(this.swigCPtr, this, value);
    }

    public long getBits() {
        return swigfaissJNI.ScalarQuantizer_bits_get(this.swigCPtr, this);
    }

    public void setCode_size(long value) {
        swigfaissJNI.ScalarQuantizer_code_size_set(this.swigCPtr, this, value);
    }

    public long getCode_size() {
        return swigfaissJNI.ScalarQuantizer_code_size_get(this.swigCPtr, this);
    }

    public void setTrained(FloatVector value) {
        swigfaissJNI.ScalarQuantizer_trained_set(this.swigCPtr, this, FloatVector.getCPtr(value), value);
    }

    public FloatVector getTrained() {
        long cPtr = swigfaissJNI.ScalarQuantizer_trained_get(this.swigCPtr, this);
        return cPtr == 0L ? null : new FloatVector(cPtr, false);
    }

    public ScalarQuantizer(long d, QuantizerType qtype) {
        this(swigfaissJNI.new_ScalarQuantizer__SWIG_0(d, qtype.swigValue()), true);
    }

    public ScalarQuantizer() {
        this(swigfaissJNI.new_ScalarQuantizer__SWIG_1(), true);
    }

    public void set_derived_sizes() {
        swigfaissJNI.ScalarQuantizer_set_derived_sizes(this.swigCPtr, this);
    }

    public void train(long n, SWIGTYPE_p_float x) {
        swigfaissJNI.ScalarQuantizer_train(this.swigCPtr, this, n, SWIGTYPE_p_float.getCPtr(x));
    }

    public void train_residual(long n, SWIGTYPE_p_float x, Index quantizer, boolean by_residual, boolean verbose) {
        swigfaissJNI.ScalarQuantizer_train_residual(this.swigCPtr, this, n, SWIGTYPE_p_float.getCPtr(x), Index.getCPtr(quantizer), quantizer, by_residual, verbose);
    }

    public void compute_codes(SWIGTYPE_p_float x, SWIGTYPE_p_unsigned_char codes, long n) {
        swigfaissJNI.ScalarQuantizer_compute_codes(this.swigCPtr, this, SWIGTYPE_p_float.getCPtr(x), SWIGTYPE_p_unsigned_char.getCPtr(codes), n);
    }

    public void decode(SWIGTYPE_p_unsigned_char code, SWIGTYPE_p_float x, long n) {
        swigfaissJNI.ScalarQuantizer_decode(this.swigCPtr, this, SWIGTYPE_p_unsigned_char.getCPtr(code), SWIGTYPE_p_float.getCPtr(x), n);
    }

    public Quantizer select_quantizer() {
        long cPtr = swigfaissJNI.ScalarQuantizer_select_quantizer(this.swigCPtr, this);
        return cPtr == 0L ? null : new Quantizer(cPtr, false);
    }

    public SWIGTYPE_p_faiss__ScalarQuantizer__SQDistanceComputer get_distance_computer(MetricType metric) {
        long cPtr = swigfaissJNI.ScalarQuantizer_get_distance_computer__SWIG_0(this.swigCPtr, this, metric.swigValue());
        return cPtr == 0L ? null : new SWIGTYPE_p_faiss__ScalarQuantizer__SQDistanceComputer(cPtr, false);
    }

    public SWIGTYPE_p_faiss__ScalarQuantizer__SQDistanceComputer get_distance_computer() {
        long cPtr = swigfaissJNI.ScalarQuantizer_get_distance_computer__SWIG_1(this.swigCPtr, this);
        return cPtr == 0L ? null : new SWIGTYPE_p_faiss__ScalarQuantizer__SQDistanceComputer(cPtr, true);
    }

    public SWIGTYPE_p_faiss__InvertedListScanner select_InvertedListScanner(MetricType mt, Index quantizer, boolean store_pairs, boolean by_residual) {
        long cPtr = swigfaissJNI.ScalarQuantizer_select_InvertedListScanner__SWIG_0(this.swigCPtr, this, mt.swigValue(), Index.getCPtr(quantizer), quantizer, store_pairs, by_residual);
        return cPtr == 0L ? null : new SWIGTYPE_p_faiss__InvertedListScanner(cPtr, false);
    }

    public SWIGTYPE_p_faiss__InvertedListScanner select_InvertedListScanner(MetricType mt, Index quantizer, boolean store_pairs) {
        long cPtr = swigfaissJNI.ScalarQuantizer_select_InvertedListScanner__SWIG_1(this.swigCPtr, this, mt.swigValue(), Index.getCPtr(quantizer), quantizer, store_pairs);
        return cPtr == 0L ? null : new SWIGTYPE_p_faiss__InvertedListScanner(cPtr, false);
    }

    public static final class RangeStat {
        public static final RangeStat RS_minmax = new RangeStat("RS_minmax");
        public static final RangeStat RS_meanstd = new RangeStat("RS_meanstd");
        public static final RangeStat RS_quantiles = new RangeStat("RS_quantiles");
        public static final RangeStat RS_optim = new RangeStat("RS_optim");
        private static RangeStat[] swigValues = new RangeStat[]{RS_minmax, RS_meanstd, RS_quantiles, RS_optim};
        private static int swigNext = 0;
        private final int swigValue;
        private final String swigName;

        public final int swigValue() {
            return this.swigValue;
        }

        public String toString() {
            return this.swigName;
        }

        public static RangeStat swigToEnum(int swigValue) {
            if (swigValue < swigValues.length && swigValue >= 0 && RangeStat.swigValues[swigValue].swigValue == swigValue) {
                return swigValues[swigValue];
            }
            for (int i = 0; i < swigValues.length; ++i) {
                if (RangeStat.swigValues[i].swigValue != swigValue) continue;
                return swigValues[i];
            }
            throw new IllegalArgumentException("No enum " + RangeStat.class + " with value " + swigValue);
        }

        private RangeStat(String swigName) {
            this.swigName = swigName;
            this.swigValue = swigNext++;
        }

        private RangeStat(String swigName, int swigValue) {
            this.swigName = swigName;
            this.swigValue = swigValue;
            swigNext = swigValue + 1;
        }

        private RangeStat(String swigName, RangeStat swigEnum) {
            this.swigName = swigName;
            this.swigValue = swigEnum.swigValue;
            swigNext = this.swigValue + 1;
        }
    }

    public static final class QuantizerType {
        public static final QuantizerType QT_8bit = new QuantizerType("QT_8bit");
        public static final QuantizerType QT_4bit = new QuantizerType("QT_4bit");
        public static final QuantizerType QT_8bit_uniform = new QuantizerType("QT_8bit_uniform");
        public static final QuantizerType QT_4bit_uniform = new QuantizerType("QT_4bit_uniform");
        public static final QuantizerType QT_fp16 = new QuantizerType("QT_fp16");
        public static final QuantizerType QT_8bit_direct = new QuantizerType("QT_8bit_direct");
        public static final QuantizerType QT_6bit = new QuantizerType("QT_6bit");
        private static QuantizerType[] swigValues = new QuantizerType[]{QT_8bit, QT_4bit, QT_8bit_uniform, QT_4bit_uniform, QT_fp16, QT_8bit_direct, QT_6bit};
        private static int swigNext = 0;
        private final int swigValue;
        private final String swigName;

        public final int swigValue() {
            return this.swigValue;
        }

        public String toString() {
            return this.swigName;
        }

        public static QuantizerType swigToEnum(int swigValue) {
            if (swigValue < swigValues.length && swigValue >= 0 && QuantizerType.swigValues[swigValue].swigValue == swigValue) {
                return swigValues[swigValue];
            }
            for (int i = 0; i < swigValues.length; ++i) {
                if (QuantizerType.swigValues[i].swigValue != swigValue) continue;
                return swigValues[i];
            }
            throw new IllegalArgumentException("No enum " + QuantizerType.class + " with value " + swigValue);
        }

        private QuantizerType(String swigName) {
            this.swigName = swigName;
            this.swigValue = swigNext++;
        }

        private QuantizerType(String swigName, int swigValue) {
            this.swigName = swigName;
            this.swigValue = swigValue;
            swigNext = swigValue + 1;
        }

        private QuantizerType(String swigName, QuantizerType swigEnum) {
            this.swigName = swigName;
            this.swigValue = swigEnum.swigValue;
            swigNext = this.swigValue + 1;
        }
    }

    public static class Quantizer {
        private transient long swigCPtr;
        protected transient boolean swigCMemOwn;

        protected Quantizer(long cPtr, boolean cMemoryOwn) {
            this.swigCMemOwn = cMemoryOwn;
            this.swigCPtr = cPtr;
        }

        protected static long getCPtr(Quantizer obj) {
            return obj == null ? 0L : obj.swigCPtr;
        }

        protected void finalize() {
            this.delete();
        }

        public synchronized void delete() {
            if (this.swigCPtr != 0L) {
                if (this.swigCMemOwn) {
                    this.swigCMemOwn = false;
                    swigfaissJNI.delete_ScalarQuantizer_Quantizer(this.swigCPtr);
                }
                this.swigCPtr = 0L;
            }
        }

        public void encode_vector(SWIGTYPE_p_float x, SWIGTYPE_p_unsigned_char code) {
            swigfaissJNI.ScalarQuantizer_Quantizer_encode_vector(this.swigCPtr, this, SWIGTYPE_p_float.getCPtr(x), SWIGTYPE_p_unsigned_char.getCPtr(code));
        }

        public void decode_vector(SWIGTYPE_p_unsigned_char code, SWIGTYPE_p_float x) {
            swigfaissJNI.ScalarQuantizer_Quantizer_decode_vector(this.swigCPtr, this, SWIGTYPE_p_unsigned_char.getCPtr(code), SWIGTYPE_p_float.getCPtr(x));
        }
    }
}

