/*
 * Decompiled with CFR 0.152.
 */
package com.vectorsearch.faiss.swig;

import com.vectorsearch.faiss.swig.ByteVector;
import com.vectorsearch.faiss.swig.DistanceComputer;
import com.vectorsearch.faiss.swig.IDSelector;
import com.vectorsearch.faiss.swig.Index;
import com.vectorsearch.faiss.swig.MetricType;
import com.vectorsearch.faiss.swig.PolysemousTraining;
import com.vectorsearch.faiss.swig.ProductQuantizer;
import com.vectorsearch.faiss.swig.SWIGTYPE_p_float;
import com.vectorsearch.faiss.swig.SWIGTYPE_p_int;
import com.vectorsearch.faiss.swig.SWIGTYPE_p_long;
import com.vectorsearch.faiss.swig.SWIGTYPE_p_unsigned_char;
import com.vectorsearch.faiss.swig.swigfaissJNI;

public class IndexPQ
extends Index {
    private transient long swigCPtr;

    protected IndexPQ(long cPtr, boolean cMemoryOwn) {
        super(swigfaissJNI.IndexPQ_SWIGUpcast(cPtr), cMemoryOwn);
        this.swigCPtr = cPtr;
    }

    protected static long getCPtr(IndexPQ obj) {
        return obj == null ? 0L : obj.swigCPtr;
    }

    @Override
    protected void finalize() {
        this.delete();
    }

    @Override
    public synchronized void delete() {
        if (this.swigCPtr != 0L) {
            if (this.swigCMemOwn) {
                this.swigCMemOwn = false;
                swigfaissJNI.delete_IndexPQ(this.swigCPtr);
            }
            this.swigCPtr = 0L;
        }
        super.delete();
    }

    public void setPq(ProductQuantizer value) {
        swigfaissJNI.IndexPQ_pq_set(this.swigCPtr, this, ProductQuantizer.getCPtr(value), value);
    }

    public ProductQuantizer getPq() {
        long cPtr = swigfaissJNI.IndexPQ_pq_get(this.swigCPtr, this);
        return cPtr == 0L ? null : new ProductQuantizer(cPtr, false);
    }

    public void setCodes(ByteVector value) {
        swigfaissJNI.IndexPQ_codes_set(this.swigCPtr, this, ByteVector.getCPtr(value), value);
    }

    public ByteVector getCodes() {
        long cPtr = swigfaissJNI.IndexPQ_codes_get(this.swigCPtr, this);
        return cPtr == 0L ? null : new ByteVector(cPtr, false);
    }

    public IndexPQ(int d, long M, long nbits, MetricType metric) {
        this(swigfaissJNI.new_IndexPQ__SWIG_0(d, M, nbits, metric.swigValue()), true);
    }

    public IndexPQ(int d, long M, long nbits) {
        this(swigfaissJNI.new_IndexPQ__SWIG_1(d, M, nbits), true);
    }

    public IndexPQ() {
        this(swigfaissJNI.new_IndexPQ__SWIG_2(), true);
    }

    @Override
    public void train(long n, SWIGTYPE_p_float x) {
        swigfaissJNI.IndexPQ_train(this.swigCPtr, this, n, SWIGTYPE_p_float.getCPtr(x));
    }

    @Override
    public void add(long n, SWIGTYPE_p_float x) {
        swigfaissJNI.IndexPQ_add(this.swigCPtr, this, n, SWIGTYPE_p_float.getCPtr(x));
    }

    @Override
    public void search(long n, SWIGTYPE_p_float x, long k, SWIGTYPE_p_float distances, SWIGTYPE_p_long labels) {
        swigfaissJNI.IndexPQ_search(this.swigCPtr, this, n, SWIGTYPE_p_float.getCPtr(x), k, SWIGTYPE_p_float.getCPtr(distances), SWIGTYPE_p_long.getCPtr(labels));
    }

    @Override
    public void reset() {
        swigfaissJNI.IndexPQ_reset(this.swigCPtr, this);
    }

    @Override
    public void reconstruct_n(long i0, long ni, SWIGTYPE_p_float recons) {
        swigfaissJNI.IndexPQ_reconstruct_n(this.swigCPtr, this, i0, ni, SWIGTYPE_p_float.getCPtr(recons));
    }

    @Override
    public void reconstruct(long key, SWIGTYPE_p_float recons) {
        swigfaissJNI.IndexPQ_reconstruct(this.swigCPtr, this, key, SWIGTYPE_p_float.getCPtr(recons));
    }

    @Override
    public long remove_ids(IDSelector sel) {
        return swigfaissJNI.IndexPQ_remove_ids(this.swigCPtr, this, IDSelector.getCPtr(sel), sel);
    }

    @Override
    public long sa_code_size() {
        return swigfaissJNI.IndexPQ_sa_code_size(this.swigCPtr, this);
    }

    @Override
    public void sa_encode(long n, SWIGTYPE_p_float x, SWIGTYPE_p_unsigned_char bytes) {
        swigfaissJNI.IndexPQ_sa_encode(this.swigCPtr, this, n, SWIGTYPE_p_float.getCPtr(x), SWIGTYPE_p_unsigned_char.getCPtr(bytes));
    }

    @Override
    public void sa_decode(long n, SWIGTYPE_p_unsigned_char bytes, SWIGTYPE_p_float x) {
        swigfaissJNI.IndexPQ_sa_decode(this.swigCPtr, this, n, SWIGTYPE_p_unsigned_char.getCPtr(bytes), SWIGTYPE_p_float.getCPtr(x));
    }

    @Override
    public DistanceComputer get_distance_computer() {
        long cPtr = swigfaissJNI.IndexPQ_get_distance_computer(this.swigCPtr, this);
        return cPtr == 0L ? null : new DistanceComputer(cPtr, true);
    }

    public void setDo_polysemous_training(boolean value) {
        swigfaissJNI.IndexPQ_do_polysemous_training_set(this.swigCPtr, this, value);
    }

    public boolean getDo_polysemous_training() {
        return swigfaissJNI.IndexPQ_do_polysemous_training_get(this.swigCPtr, this);
    }

    public void setPolysemous_training(PolysemousTraining value) {
        swigfaissJNI.IndexPQ_polysemous_training_set(this.swigCPtr, this, PolysemousTraining.getCPtr(value), value);
    }

    public PolysemousTraining getPolysemous_training() {
        long cPtr = swigfaissJNI.IndexPQ_polysemous_training_get(this.swigCPtr, this);
        return cPtr == 0L ? null : new PolysemousTraining(cPtr, false);
    }

    public void setSearch_type(Search_type_t value) {
        swigfaissJNI.IndexPQ_search_type_set(this.swigCPtr, this, value.swigValue());
    }

    public Search_type_t getSearch_type() {
        return Search_type_t.swigToEnum(swigfaissJNI.IndexPQ_search_type_get(this.swigCPtr, this));
    }

    public void setEncode_signs(boolean value) {
        swigfaissJNI.IndexPQ_encode_signs_set(this.swigCPtr, this, value);
    }

    public boolean getEncode_signs() {
        return swigfaissJNI.IndexPQ_encode_signs_get(this.swigCPtr, this);
    }

    public void setPolysemous_ht(int value) {
        swigfaissJNI.IndexPQ_polysemous_ht_set(this.swigCPtr, this, value);
    }

    public int getPolysemous_ht() {
        return swigfaissJNI.IndexPQ_polysemous_ht_get(this.swigCPtr, this);
    }

    public void search_core_polysemous(long n, SWIGTYPE_p_float x, long k, SWIGTYPE_p_float distances, SWIGTYPE_p_long labels) {
        swigfaissJNI.IndexPQ_search_core_polysemous(this.swigCPtr, this, n, SWIGTYPE_p_float.getCPtr(x), k, SWIGTYPE_p_float.getCPtr(distances), SWIGTYPE_p_long.getCPtr(labels));
    }

    public void hamming_distance_histogram(long n, SWIGTYPE_p_float x, long nb, SWIGTYPE_p_float xb, SWIGTYPE_p_long dist_histogram) {
        swigfaissJNI.IndexPQ_hamming_distance_histogram(this.swigCPtr, this, n, SWIGTYPE_p_float.getCPtr(x), nb, SWIGTYPE_p_float.getCPtr(xb), SWIGTYPE_p_long.getCPtr(dist_histogram));
    }

    public void hamming_distance_table(long n, SWIGTYPE_p_float x, SWIGTYPE_p_int dis) {
        swigfaissJNI.IndexPQ_hamming_distance_table(this.swigCPtr, this, n, SWIGTYPE_p_float.getCPtr(x), SWIGTYPE_p_int.getCPtr(dis));
    }

    public static final class Search_type_t {
        public static final Search_type_t ST_PQ = new Search_type_t("ST_PQ");
        public static final Search_type_t ST_HE = new Search_type_t("ST_HE");
        public static final Search_type_t ST_generalized_HE = new Search_type_t("ST_generalized_HE");
        public static final Search_type_t ST_SDC = new Search_type_t("ST_SDC");
        public static final Search_type_t ST_polysemous = new Search_type_t("ST_polysemous");
        public static final Search_type_t ST_polysemous_generalize = new Search_type_t("ST_polysemous_generalize");
        private static Search_type_t[] swigValues = new Search_type_t[]{ST_PQ, ST_HE, ST_generalized_HE, ST_SDC, ST_polysemous, ST_polysemous_generalize};
        private static int swigNext = 0;
        private final int swigValue;
        private final String swigName;

        public final int swigValue() {
            return this.swigValue;
        }

        public String toString() {
            return this.swigName;
        }

        public static Search_type_t swigToEnum(int swigValue) {
            if (swigValue < swigValues.length && swigValue >= 0 && Search_type_t.swigValues[swigValue].swigValue == swigValue) {
                return swigValues[swigValue];
            }
            for (int i = 0; i < swigValues.length; ++i) {
                if (Search_type_t.swigValues[i].swigValue != swigValue) continue;
                return swigValues[i];
            }
            throw new IllegalArgumentException("No enum " + Search_type_t.class + " with value " + swigValue);
        }

        private Search_type_t(String swigName) {
            this.swigName = swigName;
            this.swigValue = swigNext++;
        }

        private Search_type_t(String swigName, int swigValue) {
            this.swigName = swigName;
            this.swigValue = swigValue;
            swigNext = swigValue + 1;
        }

        private Search_type_t(String swigName, Search_type_t swigEnum) {
            this.swigName = swigName;
            this.swigValue = swigEnum.swigValue;
            swigNext = this.swigValue + 1;
        }
    }
}

