/*
 * Decompiled with CFR 0.152.
 */
package com.vectorsearch.faiss.swig;

import com.vectorsearch.faiss.swig.FloatVector;
import com.vectorsearch.faiss.swig.ITQMatrix;
import com.vectorsearch.faiss.swig.LinearTransform;
import com.vectorsearch.faiss.swig.SWIGTYPE_p_float;
import com.vectorsearch.faiss.swig.VectorTransform;
import com.vectorsearch.faiss.swig.swigfaissJNI;

public class ITQTransform
extends VectorTransform {
    private transient long swigCPtr;

    protected ITQTransform(long cPtr, boolean cMemoryOwn) {
        super(swigfaissJNI.ITQTransform_SWIGUpcast(cPtr), cMemoryOwn);
        this.swigCPtr = cPtr;
    }

    protected static long getCPtr(ITQTransform obj) {
        return obj == null ? 0L : obj.swigCPtr;
    }

    @Override
    protected void finalize() {
        this.delete();
    }

    @Override
    public synchronized void delete() {
        if (this.swigCPtr != 0L) {
            if (this.swigCMemOwn) {
                this.swigCMemOwn = false;
                swigfaissJNI.delete_ITQTransform(this.swigCPtr);
            }
            this.swigCPtr = 0L;
        }
        super.delete();
    }

    public void setMean(FloatVector value) {
        swigfaissJNI.ITQTransform_mean_set(this.swigCPtr, this, FloatVector.getCPtr(value), value);
    }

    public FloatVector getMean() {
        long cPtr = swigfaissJNI.ITQTransform_mean_get(this.swigCPtr, this);
        return cPtr == 0L ? null : new FloatVector(cPtr, false);
    }

    public void setDo_pca(boolean value) {
        swigfaissJNI.ITQTransform_do_pca_set(this.swigCPtr, this, value);
    }

    public boolean getDo_pca() {
        return swigfaissJNI.ITQTransform_do_pca_get(this.swigCPtr, this);
    }

    public void setItq(ITQMatrix value) {
        swigfaissJNI.ITQTransform_itq_set(this.swigCPtr, this, ITQMatrix.getCPtr(value), value);
    }

    public ITQMatrix getItq() {
        long cPtr = swigfaissJNI.ITQTransform_itq_get(this.swigCPtr, this);
        return cPtr == 0L ? null : new ITQMatrix(cPtr, false);
    }

    public void setMax_train_per_dim(int value) {
        swigfaissJNI.ITQTransform_max_train_per_dim_set(this.swigCPtr, this, value);
    }

    public int getMax_train_per_dim() {
        return swigfaissJNI.ITQTransform_max_train_per_dim_get(this.swigCPtr, this);
    }

    public void setPca_then_itq(LinearTransform value) {
        swigfaissJNI.ITQTransform_pca_then_itq_set(this.swigCPtr, this, LinearTransform.getCPtr(value), value);
    }

    public LinearTransform getPca_then_itq() {
        long cPtr = swigfaissJNI.ITQTransform_pca_then_itq_get(this.swigCPtr, this);
        return cPtr == 0L ? null : new LinearTransform(cPtr, false);
    }

    public ITQTransform(int d_in, int d_out, boolean do_pca) {
        this(swigfaissJNI.new_ITQTransform__SWIG_0(d_in, d_out, do_pca), true);
    }

    public ITQTransform(int d_in, int d_out) {
        this(swigfaissJNI.new_ITQTransform__SWIG_1(d_in, d_out), true);
    }

    public ITQTransform(int d_in) {
        this(swigfaissJNI.new_ITQTransform__SWIG_2(d_in), true);
    }

    public ITQTransform() {
        this(swigfaissJNI.new_ITQTransform__SWIG_3(), true);
    }

    @Override
    public void train(long n, SWIGTYPE_p_float x) {
        swigfaissJNI.ITQTransform_train(this.swigCPtr, this, n, SWIGTYPE_p_float.getCPtr(x));
    }

    @Override
    public void apply_noalloc(long n, SWIGTYPE_p_float x, SWIGTYPE_p_float xt) {
        swigfaissJNI.ITQTransform_apply_noalloc(this.swigCPtr, this, n, SWIGTYPE_p_float.getCPtr(x), SWIGTYPE_p_float.getCPtr(xt));
    }
}

