/*
 * Decompiled with CFR 0.152.
 */
package com.vectorsearch.faiss.swig;

import com.vectorsearch.faiss.swig.IDSelector;
import com.vectorsearch.faiss.swig.InvertedLists;
import com.vectorsearch.faiss.swig.LongVector;
import com.vectorsearch.faiss.swig.SWIGTYPE_p_long;
import com.vectorsearch.faiss.swig.SWIGTYPE_p_std__unordered_mapT_long_long_t;
import com.vectorsearch.faiss.swig.SWIGTYPE_p_unsigned_char;
import com.vectorsearch.faiss.swig.swigfaissJNI;

public class DirectMap {
    private transient long swigCPtr;
    protected transient boolean swigCMemOwn;

    protected DirectMap(long cPtr, boolean cMemoryOwn) {
        this.swigCMemOwn = cMemoryOwn;
        this.swigCPtr = cPtr;
    }

    protected static long getCPtr(DirectMap obj) {
        return obj == null ? 0L : obj.swigCPtr;
    }

    protected void finalize() {
        this.delete();
    }

    public synchronized void delete() {
        if (this.swigCPtr != 0L) {
            if (this.swigCMemOwn) {
                this.swigCMemOwn = false;
                swigfaissJNI.delete_DirectMap(this.swigCPtr);
            }
            this.swigCPtr = 0L;
        }
    }

    public void setType(Type value) {
        swigfaissJNI.DirectMap_type_set(this.swigCPtr, this, value.swigValue());
    }

    public Type getType() {
        return Type.swigToEnum(swigfaissJNI.DirectMap_type_get(this.swigCPtr, this));
    }

    public void setArray(LongVector value) {
        swigfaissJNI.DirectMap_array_set(this.swigCPtr, this, LongVector.getCPtr(value), value);
    }

    public LongVector getArray() {
        long cPtr = swigfaissJNI.DirectMap_array_get(this.swigCPtr, this);
        return cPtr == 0L ? null : new LongVector(cPtr, false);
    }

    public void setHashtable(SWIGTYPE_p_std__unordered_mapT_long_long_t value) {
        swigfaissJNI.DirectMap_hashtable_set(this.swigCPtr, this, SWIGTYPE_p_std__unordered_mapT_long_long_t.getCPtr(value));
    }

    public SWIGTYPE_p_std__unordered_mapT_long_long_t getHashtable() {
        return new SWIGTYPE_p_std__unordered_mapT_long_long_t(swigfaissJNI.DirectMap_hashtable_get(this.swigCPtr, this), true);
    }

    public DirectMap() {
        this(swigfaissJNI.new_DirectMap(), true);
    }

    public void set_type(Type new_type, InvertedLists invlists, long ntotal) {
        swigfaissJNI.DirectMap_set_type(this.swigCPtr, this, new_type.swigValue(), InvertedLists.getCPtr(invlists), invlists, ntotal);
    }

    public long get(long id) {
        return swigfaissJNI.DirectMap_get(this.swigCPtr, this, id);
    }

    public boolean no() {
        return swigfaissJNI.DirectMap_no(this.swigCPtr, this);
    }

    public void check_can_add(SWIGTYPE_p_long ids) {
        swigfaissJNI.DirectMap_check_can_add(this.swigCPtr, this, SWIGTYPE_p_long.getCPtr(ids));
    }

    public void add_single_id(long id, long list_no, long offset) {
        swigfaissJNI.DirectMap_add_single_id(this.swigCPtr, this, id, list_no, offset);
    }

    public void clear() {
        swigfaissJNI.DirectMap_clear(this.swigCPtr, this);
    }

    public long remove_ids(IDSelector sel, InvertedLists invlists) {
        return swigfaissJNI.DirectMap_remove_ids(this.swigCPtr, this, IDSelector.getCPtr(sel), sel, InvertedLists.getCPtr(invlists), invlists);
    }

    public void update_codes(InvertedLists invlists, int n, SWIGTYPE_p_long ids, SWIGTYPE_p_long list_nos, SWIGTYPE_p_unsigned_char codes) {
        swigfaissJNI.DirectMap_update_codes(this.swigCPtr, this, InvertedLists.getCPtr(invlists), invlists, n, SWIGTYPE_p_long.getCPtr(ids), SWIGTYPE_p_long.getCPtr(list_nos), SWIGTYPE_p_unsigned_char.getCPtr(codes));
    }

    public static final class Type {
        public static final Type NoMap = new Type("NoMap", swigfaissJNI.DirectMap_NoMap_get());
        public static final Type Array = new Type("Array", swigfaissJNI.DirectMap_Array_get());
        public static final Type Hashtable = new Type("Hashtable", swigfaissJNI.DirectMap_Hashtable_get());
        private static Type[] swigValues = new Type[]{NoMap, Array, Hashtable};
        private static int swigNext = 0;
        private final int swigValue;
        private final String swigName;

        public final int swigValue() {
            return this.swigValue;
        }

        public String toString() {
            return this.swigName;
        }

        public static Type swigToEnum(int swigValue) {
            if (swigValue < swigValues.length && swigValue >= 0 && Type.swigValues[swigValue].swigValue == swigValue) {
                return swigValues[swigValue];
            }
            for (int i = 0; i < swigValues.length; ++i) {
                if (Type.swigValues[i].swigValue != swigValue) continue;
                return swigValues[i];
            }
            throw new IllegalArgumentException("No enum " + Type.class + " with value " + swigValue);
        }

        private Type(String swigName) {
            this.swigName = swigName;
            this.swigValue = swigNext++;
        }

        private Type(String swigName, int swigValue) {
            this.swigName = swigName;
            this.swigValue = swigValue;
            swigNext = swigValue + 1;
        }

        private Type(String swigName, Type swigEnum) {
            this.swigName = swigName;
            this.swigValue = swigEnum.swigValue;
            swigNext = this.swigValue + 1;
        }
    }
}

