/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.backends.jglfw;

import com.badlogic.gdx.ApplicationListener;
import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.Graphics;
import com.badlogic.gdx.backends.jglfw.JglfwApplicationConfiguration;
import com.badlogic.gdx.backends.jglfw.JglfwGL20;
import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.graphics.GL20;
import com.badlogic.gdx.graphics.GL30;
import com.badlogic.gdx.utils.Array;
import com.badlogic.gdx.utils.GdxRuntimeException;
import com.badlogic.jglfw.Glfw;
import com.badlogic.jglfw.GlfwVideoMode;
import com.badlogic.jglfw.gl.GL;
import java.awt.Toolkit;

public class JglfwGraphics
implements Graphics {
    static final boolean isMac = System.getProperty("os.name").contains("OS X");
    static final boolean isWindows = System.getProperty("os.name").contains("Windows");
    static final boolean isLinux = System.getProperty("os.name").contains("Linux");
    static int glMajorVersion;
    static int glMinorVersion;
    long window;
    private boolean fullscreen;
    private long fullscreenMonitor;
    private String title;
    private boolean resizable;
    private boolean undecorated;
    private Graphics.BufferFormat bufferFormat;
    private boolean vSync;
    private int x;
    private int y;
    private int width;
    private int height;
    private boolean visible;
    private Color initialBackgroundColor;
    private volatile boolean isContinuous = true;
    private volatile boolean renderRequested;
    volatile boolean foreground;
    volatile boolean minimized;
    private long frameId = -1L;
    private float deltaTime;
    private long frameStart;
    private long lastTime = -1L;
    private int frames;
    private int fps;
    private JglfwGL20 gl20;

    public JglfwGraphics(JglfwApplicationConfiguration config) {
        long[] monitors;
        this.bufferFormat = new Graphics.BufferFormat(config.r, config.g, config.b, config.a, config.depth, config.stencil, config.samples, false);
        this.title = config.title;
        this.resizable = config.resizable;
        this.undecorated = config.undecorated;
        this.x = config.x;
        this.y = config.y;
        this.vSync = config.vSync;
        this.initialBackgroundColor = config.initialBackgroundColor;
        if (config.fullscreenMonitorIndex != -1 && config.fullscreenMonitorIndex < (monitors = Glfw.glfwGetMonitors()).length) {
            this.fullscreenMonitor = monitors[config.fullscreenMonitorIndex];
        }
        if (!this.createWindow(config.width, config.height, config.fullscreen)) {
            throw new GdxRuntimeException("Unable to create window: " + config.width + "x" + config.height + ", fullscreen: " + config.fullscreen);
        }
        String version = GL.glGetString((int)7938);
        glMajorVersion = Integer.parseInt("" + version.charAt(0));
        glMinorVersion = Integer.parseInt("" + version.charAt(2));
        if (glMajorVersion <= 1) {
            throw new GdxRuntimeException("OpenGL 2.0 or higher with the FBO extension is required. OpenGL version: " + version);
        }
        if (!(glMajorVersion != 2 && !version.contains("2.1") || this.supportsExtension("GL_EXT_framebuffer_object") || this.supportsExtension("GL_ARB_framebuffer_object"))) {
            throw new GdxRuntimeException("OpenGL 2.0 or higher with the FBO extension is required. OpenGL version: " + version + ", FBO extension: false");
        }
        this.gl20 = new JglfwGL20();
        Gdx.gl = this.gl20;
        Gdx.gl20 = this.gl20;
        if (!config.hidden) {
            this.show();
        }
    }

    private boolean createWindow(int width, int height, boolean fullscreen) {
        if (fullscreen && this.fullscreenMonitor == 0L) {
            this.fullscreenMonitor = this.getWindowMonitor();
        }
        Glfw.glfwWindowHint((int)139272, (int)0);
        Glfw.glfwWindowHint((int)139271, (int)(this.resizable ? 1 : 0));
        Glfw.glfwWindowHint((int)139273, (int)(this.undecorated ? 1 : 0));
        Glfw.glfwWindowHint((int)135168, (int)this.bufferFormat.r);
        Glfw.glfwWindowHint((int)135169, (int)this.bufferFormat.g);
        Glfw.glfwWindowHint((int)135170, (int)this.bufferFormat.b);
        Glfw.glfwWindowHint((int)135171, (int)this.bufferFormat.a);
        Glfw.glfwWindowHint((int)135172, (int)this.bufferFormat.depth);
        Glfw.glfwWindowHint((int)135173, (int)this.bufferFormat.stencil);
        Glfw.glfwWindowHint((int)135180, (int)this.bufferFormat.samples);
        boolean mouseCaptured = this.window != 0L && Glfw.glfwGetInputMode((long)this.window, (int)196609) == 262147;
        long oldWindow = this.window;
        long newWindow = Glfw.glfwCreateWindow((int)width, (int)height, (String)this.title, (long)(fullscreen ? this.fullscreenMonitor : 0L), (long)oldWindow);
        if (newWindow == 0L) {
            return false;
        }
        if (oldWindow != 0L) {
            Glfw.glfwDestroyWindow((long)oldWindow);
        }
        this.window = newWindow;
        this.width = Math.max(1, width);
        this.height = Math.max(1, height);
        this.fullscreen = fullscreen;
        if (!fullscreen) {
            if (this.x == -1 || this.y == -1) {
                Graphics.DisplayMode mode = this.getDesktopDisplayMode();
                this.x = (mode.width - width) / 2;
                this.y = (mode.height - height) / 2;
            }
            Glfw.glfwSetWindowPos((long)this.window, (int)this.x, (int)this.y);
        }
        if (!mouseCaptured) {
            Glfw.glfwSetInputMode((long)this.window, (int)196609, (int)262145);
        }
        Glfw.glfwMakeContextCurrent((long)newWindow);
        this.setVSync(this.vSync);
        if (this.visible) {
            Glfw.glfwShowWindow((long)this.window);
        }
        return true;
    }

    void frameStart(long time) {
        if (this.lastTime == -1L) {
            this.lastTime = time;
        }
        this.deltaTime = (float)(time - this.lastTime) / 1.0E9f;
        this.lastTime = time;
        if (time - this.frameStart >= 1000000000L) {
            this.fps = this.frames;
            this.frames = 0;
            this.frameStart = time;
        }
        ++this.frames;
        ++this.frameId;
    }

    void sizeChanged(int width, int height) {
        if (isMac) {
            Glfw.glfwShowWindow((long)this.window);
        }
        width = Math.max(1, width);
        height = Math.max(1, height);
        this.width = width;
        this.height = height;
        Gdx.gl.glViewport(0, 0, width, height);
        ApplicationListener listener = Gdx.app.getApplicationListener();
        if (listener != null) {
            listener.resize(width, height);
        }
        this.requestRendering();
    }

    void positionChanged(int x, int y) {
        this.x = x;
        this.y = y;
    }

    public boolean isGL20Available() {
        return this.gl20 != null;
    }

    public GL20 getGL20() {
        return this.gl20;
    }

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }

    public long getFrameId() {
        return this.frameId;
    }

    public float getDeltaTime() {
        return this.deltaTime;
    }

    public float getRawDeltaTime() {
        return this.deltaTime;
    }

    public int getFramesPerSecond() {
        return this.fps;
    }

    public Graphics.GraphicsType getType() {
        return Graphics.GraphicsType.JGLFW;
    }

    public float getPpiX() {
        return Toolkit.getDefaultToolkit().getScreenResolution();
    }

    public float getPpiY() {
        return Toolkit.getDefaultToolkit().getScreenResolution();
    }

    public float getPpcX() {
        return (float)Toolkit.getDefaultToolkit().getScreenResolution() / 2.54f;
    }

    public float getPpcY() {
        return (float)Toolkit.getDefaultToolkit().getScreenResolution() / 2.54f;
    }

    public float getDensity() {
        return (float)Toolkit.getDefaultToolkit().getScreenResolution() / 160.0f;
    }

    public boolean supportsDisplayModeChange() {
        return true;
    }

    private long getWindowMonitor() {
        long monitor;
        if (this.window != 0L && (monitor = Glfw.glfwGetWindowMonitor((long)this.window)) != 0L) {
            return monitor;
        }
        return Glfw.glfwGetPrimaryMonitor();
    }

    public Graphics.DisplayMode[] getDisplayModes() {
        Array modes = new Array();
        for (GlfwVideoMode mode : Glfw.glfwGetVideoModes((long)this.getWindowMonitor())) {
            modes.add((Object)new JglfwDisplayMode(mode.width, mode.height, 0, mode.redBits + mode.greenBits + mode.blueBits));
        }
        return (Graphics.DisplayMode[])modes.toArray(Graphics.DisplayMode.class);
    }

    public Graphics.DisplayMode getDesktopDisplayMode() {
        GlfwVideoMode mode = Glfw.glfwGetVideoMode((long)this.getWindowMonitor());
        return new JglfwDisplayMode(mode.width, mode.height, 0, mode.redBits + mode.greenBits + mode.blueBits);
    }

    public boolean setDisplayMode(Graphics.DisplayMode displayMode) {
        this.bufferFormat = new Graphics.BufferFormat(displayMode.bitsPerPixel == 16 ? 5 : 8, displayMode.bitsPerPixel == 16 ? 6 : 8, displayMode.bitsPerPixel == 16 ? 6 : 8, this.bufferFormat.a, this.bufferFormat.depth, this.bufferFormat.stencil, this.bufferFormat.samples, false);
        boolean success = this.createWindow(displayMode.width, displayMode.height, this.fullscreen);
        if (success && this.fullscreen) {
            this.sizeChanged(displayMode.width, displayMode.height);
        }
        return success;
    }

    public boolean setDisplayMode(int width, int height, boolean fullscreen) {
        if (fullscreen || this.fullscreen) {
            boolean success = this.createWindow(width, height, fullscreen);
            if (success && fullscreen) {
                this.sizeChanged(width, height);
            }
            return success;
        }
        Glfw.glfwSetWindowSize((long)this.window, (int)width, (int)height);
        return true;
    }

    public void setTitle(String title) {
        if (title == null) {
            title = "";
        }
        Glfw.glfwSetWindowTitle((long)this.window, (String)title);
        this.title = title;
    }

    public void setVSync(boolean vsync) {
        this.vSync = vsync;
        Glfw.glfwSwapInterval((int)(vsync ? 1 : 0));
    }

    public Graphics.BufferFormat getBufferFormat() {
        return this.bufferFormat;
    }

    public boolean supportsExtension(String extension) {
        return Glfw.glfwExtensionSupported((String)extension);
    }

    public void setContinuousRendering(boolean isContinuous) {
        this.isContinuous = isContinuous;
    }

    public boolean isContinuousRendering() {
        return this.isContinuous;
    }

    public void requestRendering() {
        this.renderRequested = true;
    }

    public boolean isFullscreen() {
        return this.fullscreen;
    }

    public long getWindow() {
        return this.window;
    }

    public int getX() {
        return this.x;
    }

    public int getY() {
        return this.y;
    }

    public void setPosition(int x, int y) {
        Glfw.glfwSetWindowPos((long)this.window, (int)x, (int)y);
    }

    public void hide() {
        this.visible = false;
        Glfw.glfwHideWindow((long)this.window);
    }

    public void show() {
        this.visible = true;
        Glfw.glfwShowWindow((long)this.window);
        Gdx.gl.glClearColor(this.initialBackgroundColor.r, this.initialBackgroundColor.g, this.initialBackgroundColor.b, this.initialBackgroundColor.a);
        Gdx.gl.glClear(16384);
        Glfw.glfwSwapBuffers((long)this.window);
    }

    public boolean isHidden() {
        return !this.visible;
    }

    public boolean isMinimized() {
        return this.minimized;
    }

    public boolean isForeground() {
        return this.foreground;
    }

    public void minimize() {
        Glfw.glfwIconifyWindow((long)this.window);
    }

    public void restore() {
        Glfw.glfwRestoreWindow((long)this.window);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean shouldRender() {
        try {
            boolean bl = this.renderRequested || this.isContinuous;
            return bl;
        }
        finally {
            this.renderRequested = false;
        }
    }

    public boolean isGL30Available() {
        return false;
    }

    public GL30 getGL30() {
        return null;
    }

    static class JglfwDisplayMode
    extends Graphics.DisplayMode {
        protected JglfwDisplayMode(int width, int height, int refreshRate, int bitsPerPixel) {
            super(width, height, refreshRate, bitsPerPixel);
        }
    }
}

