/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.backends.jglfw;

import com.badlogic.gdx.Files;
import com.badlogic.gdx.backends.jglfw.JglfwFiles;
import com.badlogic.gdx.files.FileHandle;
import com.badlogic.gdx.utils.GdxRuntimeException;
import java.io.File;

public final class JglfwFileHandle
extends FileHandle {
    public JglfwFileHandle(String fileName, Files.FileType type) {
        super(fileName, type);
    }

    public JglfwFileHandle(File file, Files.FileType type) {
        super(file, type);
    }

    public FileHandle child(String name) {
        if (this.file.getPath().length() == 0) {
            return new JglfwFileHandle(new File(name), this.type);
        }
        return new JglfwFileHandle(new File(this.file, name), this.type);
    }

    public FileHandle sibling(String name) {
        if (this.file.getPath().length() == 0) {
            throw new GdxRuntimeException("Cannot get the sibling of the root.");
        }
        return new JglfwFileHandle(new File(this.file.getParent(), name), this.type);
    }

    public FileHandle parent() {
        File parent = this.file.getParentFile();
        if (parent == null) {
            parent = this.type == Files.FileType.Absolute ? new File("/") : new File("");
        }
        return new JglfwFileHandle(parent, this.type);
    }

    public File file() {
        if (this.type == Files.FileType.External) {
            return new File(JglfwFiles.externalPath, this.file.getPath());
        }
        if (this.type == Files.FileType.Local) {
            return new File(JglfwFiles.localPath, this.file.getPath());
        }
        return this.file;
    }
}

