/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.util.concurrent.atomic;

import com.atlassian.util.concurrent.Function;
import com.atlassian.util.concurrent.Supplier;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AtomicReference<V>
extends java.util.concurrent.atomic.AtomicReference<V> {
    public AtomicReference() {
    }

    public AtomicReference(V initialValue) {
        super(initialValue);
    }

    public final V getOrSetAndGetIf(V oldValue, Supplier<V> newValue) {
        Object result = this.get();
        while (result == oldValue) {
            V update = newValue.get();
            if (update == oldValue) {
                return oldValue;
            }
            this.compareAndSet(oldValue, update);
            result = this.get();
        }
        return result;
    }

    public final V getOrSetAndGetIf(V oldValue, V newValue) {
        Object result = this.get();
        while (result == oldValue) {
            if (result == newValue) {
                return result;
            }
            this.compareAndSet(oldValue, newValue);
            result = this.get();
        }
        return result;
    }

    public final V update(Function<V, V> newValueFactory) {
        V newValue;
        Object oldValue;
        do {
            oldValue = this.get();
            newValue = newValueFactory.get(oldValue);
            if (this.get() == oldValue) continue;
        } while (!this.compareAndSet(oldValue, newValue));
        return newValue;
    }
}

