/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.webdriver.waiter.webdriver;

import com.atlassian.annotations.ExperimentalApi;
import com.atlassian.webdriver.waiter.ExecutableWaiterQuery;
import com.atlassian.webdriver.waiter.Query;
import com.atlassian.webdriver.waiter.StringValueQuery;
import com.atlassian.webdriver.waiter.webdriver.WebDriverQueryBuilder;
import com.atlassian.webdriver.waiter.webdriver.WebDriverWaiterQuery;
import com.atlassian.webdriver.waiter.webdriver.function.ConditionFunction;
import com.atlassian.webdriver.waiter.webdriver.function.NotFunction;
import com.atlassian.webdriver.waiter.webdriver.function.field.ContainsFunction;
import com.atlassian.webdriver.waiter.webdriver.function.field.EndsWithFunction;
import com.atlassian.webdriver.waiter.webdriver.function.field.EqualsIgnoresCaseFunction;
import com.atlassian.webdriver.waiter.webdriver.function.field.IsEmptyFunction;
import com.atlassian.webdriver.waiter.webdriver.function.field.IsEqualFunction;
import com.atlassian.webdriver.waiter.webdriver.function.field.MatchesFunction;
import com.atlassian.webdriver.waiter.webdriver.function.field.StartsWithFunction;
import com.atlassian.webdriver.waiter.webdriver.retriever.WebElementFieldRetriever;

@ExperimentalApi
public class WebDriverFieldQuery
implements StringValueQuery {
    private final WebDriverQueryBuilder queryBuilder;
    private final WebElementFieldRetriever fieldRetriever;

    public WebDriverFieldQuery(WebDriverQueryBuilder queryBuilder, WebElementFieldRetriever fieldRetriever) {
        this.queryBuilder = queryBuilder;
        this.fieldRetriever = fieldRetriever;
    }

    @Override
    public ExecutableWaiterQuery contains(String value) {
        return this.createExecutableWaiterQuery(new ContainsFunction(this.fieldRetriever, value));
    }

    @Override
    public ExecutableWaiterQuery notContains(String value) {
        return this.createExecutableWaiterQuery(this.not(new ContainsFunction(this.fieldRetriever, value)));
    }

    @Override
    public ExecutableWaiterQuery isEqual(String value) {
        return this.createExecutableWaiterQuery(new IsEqualFunction(this.fieldRetriever, value));
    }

    @Override
    public ExecutableWaiterQuery notEqual(String value) {
        return this.createExecutableWaiterQuery(this.not(new IsEqualFunction(this.fieldRetriever, value)));
    }

    @Override
    public ExecutableWaiterQuery isEmpty() {
        return this.createExecutableWaiterQuery(new IsEmptyFunction(this.fieldRetriever));
    }

    @Override
    public ExecutableWaiterQuery isNotEmpty() {
        return this.createExecutableWaiterQuery(this.not(new IsEmptyFunction(this.fieldRetriever)));
    }

    @Override
    public ExecutableWaiterQuery endsWith(String value) {
        return this.createExecutableWaiterQuery(new EndsWithFunction(this.fieldRetriever, value));
    }

    @Override
    public ExecutableWaiterQuery doesNotEndWith(String value) {
        return this.createExecutableWaiterQuery(this.not(new EndsWithFunction(this.fieldRetriever, value)));
    }

    @Override
    public ExecutableWaiterQuery matches(String value) {
        return this.createExecutableWaiterQuery(new MatchesFunction(this.fieldRetriever, value));
    }

    @Override
    public ExecutableWaiterQuery doesNotMatch(String value) {
        return this.createExecutableWaiterQuery(this.not(new MatchesFunction(this.fieldRetriever, value)));
    }

    @Override
    public ExecutableWaiterQuery startsWith(String value) {
        return this.createExecutableWaiterQuery(new StartsWithFunction(this.fieldRetriever, value));
    }

    @Override
    public ExecutableWaiterQuery doesNotStartWith(String value) {
        return this.createExecutableWaiterQuery(this.not(new StartsWithFunction(this.fieldRetriever, value)));
    }

    @Override
    public ExecutableWaiterQuery equalsIgnoresCase(String value) {
        return this.createExecutableWaiterQuery(new EqualsIgnoresCaseFunction(this.fieldRetriever, value));
    }

    private NotFunction not(ConditionFunction func) {
        return new NotFunction(func);
    }

    private ExecutableWaiterQuery createExecutableWaiterQuery(final ConditionFunction func) {
        this.queryBuilder.add(new Query(){

            @Override
            public ConditionFunction build() {
                return func;
            }
        });
        return new WebDriverWaiterQuery.WebDriverExecutableWaiterQuery(this.queryBuilder);
    }
}

