/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.webdriver.waiter.webdriver;

import com.atlassian.annotations.ExperimentalApi;
import com.atlassian.webdriver.waiter.ElementQuery;
import com.atlassian.webdriver.waiter.ExecutableWaiterQuery;
import com.atlassian.webdriver.waiter.Query;
import com.atlassian.webdriver.waiter.StringValueQuery;
import com.atlassian.webdriver.waiter.webdriver.WebDriverFieldQuery;
import com.atlassian.webdriver.waiter.webdriver.WebDriverQueryBuilder;
import com.atlassian.webdriver.waiter.webdriver.WebDriverWaiterQuery;
import com.atlassian.webdriver.waiter.webdriver.function.ConditionFunction;
import com.atlassian.webdriver.waiter.webdriver.function.NotFunction;
import com.atlassian.webdriver.waiter.webdriver.function.element.ExistsFunction;
import com.atlassian.webdriver.waiter.webdriver.function.element.HasClassFunction;
import com.atlassian.webdriver.waiter.webdriver.function.element.IsEnabledFunction;
import com.atlassian.webdriver.waiter.webdriver.function.element.IsSelectedFunction;
import com.atlassian.webdriver.waiter.webdriver.function.element.IsVisibleFunction;
import com.atlassian.webdriver.waiter.webdriver.retriever.WebElementFieldRetriever;
import com.atlassian.webdriver.waiter.webdriver.retriever.WebElementRetriever;

@ExperimentalApi
public class WebDriverElementQuery
implements ElementQuery {
    private final WebDriverQueryBuilder builder;
    private final WebElementRetriever webElementRetriever;

    public WebDriverElementQuery(WebDriverQueryBuilder builder, WebElementRetriever webElementRetriever) {
        this.builder = builder;
        this.webElementRetriever = webElementRetriever;
    }

    @Override
    public ExecutableWaiterQuery isVisible() {
        return this.createExecutableWaiterQuery(new IsVisibleFunction(this.webElementRetriever));
    }

    @Override
    public ExecutableWaiterQuery isNotVisible() {
        return this.createExecutableWaiterQuery(this.not(new IsVisibleFunction(this.webElementRetriever)));
    }

    @Override
    public ExecutableWaiterQuery exists() {
        return this.createExecutableWaiterQuery(new ExistsFunction(this.webElementRetriever));
    }

    @Override
    public ExecutableWaiterQuery doesNotExist() {
        return this.createExecutableWaiterQuery(this.not(new ExistsFunction(this.webElementRetriever)));
    }

    @Override
    public StringValueQuery getAttribute(String attributeName) {
        return new WebDriverFieldQuery(this.builder, WebElementFieldRetriever.newAttributeRetriever(this.webElementRetriever, attributeName));
    }

    @Override
    public ExecutableWaiterQuery isSelected() {
        return this.createExecutableWaiterQuery(new IsSelectedFunction(this.webElementRetriever));
    }

    @Override
    public ExecutableWaiterQuery isNotSelected() {
        return this.createExecutableWaiterQuery(this.not(new IsSelectedFunction(this.webElementRetriever)));
    }

    @Override
    public ExecutableWaiterQuery isEnabled() {
        return this.createExecutableWaiterQuery(new IsEnabledFunction(this.webElementRetriever));
    }

    @Override
    public ExecutableWaiterQuery isNotEnabled() {
        return this.createExecutableWaiterQuery(this.not(new IsEnabledFunction(this.webElementRetriever)));
    }

    @Override
    public ExecutableWaiterQuery hasClass(String className) {
        return this.createExecutableWaiterQuery(new HasClassFunction(this.webElementRetriever, className));
    }

    @Override
    public ExecutableWaiterQuery doesNotHaveClass(String className) {
        return this.createExecutableWaiterQuery(this.not(new HasClassFunction(this.webElementRetriever, className)));
    }

    @Override
    public StringValueQuery getText() {
        return new WebDriverFieldQuery(this.builder, WebElementFieldRetriever.newTextRetriever(this.webElementRetriever));
    }

    private ConditionFunction not(ConditionFunction func) {
        return new NotFunction(func);
    }

    private ExecutableWaiterQuery createExecutableWaiterQuery(final ConditionFunction function) {
        this.builder.add(new Query(){

            @Override
            public ConditionFunction build() {
                return function;
            }
        });
        return new WebDriverWaiterQuery.WebDriverExecutableWaiterQuery(this.builder);
    }
}

