/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.webdriver.utils.element;

import com.atlassian.webdriver.utils.Check;
import org.apache.commons.lang.Validate;
import org.openqa.selenium.By;
import org.openqa.selenium.SearchContext;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.support.ui.ExpectedCondition;

abstract class ElementVisibilityCondition
implements ExpectedCondition<Boolean> {
    private final By by;
    private final SearchContext at;
    private final Visibility visibility;

    ElementVisibilityCondition(By by, Visibility visibility) {
        this(by, null, visibility);
    }

    ElementVisibilityCondition(By by, SearchContext el, Visibility visibility) {
        Validate.notNull((Object)by, (String)"by cannot be null.");
        this.by = by;
        this.at = el;
        this.visibility = visibility;
    }

    public final Boolean apply(WebDriver webDriver) {
        if (this.visibility.equals((Object)Visibility.VISIBLE)) {
            return Check.elementIsVisible(this.by, (SearchContext)(this.at == null ? webDriver : this.at));
        }
        return !Check.elementIsVisible(this.by, (SearchContext)(this.at == null ? webDriver : this.at));
    }

    public String toString() {
        return String.format("Condition: [state=%s,what=%s,where=%s]", new Object[]{this.visibility, this.by, this.at});
    }

    static enum Visibility {
        VISIBLE,
        NOTVISIBLE;

    }
}

