/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.webdriver.utils.by;

import com.atlassian.webdriver.LifecycleAwareWebDriverGrid;
import com.atlassian.webdriver.utils.JavaScriptUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.Validate;
import org.openqa.selenium.By;
import org.openqa.selenium.NoSuchElementException;
import org.openqa.selenium.SearchContext;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebElement;

public abstract class ByJquery
extends By {
    private final Pattern SIMPLE_SELECTOR_PATTERN = Pattern.compile("^([#]|[.]|[a-zA-Z])[\\w-]+(\\s[^~]*)?$");
    private final Pattern ID_SELECTOR = Pattern.compile("^#(\\S+)(\\s?.*)$");
    private final Pattern CLASSNAME_SELECTOR = Pattern.compile("^[.](\\S+)(\\s?.*)$");
    private final Pattern TAGNAME_SELECTOR = Pattern.compile("^([A-Za-z]\\w+)(\\s?.*)$");
    private final List<Selector> selectors = new ArrayList<Selector>();

    private ByJquery(String selector, SelectorType type) {
        this.selectors.add(new Selector(selector, type));
    }

    private ByJquery() {
    }

    List<WebElement> findElementsWithSelectors(SearchContext context) {
        List<Object> elements = new ArrayList<WebElement>();
        block5: for (Selector selector : this.selectors) {
            String selectorStr = this.fixSelector(selector.getSelector());
            switch (selector.type) {
                case FIND: {
                    if (elements.isEmpty()) {
                        elements = this.$findElements(selector.getSelector(), context);
                        continue block5;
                    }
                    elements = this.$findElements(selector.getSelector(), elements);
                    continue block5;
                }
                case PARENT: 
                case SIBLINGS: 
                case PARENTS: 
                case CHILDREN: 
                case PREV: 
                case CLOSEST: {
                    Object[] args = new Object[]{"ATLWD.$(context)." + selector.type.name().toLowerCase() + "(" + selectorStr + ")", elements};
                    elements = (List)JavaScriptUtils.execute("return ATLWD.byJquery.execute(arguments[0],arguments[1])", LifecycleAwareWebDriverGrid.getDriver(), args);
                    continue block5;
                }
                case FILTER: {
                    Object[] args = new Object[]{"ATLWD.$(context)." + selector.type.name().toLowerCase() + "(" + selector.getSelector() + ")", elements};
                    elements = (List)JavaScriptUtils.execute("return ATLWD.byJquery.execute(arguments[0],arguments[1])", LifecycleAwareWebDriverGrid.getDriver(), args);
                    continue block5;
                }
            }
            throw new UnsupportedOperationException("Unknown selector type: " + (Object)((Object)selector.type));
        }
        return elements;
    }

    private String fixSelector(String selector) {
        return selector == null ? "" : "'" + selector.replaceAll("'", "\"") + "'";
    }

    private boolean isSimpleSelector(String selector) {
        return this.SIMPLE_SELECTOR_PATTERN.matcher(selector).matches();
    }

    private List<WebElement> executeMatcher(Matcher matcher, SearchContext context, By by) {
        if (matcher.matches()) {
            if (StringUtils.isEmpty((String)matcher.group(2))) {
                return context.findElements(by);
            }
            return this.$findElements(matcher.group(2), context.findElements(by));
        }
        throw new IllegalStateException("ID Selector failed match");
    }

    private List<WebElement> executeIdMatcher(Matcher matcher, SearchContext context) {
        if (matcher.find()) {
            return this.executeMatcher(matcher, context, By.id((String)matcher.group(1)));
        }
        throw new IllegalArgumentException("Invalid matcher.");
    }

    private List<WebElement> executeClassNameMatcher(Matcher matcher, SearchContext context) {
        if (matcher.find()) {
            return this.executeMatcher(matcher, context, By.className((String)matcher.group(1)));
        }
        throw new IllegalArgumentException("Invalid matcher.");
    }

    private List<WebElement> executeTagNameMatcher(Matcher matcher, SearchContext context) {
        if (matcher.find()) {
            return this.executeMatcher(matcher, context, By.tagName((String)matcher.group(1)));
        }
        throw new IllegalArgumentException("Invalid matcher.");
    }

    private List<WebElement> executeSimpleSelector(String selector, SearchContext context) {
        if (selector.startsWith("#")) {
            Matcher matcher = this.ID_SELECTOR.matcher(selector);
            return this.executeIdMatcher(matcher, context);
        }
        if (selector.startsWith(".")) {
            Matcher matcher = this.CLASSNAME_SELECTOR.matcher(selector);
            return this.executeClassNameMatcher(matcher, context);
        }
        Matcher matcher = this.TAGNAME_SELECTOR.matcher(selector);
        return this.executeTagNameMatcher(matcher, context);
    }

    List<WebElement> $findElements(String selector, SearchContext context) {
        if (this.isSimpleSelector(selector)) {
            return this.executeSimpleSelector(selector, context);
        }
        String fixedSelector = this.fixSelector(selector);
        if (context instanceof WebElement) {
            Object[] args = new Object[]{"ATLWD.$(context).find(" + fixedSelector + ")", (WebElement)context};
            return (List)JavaScriptUtils.execute("return ATLWD.byJquery.execute(arguments[0],arguments[1])", LifecycleAwareWebDriverGrid.getDriver(), args);
        }
        Object[] args = new Object[]{"ATLWD.$(document).find(" + fixedSelector + ")"};
        return (List)JavaScriptUtils.execute("return ATLWD.byJquery.execute(arguments[0])", LifecycleAwareWebDriverGrid.getDriver(), args);
    }

    List<WebElement> $findElements(String selector, List<WebElement> els) {
        ArrayList<WebElement> newElements = new ArrayList<WebElement>();
        for (WebElement element : els) {
            Object[] args = new Object[]{"ATLWD.$(context).find(" + this.fixSelector(selector) + ")", element};
            List temp = (List)JavaScriptUtils.execute("return ATLWD.byJquery.execute(arguments[0],arguments[1])", LifecycleAwareWebDriverGrid.getDriver(), args);
            newElements.addAll(temp);
        }
        return newElements;
    }

    public static ByJquery $(final WebElement element) {
        ByJquery.loadJqueryLocator(LifecycleAwareWebDriverGrid.getDriver());
        return new ByJquery(){

            public List<WebElement> findElements(SearchContext context) {
                return this.findElementsWithSelectors((SearchContext)element);
            }

            @Override
            public WebElement findElement(SearchContext context) {
                List<WebElement> els = this.findElementsWithSelectors((SearchContext)element);
                if (!els.isEmpty()) {
                    return els.get(0);
                }
                throw new NoSuchElementException("Element not found by jQuery.");
            }
        };
    }

    public static ByJquery $(final String selector) {
        if (selector == null) {
            throw new IllegalArgumentException("The jquery selector cannot be null.");
        }
        ByJquery.loadJqueryLocator(LifecycleAwareWebDriverGrid.getDriver());
        return new ByJquery(selector, SelectorType.FIND){

            public List<WebElement> findElements(SearchContext context) {
                return this.findElementsWithSelectors(context);
            }

            @Override
            public WebElement findElement(SearchContext context) {
                List<WebElement> els = this.findElementsWithSelectors(context);
                if (!els.isEmpty()) {
                    return els.get(0);
                }
                throw new NoSuchElementException(this.toString());
            }

            public String toString() {
                return "jQuery selector: " + selector;
            }
        };
    }

    private void addSelector(Selector selector) {
        this.selectors.add(selector);
    }

    public ByJquery find(String selector) {
        Validate.notNull((Object)selector, (String)"The find selector cannot be null");
        this.addSelector(new Selector(selector, SelectorType.FIND));
        return this;
    }

    public ByJquery parent() {
        return this.parent(null);
    }

    public ByJquery parent(String selector) {
        this.addSelector(new Selector(selector, SelectorType.PARENT));
        return this;
    }

    public ByJquery parents() {
        return this.parents(null);
    }

    public ByJquery parents(String selector) {
        this.addSelector(new Selector(selector, SelectorType.PARENTS));
        return this;
    }

    public ByJquery siblings() {
        return this.siblings(null);
    }

    public ByJquery siblings(String selector) {
        this.addSelector(new Selector(selector, SelectorType.SIBLINGS));
        return this;
    }

    public ByJquery children() {
        return this.children(null);
    }

    public ByJquery children(String selector) {
        this.addSelector(new Selector(selector, SelectorType.CHILDREN));
        return this;
    }

    public ByJquery prev() {
        return this.prev(null);
    }

    public ByJquery prev(String selector) {
        this.addSelector(new Selector(selector, SelectorType.PREV));
        return this;
    }

    public ByJquery closest(String selector) {
        this.addSelector(new Selector(selector, SelectorType.CLOSEST));
        return this;
    }

    public ByJquery filter(String selector) {
        this.addSelector(new Selector(selector, SelectorType.FILTER));
        return this;
    }

    public WebElement findElement(SearchContext context) {
        List allElements = this.findElements(context);
        if (allElements == null || allElements.size() == 0) {
            throw new NoSuchElementException("Cannot locate an element using " + this.toString());
        }
        return (WebElement)allElements.get(0);
    }

    private static void loadJqueryLocator(WebDriver driver) {
        JavaScriptUtils.loadScript("js/byjquery/byJquery.js", driver);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        By by = (By)o;
        return this.toString().equals(by.toString());
    }

    public int hashCode() {
        return this.toString().hashCode();
    }

    private class Selector {
        private final String selector;
        private final SelectorType type;

        public Selector(String selector, SelectorType type) {
            this.selector = selector;
            this.type = type;
        }

        public String getSelector() {
            return this.selector;
        }

        public SelectorType getType() {
            return this.type;
        }
    }

    private static enum SelectorType {
        FIND,
        PARENT,
        PARENTS,
        SIBLINGS,
        CHILDREN,
        PREV,
        CLOSEST,
        FILTER;

    }
}

