/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.webdriver.utils.by;

import java.util.List;
import org.openqa.selenium.By;
import org.openqa.selenium.SearchContext;
import org.openqa.selenium.WebElement;

public final class ByDataAttribute {
    private ByDataAttribute() {
        throw new AssertionError((Object)"Don't instantiate me");
    }

    public static By byData(final String attributeName) {
        return new ByData(){

            public List<WebElement> findElements(SearchContext context) {
                return context.findElements(By.cssSelector((String)String.format("*[data-%s]", attributeName)));
            }
        };
    }

    public static By byData(final String attributeName, final String attributeValue) {
        return new ByData(){

            public List<WebElement> findElements(SearchContext context) {
                return context.findElements(By.cssSelector((String)String.format("*[data-%s=\"%s\"]", attributeName, attributeValue)));
            }
        };
    }

    public static By byTagAndData(final String tagName, final String dataAttributeName) {
        return new ByData(){

            public List<WebElement> findElements(SearchContext context) {
                return context.findElements(By.cssSelector((String)String.format("%s[data-%s]", tagName, dataAttributeName)));
            }
        };
    }

    public static By byTagAndData(final String tagName, final String dataAttributeName, final String dataAttributeValue) {
        return new ByData(){

            public List<WebElement> findElements(SearchContext context) {
                return context.findElements(By.cssSelector((String)String.format("%s[data-%s=\"%s\"]", tagName, dataAttributeName, dataAttributeValue)));
            }
        };
    }

    private static abstract class ByData
    extends By {
        private ByData() {
        }

        public String toString() {
            return "ByData";
        }
    }
}

