/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.webdriver.testing.runner;

import com.atlassian.pageobjects.TestedProduct;
import com.atlassian.pageobjects.TestedProductFactory;
import com.atlassian.pageobjects.util.InjectingTestedProducts;
import com.atlassian.util.concurrent.LazyReference;
import com.atlassian.webdriver.testing.annotation.TestedProductClass;
import com.atlassian.webdriver.testing.runner.AbstractProductContextRunner;
import org.junit.runners.model.InitializationError;

public class ProductContextRunner
extends AbstractProductContextRunner {
    private final Class<? extends TestedProduct<?>> productClass;
    private final LazyReference<TestedProduct<?>> product;

    public ProductContextRunner(Class<?> klass) throws InitializationError {
        super(klass);
        this.productClass = this.validateAndGetProductClass(klass);
        this.product = new LazyReference<TestedProduct<?>>(){

            protected TestedProduct<?> create() throws Exception {
                TestedProduct<?> theProduct = ProductContextRunner.this.createProduct(ProductContextRunner.this.productClass);
                if (!InjectingTestedProducts.supportsInjection(theProduct)) {
                    throw new AssertionError((Object)("TestedProduct instance " + theProduct.getClass().getName() + " does not support injection"));
                }
                return theProduct;
            }
        };
    }

    protected TestedProduct<?> createProduct(Class<? extends TestedProduct<?>> testedProductClass) {
        return TestedProductFactory.create(testedProductClass);
    }

    private Class<? extends TestedProduct<?>> validateAndGetProductClass(Class<?> testClass) throws InitializationError {
        TestedProductClass testedProductClass = testClass.getAnnotation(TestedProductClass.class);
        if (testedProductClass == null) {
            throw new InitializationError("Test class " + testClass.getName() + " is missing the " + TestedProductClass.class.getName() + " annotation");
        }
        return testedProductClass.value();
    }

    @Override
    protected final TestedProduct<?> getProduct() {
        return (TestedProduct)this.product.get();
    }
}

