/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.webdriver.testing.rule;

import com.atlassian.webdriver.AtlassianWebDriver;
import com.atlassian.webdriver.browsers.WebDriverBrowserAutoInstall;
import com.google.common.base.Preconditions;
import com.google.common.base.Supplier;
import com.google.common.base.Suppliers;
import javax.annotation.Nonnull;
import org.openqa.selenium.WebDriver;

public final class WebDriverSupport<WD extends WebDriver> {
    private final Supplier<? extends WD> driverSupplier;

    public static WebDriverSupport<AtlassianWebDriver> fromAutoInstall() {
        return new WebDriverSupport<AtlassianWebDriver>(WebDriverBrowserAutoInstall.driverSupplier());
    }

    public static <VE extends WebDriver> WebDriverSupport<VE> forSupplier(Supplier<? extends VE> driverSupplier) {
        return new WebDriverSupport<VE>(driverSupplier);
    }

    public static <VE extends WebDriver> WebDriverSupport<VE> forInstance(VE webDriver) {
        return new WebDriverSupport(Suppliers.ofInstance((Object)Preconditions.checkNotNull(webDriver, (Object)"webDriver")));
    }

    private WebDriverSupport(@Nonnull Supplier<? extends WD> driverSupplier) {
        this.driverSupplier = Suppliers.memoize((Supplier)((Supplier)Preconditions.checkNotNull(driverSupplier, (Object)"driverSupplier")));
    }

    @Nonnull
    public final WD getDriver() {
        return (WD)((WebDriver)this.driverSupplier.get());
    }
}

