/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.webdriver.testing.rule;

import com.atlassian.webdriver.WebDriverFactory;
import com.atlassian.webdriver.testing.annotation.TestBrowser;
import org.junit.rules.TestRule;
import org.junit.runner.Description;
import org.junit.runners.model.Statement;

public class TestBrowserRule
implements TestRule {
    private static String originalBrowserValue = WebDriverFactory.getBrowserProperty();

    public Statement apply(final Statement base, final Description description) {
        return new Statement(){

            public void evaluate() throws Throwable {
                TestBrowser testBrowser = TestBrowserRule.this.getTestBrowserAnnotation(description);
                if (testBrowser != null) {
                    System.setProperty("webdriver.browser", testBrowser.value());
                } else {
                    System.setProperty("webdriver.browser", originalBrowserValue);
                }
                base.evaluate();
            }
        };
    }

    private TestBrowser getTestBrowserAnnotation(Description description) {
        TestBrowser methodTestBrowser = description.isTest() ? (TestBrowser)description.getAnnotation(TestBrowser.class) : null;
        TestBrowser classTestBrowser = description.getTestClass().getAnnotation(TestBrowser.class);
        TestBrowser packageTestBrowser = description.getTestClass().getPackage().getAnnotation(TestBrowser.class);
        return methodTestBrowser != null ? methodTestBrowser : (classTestBrowser != null ? classTestBrowser : packageTestBrowser);
    }
}

