/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.webdriver.testing.rule;

import com.atlassian.webdriver.browsers.WebDriverBrowserAutoInstall;
import com.atlassian.webdriver.debug.DefaultJavaScriptErrorRetriever;
import com.atlassian.webdriver.debug.JavaScriptErrorInfo;
import com.atlassian.webdriver.debug.JavaScriptErrorRetriever;
import com.atlassian.webdriver.testing.annotation.JavaScriptErrorSkip;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.base.Supplier;
import com.google.common.base.Suppliers;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import javax.inject.Inject;
import org.junit.rules.TestWatcher;
import org.junit.runner.Description;
import org.openqa.selenium.WebDriver;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JavaScriptErrorsRule
extends TestWatcher {
    private static final Logger DEFAULT_LOGGER = LoggerFactory.getLogger(JavaScriptErrorsRule.class);
    public static final String ERROR_SEPARATOR = "\n\n";
    private final Logger logger;
    private final Supplier<? extends WebDriver> webDriver;
    private final ImmutableSet<String> errorsToIgnore;
    private final boolean failOnJavaScriptErrors;
    private final JavaScriptErrorRetriever errorRetriever;

    public JavaScriptErrorsRule(Supplier<? extends WebDriver> webDriver) {
        this(webDriver, DEFAULT_LOGGER);
    }

    public JavaScriptErrorsRule(Supplier<? extends WebDriver> webDriver, Logger logger) {
        this(new DefaultJavaScriptErrorRetriever(webDriver), webDriver, logger, (Set<String>)ImmutableSet.of(), false);
    }

    @Inject
    public JavaScriptErrorsRule(WebDriver webDriver) {
        this((Supplier<? extends WebDriver>)Suppliers.ofInstance((Object)Preconditions.checkNotNull((Object)webDriver, (Object)"webDriver")), DEFAULT_LOGGER);
    }

    public JavaScriptErrorsRule(WebDriver webDriver, Logger logger) {
        this((Supplier<? extends WebDriver>)Suppliers.ofInstance((Object)Preconditions.checkNotNull((Object)webDriver, (Object)"webDriver")));
    }

    public JavaScriptErrorsRule() {
        this(WebDriverBrowserAutoInstall.driverSupplier());
    }

    protected JavaScriptErrorsRule(JavaScriptErrorRetriever errorRetriever, Supplier<? extends WebDriver> webDriver, Logger logger, Set<String> errorsToIgnore, boolean failOnJavaScriptErrors) {
        this.errorRetriever = (JavaScriptErrorRetriever)Preconditions.checkNotNull((Object)errorRetriever, (Object)"errorRetriever");
        this.webDriver = (Supplier)Preconditions.checkNotNull(webDriver, (Object)"webDriver");
        this.logger = (Logger)Preconditions.checkNotNull((Object)logger, (Object)"logger");
        this.errorsToIgnore = ImmutableSet.copyOf((Collection)((Collection)Preconditions.checkNotNull(errorsToIgnore, (Object)"errorsToIgnore")));
        this.failOnJavaScriptErrors = failOnJavaScriptErrors;
    }

    public JavaScriptErrorsRule errorRetriever(JavaScriptErrorRetriever errorRetriever) {
        return new JavaScriptErrorsRule(errorRetriever, this.webDriver, this.logger, (Set<String>)this.errorsToIgnore, this.failOnJavaScriptErrors);
    }

    public JavaScriptErrorsRule errorsToIgnore(Set<String> errorsToIgnore) {
        return new JavaScriptErrorsRule(this.errorRetriever, this.webDriver, this.logger, errorsToIgnore, this.failOnJavaScriptErrors);
    }

    public JavaScriptErrorsRule logger(Logger logger) {
        return new JavaScriptErrorsRule(this.errorRetriever, this.webDriver, logger, (Set<String>)this.errorsToIgnore, this.failOnJavaScriptErrors);
    }

    public JavaScriptErrorsRule failOnJavaScriptErrors(boolean failOnJavaScriptErrors) {
        return new JavaScriptErrorsRule(this.errorRetriever, this.webDriver, this.logger, (Set<String>)this.errorsToIgnore, failOnJavaScriptErrors);
    }

    @VisibleForTesting
    public void finished(Description description) {
        if (this.errorRetriever.isErrorRetrievalSupported()) {
            List<String> errors = this.getErrors();
            if ((errors = this.filterByAnnotation(errors, description)).isEmpty()) {
                this.logger.info("----- Test '{}' finished with 0 JS errors. ", (Object)description.getMethodName());
            } else {
                String consoleOutput = this.getConsoleOutput(errors);
                this.logger.warn("----- Test '{}' finished with {} JS error(s). ", (Object)description.getMethodName(), (Object)errors.size());
                this.logger.warn("----- START CONSOLE OUTPUT DUMP\n\n{}\n", (Object)consoleOutput);
                this.logger.warn("----- END CONSOLE OUTPUT DUMP");
                if (this.failOnJavaScriptErrors) {
                    throw new RuntimeException("Test failed due to javascript errors being detected: \n" + consoleOutput);
                }
            }
        } else {
            this.logger.info("Unable to provide console output. Console output is currently only supported on Firefox.");
        }
    }

    private List<String> filterByAnnotation(List<String> errors, Description description) {
        JavaScriptErrorSkip skip = (JavaScriptErrorSkip)description.getAnnotation(JavaScriptErrorSkip.class);
        if (skip != null && skip.value() != null && skip.value().length > 0) {
            ArrayList<String> ret = new ArrayList<String>();
            for (String error : errors) {
                boolean matches = false;
                for (String regex : skip.value()) {
                    if (!error.matches(regex)) continue;
                    matches = true;
                    break;
                }
                if (matches) continue;
                ret.add(error);
            }
            return ret;
        }
        return errors;
    }

    @VisibleForTesting
    public String getConsoleOutput() {
        return this.getConsoleOutput(this.getErrors());
    }

    private String getConsoleOutput(List<String> errors) {
        return Joiner.on((String)ERROR_SEPARATOR).join(errors);
    }

    @VisibleForTesting
    protected List<String> getErrors() {
        ImmutableList.Builder ret = ImmutableList.builder();
        for (JavaScriptErrorInfo error : this.errorRetriever.getErrors()) {
            if (this.errorsToIgnore.contains((Object)error.getMessage())) {
                this.logger.debug("Ignoring JS error: {}", (Object)error);
                continue;
            }
            ret.add((Object)error.getDescription());
        }
        return ret.build();
    }
}

