/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.webdriver.debug;

import com.atlassian.webdriver.debug.JavaScriptErrorInfo;
import com.atlassian.webdriver.debug.JavaScriptErrorRetriever;
import com.atlassian.webdriver.utils.WebDriverUtil;
import com.google.common.base.Function;
import com.google.common.base.Supplier;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import net.jsourcerer.webdriver.jserrorcollector.JavaScriptError;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.firefox.FirefoxDriver;

public class DefaultJavaScriptErrorRetriever
implements JavaScriptErrorRetriever {
    private final Supplier<? extends WebDriver> webDriver;

    public DefaultJavaScriptErrorRetriever(Supplier<? extends WebDriver> webDriver) {
        this.webDriver = webDriver;
    }

    @Override
    public boolean isErrorRetrievalSupported() {
        return WebDriverUtil.isInstance((WebDriver)this.webDriver.get(), FirefoxDriver.class);
    }

    @Override
    public Iterable<JavaScriptErrorInfo> getErrors() {
        if (this.isErrorRetrievalSupported()) {
            return Iterables.transform((Iterable)JavaScriptError.readErrors((WebDriver)((WebDriver)this.webDriver.get())), (Function)new Function<JavaScriptError, JavaScriptErrorInfo>(){

                public JavaScriptErrorInfo apply(final JavaScriptError e) {
                    return new JavaScriptErrorInfo(){

                        @Override
                        public String getDescription() {
                            return e.toString();
                        }

                        @Override
                        public String getMessage() {
                            return e.getErrorMessage();
                        }
                    };
                }
            });
        }
        return ImmutableList.of();
    }
}

