/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.webdriver.browsers.firefox;

import com.atlassian.browsers.BrowserConfig;
import com.atlassian.webdriver.browsers.profile.ProfilePreferences;
import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.util.Map;
import net.jsourcerer.webdriver.jserrorcollector.JavaScriptError;
import org.openqa.selenium.firefox.FirefoxBinary;
import org.openqa.selenium.firefox.FirefoxDriver;
import org.openqa.selenium.firefox.FirefoxProfile;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class FirefoxBrowser {
    private static final Logger log = LoggerFactory.getLogger(FirefoxBrowser.class);

    private FirefoxBrowser() {
        throw new IllegalStateException("FirefoxBrowser is not constructable");
    }

    public static FirefoxDriver getFirefoxDriver() {
        FirefoxBinary firefox = new FirefoxBinary();
        FirefoxBrowser.setSystemProperties(firefox);
        return FirefoxBrowser.constructFirefoxDriver(firefox, null);
    }

    public static FirefoxDriver getFirefoxDriver(BrowserConfig browserConfig) {
        FirefoxProfile profile = null;
        if (browserConfig != null) {
            FirefoxBinary firefox = new FirefoxBinary(new File(browserConfig.getBinaryPath()));
            if (browserConfig.getProfilePath() != null) {
                File profilePath = new File(browserConfig.getProfilePath());
                profile = new FirefoxProfile();
                FirefoxBrowser.addExtensionsToProfile(profile, profilePath);
                FirefoxBrowser.addPreferencesToProfile(profile, profilePath);
            }
            FirefoxBrowser.setSystemProperties(firefox);
            return FirefoxBrowser.constructFirefoxDriver(firefox, profile);
        }
        return FirefoxBrowser.getFirefoxDriver();
    }

    private static void addPreferencesToProfile(FirefoxProfile profile, File profilePath) {
        File profilePreferencesFile = new File(profilePath, "profile.preferences");
        if (profilePreferencesFile.exists()) {
            ProfilePreferences profilePreferences = new ProfilePreferences(profilePreferencesFile);
            Map<String, Object> preferences = profilePreferences.getPreferences();
            for (String key : preferences.keySet()) {
                Object value = preferences.get(key);
                if (value instanceof Integer) {
                    profile.setPreference(key, ((Integer)value).intValue());
                    continue;
                }
                if (value instanceof Boolean) {
                    profile.setPreference(key, ((Boolean)value).booleanValue());
                    continue;
                }
                profile.setPreference(key, (String)value);
            }
        }
    }

    private static void addExtensionsToProfile(FirefoxProfile profile, File profilePath) {
        for (File extension : profilePath.listFiles(new FileFilter(){

            @Override
            public boolean accept(File file) {
                return file.getName().matches(".*\\.xpi$");
            }
        })) {
            try {
                profile.addExtension(extension);
            }
            catch (IOException e) {
                log.error("Unable to load extension: " + extension, (Throwable)e);
            }
        }
    }

    public static FirefoxDriver getFirefoxDriver(String browserPath) {
        if (browserPath != null) {
            FirefoxBinary firefox = new FirefoxBinary(new File(browserPath));
            FirefoxBrowser.setSystemProperties(firefox);
            return FirefoxBrowser.constructFirefoxDriver(firefox, null);
        }
        log.info("Browser path was null, falling back to default firefox driver.");
        return FirefoxBrowser.getFirefoxDriver();
    }

    private static FirefoxDriver constructFirefoxDriver(FirefoxBinary binary, FirefoxProfile profile) {
        if (profile == null) {
            profile = new FirefoxProfile();
        }
        try {
            JavaScriptError.addExtension((FirefoxProfile)profile);
        }
        catch (IOException e) {
            log.error("Failed to add JavaScriptError extension to profile", (Throwable)e);
        }
        return new FirefoxDriver(binary, profile);
    }

    private static void setSystemProperties(FirefoxBinary firefox) {
        if (System.getProperty("DISPLAY") != null) {
            firefox.setEnvironmentProperty("DISPLAY", System.getProperty("DISPLAY"));
        }
    }
}

