/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.webdriver;

import com.atlassian.browsers.BrowserConfig;
import com.atlassian.pageobjects.browser.Browser;
import com.atlassian.pageobjects.util.BrowserUtil;
import com.atlassian.webdriver.AtlassianWebDriver;
import com.atlassian.webdriver.DefaultAtlassianWebDriver;
import com.atlassian.webdriver.WebDriverFactory;
import com.atlassian.webdriver.browsers.firefox.FirefoxBrowser;
import com.atlassian.webdriver.utils.WebDriverUtil;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.openqa.selenium.Capabilities;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.remote.DesiredCapabilities;
import org.openqa.selenium.remote.RemoteWebDriver;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class RemoteWebDriverFactory {
    private static final Logger log = LoggerFactory.getLogger(WebDriverFactory.class);
    private static final Pattern remoteBrowserPathPattern = Pattern.compile("^([A-Za-z0-9_.-]+):url=(.*)$");

    RemoteWebDriverFactory() {
    }

    public static boolean matches(String browserProperty) {
        return remoteBrowserPathPattern.matcher(browserProperty).matches();
    }

    public static Browser getBrowser(String browserProperty) {
        Matcher matcher = remoteBrowserPathPattern.matcher(browserProperty);
        if (!matcher.matches()) {
            log.warn("Cannot find a url to connect to with a RemoteWebDriver. Falling back to using a local FirefoxDriver instead");
            return Browser.FIREFOX;
        }
        Browser browserType = Browser.typeOf((String)matcher.group(1));
        return browserType;
    }

    public static AtlassianWebDriver getDriver(String browserProperty) {
        return RemoteWebDriverFactory.getDriver(browserProperty, null);
    }

    public static AtlassianWebDriver getDriver(String browserProperty, BrowserConfig browserConfig) {
        DesiredCapabilities capabilities;
        Matcher matcher = remoteBrowserPathPattern.matcher(browserProperty);
        if (!matcher.matches()) {
            log.warn("Cannot find a url to connect to with a RemoteWebDriver. Falling back to using a local FirefoxDriver instead");
            return new DefaultAtlassianWebDriver((WebDriver)FirefoxBrowser.getFirefoxDriver(), Browser.FIREFOX);
        }
        Browser browserType = Browser.typeOf((String)matcher.group(1));
        String serverUrlString = matcher.group(2);
        URL serverUrl = null;
        try {
            StringBuilder sb = new StringBuilder(serverUrlString);
            if (!serverUrlString.contains("wd/hub")) {
                if (!serverUrlString.endsWith("/")) {
                    sb.append("/");
                }
                sb.append("wd/hub");
            }
            serverUrl = new URL(sb.toString());
        }
        catch (MalformedURLException e) {
            log.error("Invalid url provided: '{}', defaulting to http://localhost:4444.", (Object)serverUrlString);
            try {
                serverUrl = new URL("http://localhost:4444/wd/hub");
            }
            catch (MalformedURLException malformedURLException) {
                // empty catch block
            }
        }
        switch (browserType) {
            case FIREFOX: {
                capabilities = DesiredCapabilities.firefox();
                break;
            }
            case CHROME: {
                capabilities = DesiredCapabilities.chrome();
                break;
            }
            case IE: {
                capabilities = DesiredCapabilities.internetExplorer();
                break;
            }
            case HTMLUNIT: {
                capabilities = DesiredCapabilities.htmlUnit();
                break;
            }
            case IPHONE: {
                capabilities = DesiredCapabilities.iphone();
                break;
            }
            case IPAD: {
                capabilities = DesiredCapabilities.ipad();
                break;
            }
            case ANDROID: {
                capabilities = DesiredCapabilities.android();
                break;
            }
            case SAFARI: {
                throw new UnsupportedOperationException("Safari is not a supported Browser Type");
            }
            case OPERA: {
                throw new UnsupportedOperationException("Opera is not a supported Browser Type");
            }
            default: {
                log.error("Unknown browser: {}, defaulting to firefox.", (Object)browserType);
                capabilities = DesiredCapabilities.firefox();
            }
        }
        String capabilitiesStr = System.getProperty("webdriver.capabilities");
        log.info("Loading custom capabilities " + capabilitiesStr);
        DesiredCapabilities customCapabilities = WebDriverUtil.createCapabilitiesFromString(capabilitiesStr);
        capabilities.merge((Capabilities)customCapabilities);
        BrowserUtil.setCurrentBrowser((Browser)browserType);
        RemoteWebDriver driver = new RemoteWebDriver(serverUrl, (Capabilities)capabilities);
        return new DefaultAtlassianWebDriver((WebDriver)driver, browserType);
    }
}

