/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.webdriver;

import com.atlassian.browsers.BrowserConfig;
import com.atlassian.webdriver.AtlassianWebDriver;
import com.atlassian.webdriver.RemoteWebDriverFactory;
import com.atlassian.webdriver.WebDriverFactory;
import com.atlassian.webdriver.browsers.AutoInstallConfiguration;
import com.atlassian.webdriver.utils.WebDriverUtil;
import com.google.common.base.Preconditions;
import com.google.common.base.Supplier;
import java.lang.ref.WeakReference;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebDriverException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LifecycleAwareWebDriverGrid {
    private static final Logger log = LoggerFactory.getLogger(LifecycleAwareWebDriverGrid.class);
    private static final Map<String, AtlassianWebDriver> drivers = new ConcurrentHashMap<String, AtlassianWebDriver>();
    private static volatile AtlassianWebDriver currentDriver;
    private static final Map<String, WeakReference<Thread>> SHUTDOWN_HOOKS;

    private LifecycleAwareWebDriverGrid() {
    }

    public static AtlassianWebDriver getDriver() {
        AtlassianWebDriver driver;
        String browserProperty = WebDriverFactory.getBrowserProperty();
        if (LifecycleAwareWebDriverGrid.browserIsConfigured(browserProperty)) {
            AtlassianWebDriver driver2;
            currentDriver = driver2 = drivers.get(browserProperty);
            return driver2;
        }
        if (RemoteWebDriverFactory.matches(browserProperty)) {
            log.info("Loading remote driver: " + browserProperty);
            driver = RemoteWebDriverFactory.getDriver(browserProperty);
        } else {
            log.info("Loading local driver: " + browserProperty);
            BrowserConfig browserConfig = AutoInstallConfiguration.setupBrowser();
            driver = WebDriverFactory.getDriver(browserConfig);
        }
        drivers.put(browserProperty, driver);
        currentDriver = driver;
        LifecycleAwareWebDriverGrid.addShutdownHook(browserProperty, driver);
        return driver;
    }

    public static AtlassianWebDriver getCurrentDriver() {
        Preconditions.checkState((currentDriver != null ? 1 : 0) != 0, (Object)"The current driver has not been initialised");
        return currentDriver;
    }

    public static Supplier<AtlassianWebDriver> currentDriverSupplier() {
        return new Supplier<AtlassianWebDriver>(){

            public AtlassianWebDriver get() {
                return LifecycleAwareWebDriverGrid.getCurrentDriver();
            }
        };
    }

    public static void shutdown() {
        for (Map.Entry<String, AtlassianWebDriver> driver : drivers.entrySet()) {
            LifecycleAwareWebDriverGrid.quit(driver.getValue());
            LifecycleAwareWebDriverGrid.removeHook(driver);
        }
        drivers.clear();
        SHUTDOWN_HOOKS.clear();
        currentDriver = null;
    }

    private static void removeHook(Map.Entry<String, AtlassianWebDriver> driver) {
        Thread hook;
        WeakReference<Thread> hookRef = SHUTDOWN_HOOKS.get(driver.getKey());
        Thread thread = hook = hookRef != null ? (Thread)hookRef.get() : null;
        if (hook != null) {
            Runtime.getRuntime().removeShutdownHook(hook);
        }
    }

    private static void quit(AtlassianWebDriver webDriver) {
        try {
            webDriver.quit();
        }
        catch (WebDriverException e) {
            LifecycleAwareWebDriverGrid.onQuitError(webDriver, (Exception)((Object)e));
        }
    }

    private static boolean browserIsConfigured(String browserProperty) {
        return drivers.containsKey(browserProperty);
    }

    private static void addShutdownHook(final String browserProperty, final WebDriver driver) {
        Thread quitter = new Thread(){

            @Override
            public void run() {
                log.debug("Running shut down hook for {}", (Object)driver);
                try {
                    drivers.remove(browserProperty);
                    if (driver.equals(currentDriver)) {
                        currentDriver = null;
                    }
                    log.info("Quitting {}", (Object)WebDriverUtil.getUnderlyingDriver(driver));
                    driver.quit();
                    log.debug("Finished shutdown hook {}", (Object)this);
                }
                catch (NullPointerException e) {
                    LifecycleAwareWebDriverGrid.onQuitError(driver, e);
                }
                catch (WebDriverException e) {
                    LifecycleAwareWebDriverGrid.onQuitError(driver, (Exception)((Object)e));
                }
            }
        };
        SHUTDOWN_HOOKS.put(browserProperty, new WeakReference<2>(quitter));
        Runtime.getRuntime().addShutdownHook(quitter);
    }

    private static void onQuitError(WebDriver webDriver, Exception e) {
        log.warn("Exception when trying to quit driver {}: {}", (Object)webDriver, (Object)e.getMessage());
        log.debug("Exception when trying to quit driver - details", (Throwable)e);
    }

    static {
        SHUTDOWN_HOOKS = new ConcurrentHashMap<String, WeakReference<Thread>>();
    }
}

