/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.plugins.rest.doclet.generators.resourcedoc;

import com.atlassian.annotations.ExperimentalApi;
import com.sun.jersey.api.model.AbstractResource;
import com.sun.jersey.api.model.AbstractResourceMethod;
import com.sun.jersey.server.wadl.WadlGenerator;
import com.sun.jersey.server.wadl.generators.resourcedoc.WadlGeneratorResourceDocSupport;
import com.sun.jersey.server.wadl.generators.resourcedoc.model.ResourceDocType;
import com.sun.research.ws.wadl.Method;
import com.sun.research.ws.wadl.Resource;
import java.net.URL;
import java.util.HashMap;
import javax.xml.namespace.QName;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class AtlassianWadlGeneratorResourceDocSupport
extends WadlGeneratorResourceDocSupport {
    private HashMap<String, ResourcePathInformation> resourcePathInformation;
    private static final Logger LOG = LoggerFactory.getLogger(AtlassianWadlGeneratorResourceDocSupport.class);
    private static final String ATLASSIAN_PLUGIN_XML = "atlassian-plugin.xml";

    public AtlassianWadlGeneratorResourceDocSupport() {
    }

    public AtlassianWadlGeneratorResourceDocSupport(WadlGenerator wadlGenerator, ResourceDocType resourceDoc) {
        super(wadlGenerator, resourceDoc);
    }

    public void init() throws Exception {
        super.init();
        this.parseAtlassianPluginXML();
    }

    private void parseAtlassianPluginXML() {
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        try {
            URL resource = ((Object)((Object)this)).getClass().getClassLoader().getResource(ATLASSIAN_PLUGIN_XML);
            if (resource == null) {
                return;
            }
            LOG.info("Found atlassian-plugin.xml file! Looking for rest plugin module descriptors...");
            DocumentBuilder db = dbf.newDocumentBuilder();
            this.resourcePathInformation = new HashMap();
            Document document = db.parse(resource.toExternalForm());
            NodeList restPluginModuleDescriptors = document.getElementsByTagName("rest");
            int numPluginModuleDescriptors = restPluginModuleDescriptors.getLength();
            LOG.info("Found " + numPluginModuleDescriptors + " rest plugin module descriptors.");
            for (int i = 0; i < numPluginModuleDescriptors; ++i) {
                Node node = restPluginModuleDescriptors.item(i);
                NamedNodeMap attributes = node.getAttributes();
                Node pathItem = attributes.getNamedItem("path");
                Node versionItem = attributes.getNamedItem("version");
                if (pathItem == null || versionItem == null) continue;
                String resourcePath = pathItem.getNodeValue();
                String version = versionItem.getNodeValue();
                LOG.info("Found rest end point with path '" + resourcePath + "' and version '" + version + "'");
                if (resourcePath.indexOf("/") != -1) {
                    resourcePath = resourcePath.substring(resourcePath.indexOf("/") + 1);
                }
                NodeList list = node.getChildNodes();
                for (int j = 0; j < list.getLength(); ++j) {
                    Node child = list.item(j);
                    if (!child.getNodeName().equals("package")) continue;
                    String packageName = child.getFirstChild().getNodeValue();
                    LOG.info("Map package '" + packageName + "' to resource path '" + resourcePath + "' and version '" + version + "'");
                    this.resourcePathInformation.put(packageName, new ResourcePathInformation(resourcePath, version));
                }
            }
        }
        catch (Exception ex) {
            LOG.error("Failed to read atlassian-plugin.xml and parse rest plugin module descriptor information. Reason", (Throwable)ex);
        }
    }

    public Resource createResource(AbstractResource r, String path) {
        Resource result = super.createResource(r, path);
        boolean resourcePathChanged = false;
        for (String packageName : this.resourcePathInformation.keySet()) {
            if (!r.getResourceClass().getPackage().getName().startsWith(packageName)) continue;
            ResourcePathInformation pathInformation = this.resourcePathInformation.get(packageName);
            String newPath = pathInformation.getPath() + "/" + pathInformation.getVersion() + "/" + result.getPath();
            result.setPath(newPath);
            resourcePathChanged = true;
            LOG.info("Setting resource path of rest end point '" + r.getResourceClass().getCanonicalName() + "' to '" + newPath + "'");
            break;
        }
        if (!resourcePathChanged) {
            LOG.info("Resource path of rest end point '" + r.getResourceClass().getCanonicalName() + "' unchanged no mapping to rest plugin module descriptor found.");
        }
        return result;
    }

    public Method createMethod(AbstractResource r, AbstractResourceMethod m) {
        Method method = super.createMethod(r, m);
        if (m.getMethod().getAnnotation(ExperimentalApi.class) != null) {
            method.getOtherAttributes().put(new QName("experimental"), Boolean.TRUE.toString());
        }
        return method;
    }

    public class ResourcePathInformation {
        private final String path;
        private final String version;

        public ResourcePathInformation(String path, String version) {
            this.path = path;
            this.version = version;
        }

        public String getVersion() {
            return this.version;
        }

        public String getPath() {
            return this.path;
        }
    }
}

