/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.plugin.repositories;

import com.atlassian.plugin.PluginArtifact;
import com.atlassian.plugin.RevertablePluginInstaller;
import com.atlassian.util.concurrent.CopyOnWriteMap;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Map;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FilePluginInstaller
implements RevertablePluginInstaller {
    private File directory;
    private static final Logger log = LoggerFactory.getLogger(FilePluginInstaller.class);
    private final Map<String, OriginalFile> installedPlugins = CopyOnWriteMap.builder().stableViews().newHashMap();
    public static final String ORIGINAL_PREFIX = ".original-";

    public FilePluginInstaller(File directory) {
        Validate.isTrue((directory != null && directory.exists() ? 1 : 0) != 0, (String)"The plugin installation directory must exist");
        this.directory = directory;
    }

    public void installPlugin(String key, PluginArtifact pluginArtifact) {
        Validate.notNull((Object)key, (String)"The plugin key must be specified");
        Validate.notNull((Object)pluginArtifact, (String)"The plugin artifact must not be null");
        File newPluginFile = new File(this.directory, pluginArtifact.getName());
        try {
            this.backup(key, newPluginFile);
            if (newPluginFile.exists()) {
                newPluginFile.delete();
            }
        }
        catch (IOException e) {
            log.warn("Unable to backup old file", (Throwable)e);
        }
        FileOutputStream os = null;
        InputStream in = null;
        try {
            os = new FileOutputStream(newPluginFile);
            in = pluginArtifact.getInputStream();
            IOUtils.copy((InputStream)in, (OutputStream)os);
        }
        catch (IOException e) {
            try {
                throw new RuntimeException("Could not install plugin: " + pluginArtifact, e);
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(in);
                IOUtils.closeQuietly((OutputStream)os);
                throw throwable;
            }
        }
        IOUtils.closeQuietly((InputStream)in);
        IOUtils.closeQuietly((OutputStream)os);
    }

    public void revertInstalledPlugin(String pluginKey) {
        OriginalFile orig = this.installedPlugins.get(pluginKey);
        if (orig != null) {
            File origFile = new File(orig.getBackupFile().getParent(), orig.getOriginalName());
            if (origFile.exists()) {
                origFile.delete();
            }
            if (orig.isUpgrade()) {
                try {
                    FileUtils.moveFile((File)orig.getBackupFile(), (File)origFile);
                }
                catch (IOException e) {
                    log.warn("Unable to restore old plugin for " + pluginKey);
                }
            }
        }
    }

    public void clearBackups() {
        for (File file : this.directory.listFiles(new BackupNameFilter())) {
            file.delete();
        }
        this.installedPlugins.clear();
    }

    private void backup(String pluginKey, File oldPluginFile) throws IOException {
        if (!this.installedPlugins.containsKey(pluginKey)) {
            OriginalFile orig;
            if (oldPluginFile.exists()) {
                File backupFile = new File(oldPluginFile.getParent(), ORIGINAL_PREFIX + oldPluginFile.getName());
                if (backupFile.exists()) {
                    throw new IOException("Existing backup found for plugin " + pluginKey + ".  Cannot install.");
                }
                FileUtils.copyFile((File)oldPluginFile, (File)backupFile);
                orig = new OriginalFile(backupFile, oldPluginFile.getName());
            } else {
                orig = new OriginalFile(oldPluginFile, oldPluginFile.getName());
            }
            this.installedPlugins.put(pluginKey, orig);
        }
    }

    private static class OriginalFile {
        private final File backupFile;
        private final String originalName;
        private final boolean isUpgrade;

        public OriginalFile(File backupFile, String originalName) {
            this.backupFile = backupFile;
            this.originalName = originalName;
            this.isUpgrade = !backupFile.getName().equals(originalName);
        }

        public File getBackupFile() {
            return this.backupFile;
        }

        public String getOriginalName() {
            return this.originalName;
        }

        public boolean isUpgrade() {
            return this.isUpgrade;
        }
    }

    private static class BackupNameFilter
    implements FilenameFilter {
        private BackupNameFilter() {
        }

        public boolean accept(File dir, String name) {
            return name.startsWith(FilePluginInstaller.ORIGINAL_PREFIX);
        }
    }
}

