/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.plugin.manager;

import com.atlassian.plugin.Plugin;
import com.atlassian.plugin.PluginAccessor;
import com.atlassian.plugin.PluginController;
import com.atlassian.plugin.PluginState;
import com.atlassian.plugin.util.PluginUtils;
import com.atlassian.plugin.util.WaitUntil;
import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class PluginEnabler {
    private static final Logger log = LoggerFactory.getLogger(PluginEnabler.class);
    private static final long LAST_PLUGIN_TIMEOUT = 5000L;
    private final PluginAccessor pluginAccessor;
    private final PluginController pluginController;

    public PluginEnabler(PluginAccessor pluginAccessor, PluginController pluginController) {
        this.pluginAccessor = pluginAccessor;
        this.pluginController = pluginController;
    }

    Collection<Plugin> enableAllRecursively(Collection<Plugin> plugins) {
        ArrayList<Plugin> pluginsToEnable = new ArrayList<Plugin>();
        HashSet<String> dependentKeys = new HashSet<String>();
        for (Plugin plugin : plugins) {
            this.scanDependencies(plugin, dependentKeys);
        }
        for (String key : dependentKeys) {
            pluginsToEnable.add(this.pluginAccessor.getPlugin(key));
        }
        this.enable(pluginsToEnable);
        ImmutableList.Builder enabledPlugins = new ImmutableList.Builder();
        for (Plugin plugin : pluginsToEnable) {
            if (!plugin.getPluginState().equals((Object)PluginState.ENABLED)) continue;
            enabledPlugins.add((Object)plugin);
        }
        return enabledPlugins.build();
    }

    void enable(Collection<Plugin> plugins) {
        final HashSet<Plugin> pluginsInEnablingState = new HashSet<Plugin>();
        for (Plugin plugin : plugins) {
            try {
                plugin.enable();
                if (plugin.getPluginState() != PluginState.ENABLING) continue;
                pluginsInEnablingState.add(plugin);
            }
            catch (RuntimeException ex) {
                log.error("Unable to enable plugin " + plugin.getKey(), (Throwable)ex);
            }
        }
        if (!pluginsInEnablingState.isEmpty()) {
            WaitUntil.invoke(new WaitUntil.WaitCondition(){
                private long singlePluginTimeout;

                public boolean isFinished() {
                    if (this.singlePluginTimeout > 0L && this.singlePluginTimeout < System.currentTimeMillis()) {
                        return true;
                    }
                    Iterator i = pluginsInEnablingState.iterator();
                    while (i.hasNext()) {
                        Plugin plugin = (Plugin)i.next();
                        if (plugin.getPluginState() == PluginState.ENABLING) continue;
                        i.remove();
                    }
                    if (this.isAtlassianDevMode() && pluginsInEnablingState.size() == 1 && this.singlePluginTimeout == 0L) {
                        log.info("Only one plugin left not enabled. Resetting the timeout to 5 seconds.");
                        this.singlePluginTimeout = System.currentTimeMillis() + 5000L;
                    }
                    return pluginsInEnablingState.isEmpty();
                }

                public String getWaitMessage() {
                    return "Plugins that have yet to be enabled: " + pluginsInEnablingState;
                }

                private boolean isAtlassianDevMode() {
                    return Boolean.getBoolean("atlassian.dev.mode");
                }
            }, PluginUtils.getDefaultEnablingWaitPeriod(), TimeUnit.SECONDS, 1);
            if (!pluginsInEnablingState.isEmpty()) {
                StringBuilder sb = new StringBuilder();
                for (Plugin plugin : pluginsInEnablingState) {
                    sb.append(plugin.getKey()).append(',');
                    this.pluginController.disablePluginWithoutPersisting(plugin.getKey());
                }
                sb.deleteCharAt(sb.length() - 1);
                log.error("Unable to start the following plugins due to timeout while waiting for plugin to enable: " + sb.toString());
            }
        }
    }

    private void scanDependencies(Plugin plugin, Set<String> dependentKeys) {
        dependentKeys.add(plugin.getKey());
        for (String dependencyKey : plugin.getRequiredPlugins()) {
            if (dependentKeys.contains(dependencyKey) || this.pluginAccessor.getPlugin(dependencyKey) == null || this.pluginAccessor.isPluginEnabled(dependencyKey)) continue;
            this.scanDependencies(this.pluginAccessor.getPlugin(dependencyKey), dependentKeys);
        }
    }
}

