/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.plugin.classloader;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Enumeration;
import org.apache.commons.lang.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DelegationClassLoader
extends ClassLoader {
    private static final Logger log = LoggerFactory.getLogger(DelegationClassLoader.class);
    private ClassLoader delegateClassLoader = DelegationClassLoader.class.getClassLoader();

    public void setDelegateClassLoader(ClassLoader delegateClassLoader) {
        Validate.notNull((Object)delegateClassLoader, (String)"Can't set the delegation target to null");
        if (log.isDebugEnabled()) {
            log.debug("Update class loader delegation from [" + this.delegateClassLoader + "] to [" + delegateClassLoader + "]");
        }
        this.delegateClassLoader = delegateClassLoader;
    }

    public Class loadClass(String name) throws ClassNotFoundException {
        return this.delegateClassLoader.loadClass(name);
    }

    @Override
    public URL getResource(String name) {
        return this.delegateClassLoader.getResource(name);
    }

    @Override
    public Enumeration<URL> getResources(String name) throws IOException {
        return this.delegateClassLoader.getResources(name);
    }

    @Override
    public InputStream getResourceAsStream(String name) {
        return this.delegateClassLoader.getResourceAsStream(name);
    }

    @Override
    public synchronized void setDefaultAssertionStatus(boolean enabled) {
        this.delegateClassLoader.setDefaultAssertionStatus(enabled);
    }

    @Override
    public synchronized void setPackageAssertionStatus(String packageName, boolean enabled) {
        this.delegateClassLoader.setPackageAssertionStatus(packageName, enabled);
    }

    @Override
    public synchronized void setClassAssertionStatus(String className, boolean enabled) {
        this.delegateClassLoader.setClassAssertionStatus(className, enabled);
    }

    @Override
    public synchronized void clearAssertionStatus() {
        this.delegateClassLoader.clearAssertionStatus();
    }
}

