/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.plugin;

import com.atlassian.plugin.PluginParseException;
import com.atlassian.plugin.Resourced;
import com.atlassian.plugin.elements.ResourceDescriptor;
import com.atlassian.plugin.elements.ResourceLocation;
import com.atlassian.plugin.util.Assertions;
import com.google.common.base.Predicate;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.dom4j.Element;

public class Resources
implements Resourced {
    public static final Resources EMPTY_RESOURCES = new Resources(Collections.<ResourceDescriptor>emptyList());
    private final List<ResourceDescriptor> resourceDescriptors;

    public static Resources fromXml(Element element) throws PluginParseException, IllegalArgumentException {
        if (element == null) {
            throw new IllegalArgumentException("Cannot parse resources from null XML element");
        }
        List elements = element.elements("resource");
        ArrayList<ResourceDescriptor> templates = new ArrayList<ResourceDescriptor>(elements.size());
        for (Element e : elements) {
            ResourceDescriptor resourceDescriptor = new ResourceDescriptor(e);
            if (templates.contains(resourceDescriptor)) {
                throw new PluginParseException("Duplicate resource with type '" + resourceDescriptor.getType() + "' and name '" + resourceDescriptor.getName() + "' found");
            }
            templates.add(resourceDescriptor);
        }
        return new Resources(templates);
    }

    public Resources(Iterable<ResourceDescriptor> resourceDescriptors) throws IllegalArgumentException {
        com.atlassian.util.concurrent.Assertions.notNull((String)"Resources cannot be created with a null resources list. Pass empty list instead", resourceDescriptors);
        this.resourceDescriptors = ImmutableList.builder().addAll(resourceDescriptors).build();
    }

    @Override
    public List<ResourceDescriptor> getResourceDescriptors() {
        return this.resourceDescriptors;
    }

    @Override
    @Deprecated
    public List<ResourceDescriptor> getResourceDescriptors(String type) {
        return ImmutableList.builder().addAll(Iterables.filter(this.resourceDescriptors, (Predicate)new TypeFilter(type))).build();
    }

    @Override
    public ResourceLocation getResourceLocation(String type, String name) {
        for (ResourceDescriptor resourceDescriptor : this.resourceDescriptors) {
            if (!resourceDescriptor.doesTypeAndNameMatch(type, name)) continue;
            return resourceDescriptor.getResourceLocationForName(name);
        }
        return null;
    }

    @Override
    public ResourceDescriptor getResourceDescriptor(String type, String name) {
        for (ResourceDescriptor resourceDescriptor : this.resourceDescriptors) {
            if (!resourceDescriptor.getType().equalsIgnoreCase(type) || !resourceDescriptor.getName().equalsIgnoreCase(name)) continue;
            return resourceDescriptor;
        }
        return null;
    }

    public static class TypeFilter
    implements Predicate<ResourceDescriptor> {
        private final String type;

        public TypeFilter(String type) {
            this.type = Assertions.notNull("type", type);
        }

        public boolean apply(ResourceDescriptor input) {
            return this.type.equals(input.getType());
        }
    }
}

