/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.plugin;

import com.atlassian.plugin.JarPluginArtifact;
import com.atlassian.plugin.PluginArtifact;
import com.atlassian.plugin.PluginArtifactFactory;
import com.atlassian.plugin.XmlPluginArtifact;
import java.io.File;
import java.net.URI;

public class DefaultPluginArtifactFactory
implements PluginArtifactFactory {
    @Override
    public PluginArtifact create(URI artifactUri) {
        PluginArtifact artifact = null;
        String protocol = artifactUri.getScheme();
        if ("file".equalsIgnoreCase(protocol)) {
            File artifactFile = new File(artifactUri);
            String file = artifactFile.getName();
            if (file.endsWith(".jar")) {
                artifact = new JarPluginArtifact(artifactFile);
            } else if (file.endsWith(".xml")) {
                artifact = new XmlPluginArtifact(artifactFile);
            }
        }
        if (artifact == null) {
            throw new IllegalArgumentException("The artifact URI " + artifactUri + " is not a valid plugin artifact");
        }
        return artifact;
    }
}

