/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.maven.plugins.amps;

import com.atlassian.maven.plugins.amps.AbstractProductHandlerMojo;
import com.atlassian.maven.plugins.amps.MavenContext;
import com.atlassian.maven.plugins.amps.MavenGoals;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.execution.ReactorManager;
import org.apache.maven.model.Plugin;
import org.apache.maven.model.PluginManagement;
import org.apache.maven.model.locator.DefaultModelLocator;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;
import org.apache.maven.project.MavenProjectBuilder;
import org.apache.maven.project.ProjectBuilder;
import org.apache.maven.project.ProjectBuilderConfiguration;
import org.apache.maven.project.ProjectBuildingException;
import org.apache.maven.project.ProjectBuildingRequest;
import org.apache.maven.project.ProjectBuildingResult;
import org.codehaus.plexus.component.repository.exception.ComponentLookupException;
import org.codehaus.plexus.util.xml.Xpp3Dom;

@Mojo(name="run-standalone", requiresProject=false)
public class RunStandaloneMojo
extends AbstractProductHandlerMojo {
    private final String GROUP_ID = "com.atlassian.amps";
    private final String ARTIFACT_ID = "standalone";
    @Parameter(property="component.org.apache.maven.project.MavenProjectBuilder", required=true, readonly=true)
    private MavenProjectBuilder projectBuilder;

    private Artifact getStandaloneArtifact() {
        String version = this.getPluginInformation().getVersion();
        return this.artifactFactory.createProjectArtifact("com.atlassian.amps", "standalone", version);
    }

    protected String getAmpsGoal() {
        return "run";
    }

    @Override
    protected void doExecute() throws MojoExecutionException, MojoFailureException {
        this.getUpdateChecker().check();
        this.promptForEmailSubscriptionIfNeeded();
        this.trackFirstRunIfNeeded();
        this.getGoogleTracker().track("Run Standalone");
        try {
            Xpp3Dom configuration;
            MavenGoals goals;
            try {
                Object o = this.getMavenContext().getSession().lookup("org.apache.maven.project.ProjectBuilder");
                goals = this.createMavenGoals((ProjectBuilder)o);
                PluginManagement mgmt = goals.getContextProject().getBuild().getPluginManagement();
                Plugin plugin = (Plugin)mgmt.getPluginsAsMap().get("com.atlassian.maven.plugins:maven-amps-plugin");
                configuration = (Xpp3Dom)plugin.getConfiguration();
            }
            catch (ComponentLookupException e) {
                goals = this.createMavenGoals(this.projectBuilder);
                configuration = new Xpp3Dom("configuration");
            }
            goals.executeAmpsRecursively(this.getPluginInformation().getVersion(), this.getAmpsGoal(), configuration);
        }
        catch (Exception e) {
            throw new MojoExecutionException(e.getMessage(), e);
        }
    }

    protected MavenGoals createMavenGoals(MavenProjectBuilder projectBuilder) throws MojoExecutionException, MojoFailureException {
        String version = this.getPluginInformation().getVersion();
        Artifact artifact = this.artifactFactory.createProjectArtifact("com.atlassian.amps", "standalone", version);
        try {
            MavenContext oldContext = this.getMavenContext();
            MavenProject oldProject = oldContext.getProject();
            MavenProject newProject = projectBuilder.buildFromRepository(artifact, this.repositories, this.localRepository);
            newProject.setRemoteArtifactRepositories(oldProject.getRemoteArtifactRepositories());
            newProject.setPluginArtifactRepositories(oldProject.getPluginArtifactRepositories());
            List<MavenProject> newReactor = Collections.singletonList(newProject);
            MavenSession oldSession = oldContext.getSession();
            MavenSession newSession = new MavenSession(oldSession.getContainer(), oldSession.getSettings(), oldSession.getLocalRepository(), oldSession.getEventDispatcher(), new ReactorManager(newReactor), oldSession.getGoals(), oldSession.getExecutionRootDirectory(), oldSession.getExecutionProperties(), oldSession.getUserProperties(), oldSession.getStartTime());
            String baseDir = System.getProperty("user.dir") + "/amps-standalone/";
            newProject.setFile(new File(baseDir, "pom.xml"));
            newProject.getProperties().putAll((Map<?, ?>)oldProject.getProperties());
            ProjectBuilderConfiguration projectBuilderConfiguration = RunStandaloneMojo.getProjectBuilderConfigurationFromMavenSession(newSession);
            projectBuilder.calculateConcreteState(newProject, projectBuilderConfiguration);
            MavenContext newContext = oldContext.with(newProject, newReactor, newSession);
            return new MavenGoals(newContext);
        }
        catch (Exception e) {
            throw new MojoExecutionException(e.getMessage(), e);
        }
    }

    private static ProjectBuilderConfiguration getProjectBuilderConfigurationFromMavenSession(MavenSession session) throws MojoExecutionException, InvocationTargetException, IllegalAccessException {
        try {
            Method m = MavenSession.class.getMethod("getProjectBuilderConfiguration", new Class[0]);
            return (ProjectBuilderConfiguration)m.invoke((Object)session, new Object[0]);
        }
        catch (NoSuchMethodException e) {
            throw new MojoExecutionException("Maven 3 is not supported for run-standalone", (Exception)e);
        }
    }

    protected MavenGoals createMavenGoals(ProjectBuilder projectBuilder) throws MojoExecutionException, MojoFailureException, ProjectBuildingException, IOException {
        MavenContext oldContext = this.getMavenContext();
        MavenSession oldSession = oldContext.getSession();
        File base = new File("amps-standalone").getAbsoluteFile();
        ProjectBuildingRequest pbr = oldSession.getProjectBuildingRequest();
        pbr.setRemoteRepositories(oldSession.getCurrentProject().getRemoteArtifactRepositories());
        pbr.setPluginArtifactRepositories(oldSession.getCurrentProject().getPluginArtifactRepositories());
        pbr.getSystemProperties().setProperty("project.basedir", base.getPath());
        ProjectBuildingResult result = projectBuilder.build(this.getStandaloneArtifact(), false, pbr);
        List<MavenProject> newReactor = Collections.singletonList(result.getProject());
        MavenSession newSession = oldSession.clone();
        newSession.setProjects(newReactor);
        result.getProject().setFile(new DefaultModelLocator().locatePom(base));
        MavenContext newContext = oldContext.with(result.getProject(), newReactor, newSession);
        return new MavenGoals(newContext);
    }
}

