/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.maven.plugins.amps;

import com.atlassian.maven.plugins.amps.AbstractProductHandlerMojo;
import com.atlassian.maven.plugins.amps.Product;
import com.atlassian.maven.plugins.amps.ProductExecution;
import com.atlassian.maven.plugins.amps.TestGroup;
import com.atlassian.maven.plugins.amps.product.ProductHandler;
import com.atlassian.maven.plugins.amps.product.ProductHandlerFactory;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.Parameter;

public abstract class AbstractTestGroupsHandlerMojo
extends AbstractProductHandlerMojo {
    @Parameter
    private List<TestGroup> testGroups = new ArrayList<TestGroup>();

    protected final List<TestGroup> getTestGroups() {
        return this.testGroups;
    }

    protected final List<ProductExecution> getTestGroupProductExecutions(String testGroupId) throws MojoExecutionException {
        ArrayList<ProductExecution> products = new ArrayList<ProductExecution>();
        int dupCounter = 0;
        HashSet<String> uniqueProductIds = new HashSet<String>();
        Map<String, Product> productContexts = this.getProductContexts();
        for (String instanceId : this.getTestGroupInstanceIds(testGroupId)) {
            Product ctx = productContexts.get(instanceId);
            if (ctx == null) {
                throw new MojoExecutionException("The test group '" + testGroupId + "' refers to a product '" + instanceId + "' that doesn't have an associated <product> configuration.");
            }
            ProductHandler productHandler = this.createProductHandler(ctx.getId());
            if (uniqueProductIds.contains(instanceId)) {
                ctx.setInstanceId(instanceId + "-" + dupCounter++);
            } else {
                uniqueProductIds.add(instanceId);
            }
            products.add(new ProductExecution(ctx, productHandler));
        }
        return products;
    }

    private List<String> getTestGroupInstanceIds(String testGroupId) throws MojoExecutionException {
        ArrayList<String> instanceIds = new ArrayList<String>();
        if ("__no_test_group__".equals(testGroupId)) {
            instanceIds.add(this.getProductId());
        }
        for (TestGroup group : this.testGroups) {
            if (!group.getId().equals(testGroupId)) continue;
            instanceIds.addAll(group.getInstanceIds());
        }
        if (ProductHandlerFactory.getIds().contains(testGroupId) && !instanceIds.contains(testGroupId)) {
            instanceIds.add(testGroupId);
        }
        if (instanceIds.isEmpty()) {
            ArrayList<String> validTestGroups = new ArrayList<String>();
            for (TestGroup group : this.testGroups) {
                validTestGroups.add(group.getId());
            }
            throw new MojoExecutionException("Unknown test group ID: " + testGroupId + " Detected IDs: " + Arrays.toString(validTestGroups.toArray()));
        }
        return instanceIds;
    }
}

