/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.rest.client.internal.json;

import com.atlassian.jira.rest.client.domain.Issue;
import com.atlassian.jira.rest.client.domain.SearchResult;
import com.atlassian.jira.rest.client.internal.json.BasicIssueJsonParser;
import com.atlassian.jira.rest.client.internal.json.IssueJsonParser;
import com.atlassian.jira.rest.client.internal.json.JsonObjectParser;
import com.atlassian.jira.rest.client.internal.json.JsonParseUtil;
import java.util.Collection;
import org.codehaus.jettison.json.JSONException;
import org.codehaus.jettison.json.JSONObject;

public class SearchResultJsonParser
implements JsonObjectParser<SearchResult> {
    private final boolean full;

    public SearchResultJsonParser(boolean full) {
        this.full = full;
    }

    @Override
    public SearchResult parse(JSONObject json) throws JSONException {
        int startAt = json.getInt("startAt");
        int maxResults = json.getInt("maxResults");
        int total = json.getInt("total");
        JSONObject names = JsonParseUtil.getOptionalJsonObject(json, "names");
        JSONObject schema = JsonParseUtil.getOptionalJsonObject(json, "schema");
        Collection<Issue> issues = JsonParseUtil.parseJsonArray(json.getJSONArray("issues"), this.full ? new IssueJsonParser(true, names, schema) : new BasicIssueJsonParser());
        return new SearchResult(startAt, maxResults, total, issues);
    }
}

