/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.rest.client.domain.input;

import com.atlassian.jira.rest.client.domain.BasicComponent;
import com.atlassian.jira.rest.client.domain.BasicIssueType;
import com.atlassian.jira.rest.client.domain.BasicPriority;
import com.atlassian.jira.rest.client.domain.BasicProject;
import com.atlassian.jira.rest.client.domain.BasicUser;
import com.atlassian.jira.rest.client.domain.EntityHelper;
import com.atlassian.jira.rest.client.domain.IssueFieldId;
import com.atlassian.jira.rest.client.domain.Version;
import com.atlassian.jira.rest.client.domain.input.BaseValueTransformer;
import com.atlassian.jira.rest.client.domain.input.CannotTransformValueException;
import com.atlassian.jira.rest.client.domain.input.ComplexIssueInputFieldValue;
import com.atlassian.jira.rest.client.domain.input.FieldInput;
import com.atlassian.jira.rest.client.domain.input.IssueInput;
import com.atlassian.jira.rest.client.domain.input.ValueTransformerManager;
import com.atlassian.jira.rest.client.internal.json.JsonParseUtil;
import com.google.common.base.Function;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.Map;
import org.joda.time.DateTime;

public class IssueInputBuilder {
    private final ValueTransformerManager valueTransformerManager = new ValueTransformerManager().registerTransformer(new BaseValueTransformer());
    private Map<String, FieldInput> fields = Maps.newHashMap();

    public IssueInputBuilder(String projectKey, Long issueTypeId) {
        this.setProjectKey(projectKey);
        this.setIssueTypeId(issueTypeId);
    }

    public IssueInputBuilder(BasicProject project, BasicIssueType issueType) {
        this.setProject(project);
        this.setIssueType(issueType);
    }

    public IssueInputBuilder(String projectKey, Long issueTypeId, String summary) {
        this(projectKey, issueTypeId);
        this.setSummary(summary);
    }

    public IssueInputBuilder(BasicProject project, BasicIssueType issueType, String summary) {
        this(project, issueType);
        this.setSummary(summary);
    }

    public IssueInputBuilder setSummary(String summary) {
        return this.setFieldInput(new FieldInput(IssueFieldId.SUMMARY_FIELD, (Object)summary));
    }

    public IssueInputBuilder setProjectKey(String projectKey) {
        return this.setFieldInput(new FieldInput(IssueFieldId.PROJECT_FIELD, (Object)ComplexIssueInputFieldValue.with("key", projectKey)));
    }

    public IssueInputBuilder setProject(BasicProject project) {
        return this.setProjectKey(project.getKey());
    }

    public IssueInputBuilder setIssueTypeId(Long issueTypeId) {
        return this.setFieldInput(new FieldInput(IssueFieldId.ISSUE_TYPE_FIELD, (Object)ComplexIssueInputFieldValue.with("id", issueTypeId.toString())));
    }

    public IssueInputBuilder setIssueType(BasicIssueType issueType) {
        return this.setIssueTypeId(issueType.getId());
    }

    public IssueInputBuilder setFieldInput(FieldInput fieldInput) {
        this.fields.put(fieldInput.getId(), fieldInput);
        return this;
    }

    public IssueInputBuilder setFieldValue(String id, ComplexIssueInputFieldValue value) {
        return this.setFieldInput(new FieldInput(id, (Object)value));
    }

    public IssueInputBuilder setFieldValue(String id, Object value) throws CannotTransformValueException {
        return this.setFieldInput(new FieldInput(id, this.valueTransformerManager.apply(value)));
    }

    public IssueInputBuilder setDescription(String summary) {
        return this.setFieldInput(new FieldInput(IssueFieldId.DESCRIPTION_FIELD, (Object)summary));
    }

    public IssueInputBuilder setAssignee(BasicUser assignee) {
        return this.setAssigneeName(assignee.getName());
    }

    public IssueInputBuilder setAssigneeName(String assignee) {
        return this.setFieldInput(new FieldInput(IssueFieldId.ASSIGNEE_FIELD, (Object)ComplexIssueInputFieldValue.with("name", assignee)));
    }

    public IssueInput build() {
        return new IssueInput(this.fields);
    }

    public IssueInputBuilder setAffectedVersions(Iterable<Version> versions) {
        return this.setAffectedVersionsNames(EntityHelper.toNamesList(versions));
    }

    public IssueInputBuilder setAffectedVersionsNames(Iterable<String> names) {
        return this.setFieldInput(new FieldInput(IssueFieldId.AFFECTS_VERSIONS_FIELD, this.toListOfComplexIssueInputFieldValueWithSingleKey(names, "name")));
    }

    public IssueInputBuilder setComponentsNames(Iterable<String> names) {
        return this.setFieldInput(new FieldInput(IssueFieldId.COMPONENTS_FIELD, this.toListOfComplexIssueInputFieldValueWithSingleKey(names, "name")));
    }

    public IssueInputBuilder setComponents(Iterable<BasicComponent> basicComponents) {
        return this.setComponentsNames(EntityHelper.toNamesList(basicComponents));
    }

    public IssueInputBuilder setComponents(BasicComponent ... basicComponents) {
        return this.setComponents(Lists.newArrayList((Object[])basicComponents));
    }

    public IssueInputBuilder setDueDate(DateTime date) {
        return this.setFieldInput(new FieldInput(IssueFieldId.DUE_DATE_FIELD, (Object)JsonParseUtil.formatDate(date)));
    }

    public IssueInputBuilder setFixVersionsNames(Iterable<String> names) {
        return this.setFieldInput(new FieldInput(IssueFieldId.FIX_VERSIONS_FIELD, this.toListOfComplexIssueInputFieldValueWithSingleKey(names, "name")));
    }

    public IssueInputBuilder setFixVersions(Iterable<Version> versions) {
        return this.setFixVersionsNames(EntityHelper.toNamesList(versions));
    }

    public IssueInputBuilder setPriority(BasicPriority priority) {
        return this.setPriorityId(priority.getId());
    }

    public IssueInputBuilder setPriorityId(Long id) {
        return this.setFieldInput(new FieldInput(IssueFieldId.PRIORITY_FIELD, (Object)ComplexIssueInputFieldValue.with("id", id.toString())));
    }

    public IssueInputBuilder setReporter(BasicUser reporter) {
        return this.setReporterName(reporter.getName());
    }

    public IssueInputBuilder setReporterName(String reporterName) {
        return this.setFieldInput(new FieldInput(IssueFieldId.REPORTER_FIELD, (Object)ComplexIssueInputFieldValue.with("name", reporterName)));
    }

    public ValueTransformerManager getValueTransformerManager() {
        return this.valueTransformerManager;
    }

    private <T> Iterable<ComplexIssueInputFieldValue> toListOfComplexIssueInputFieldValueWithSingleKey(Iterable<T> items, final String key) {
        return Iterables.transform(items, (Function)new Function<T, ComplexIssueInputFieldValue>(){

            public ComplexIssueInputFieldValue apply(T value) {
                return ComplexIssueInputFieldValue.with(key, value);
            }
        });
    }
}

